Copyright (c) 2005 X.Org Foundation L.L.C.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
$Header: /usr4/cvs/vsw5/tset/Xt12/tregccon/tregccon.m,v 8.0 1998/12/23 23:38:02 mar Rel $

Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
All Rights Reserved.

>># 
>># Project: VSW5
>># 
>># File: tset/Xt12/tregccon/tregccon.m
>># 
>># Description:
>>#	Tests for XtRegisterCaseConverter()
>># 
>># Modifications:
>># $Log: tregccon.m,v $
>># Revision 8.0  1998/12/23 23:38:02  mar
>># Branch point for Release 5.0.2
>>#
>># Revision 7.0  1998/10/30 23:01:01  mar
>># Branch point for Release 5.0.2b1
>>#
>># Revision 6.0  1998/03/02 05:29:04  tbr
>># Branch point for Release 5.0.1
>>#
>># Revision 5.0  1998/01/26 03:25:38  tbr
>># Branch point for Release 5.0.1b1
>>#
>># Revision 4.0  1995/12/15 09:21:13  tbr
>># Branch point for Release 5.0.0
>>#
>># Revision 3.1  1995/12/15  02:16:53  andy
>># Prepare for GA Release
>>#
>>EXTERN
#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtCPP_Proc(dpy, sym, lower, upper)
Display *dpy;
KeySym sym;
KeySym *lower;
KeySym *upper;
{
	avs_set_event(1,1);
	exit(0);
}
void XtCPP_Proc2(dpy, sym, lower, upper)
Display *dpy;
KeySym sym;
KeySym *lower;
KeySym *upper;
{
	avs_set_event(2,1);
	exit(0);
}
>>SET tpstartup avs_alloc_sem
>>SET tpcleanup avs_free_sem
>>TITLE XtRegisterCaseConverter Xt12
void
XtRegisterCaseConverter(display, proc, start, stop)
>>ASSERTION Good A
A call to 
void XtRegisterCaseConverter(display, proc, start, stop)
shall register 
.A proc
as the procedure that will be called when a case conversion
is requested by a call to XtConvertCase for a KeySym value 
that is in the range specified by
.A start
and 
.A stop
and associated with the display
.A display.
>>CODE
Display *display;
KeySym keysym;
KeySym lower_return;
KeySym upper_return;
int invoked;
pid_t pid2;

	FORK(pid2);
	avs_xt_hier("Tregccon1", "XtRegisterCaseConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'a'");
	keysym = XStringToKeysym("a");
	tet_infoline("PREP: Register case converter XtCPP_Proc");
	XtRegisterCaseConverter(display, &XtCPP_Proc, keysym, keysym);
	tet_infoline("PREP: Get upper and lower case version of a keysym");
	XtConvertCase(display, keysym, &lower_return, &upper_return);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Case converter was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCPP_Proc invoked count");
	tet_result(TET_PASS);
>>ASSERTION Good A
On a call to
void XtRegisterCaseConverter(display, proc, start, stop)
when a converter has already been registered for the KeySym
range specified by
.A start
and 
.A stop
the converter
.A proc
shall override the existing converter.
>>CODE
Display *display;
KeySym keysym;
KeySym lower_return;
KeySym upper_return;
int invoked;
pid_t pid2;

	FORK(pid2);
	avs_xt_hier("Tregccon1", "XtRegisterCaseConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'a'");
	keysym = XStringToKeysym("a");
	tet_infoline("PREP: Register case converter XtCPP_Proc");
	XtRegisterCaseConverter(display, &XtCPP_Proc, keysym, keysym);
	tet_infoline("PREP: Register a second case converter for same range");
	XtRegisterCaseConverter(display, &XtCPP_Proc2, keysym, keysym);
	tet_infoline("PREP: Get upper and lower case version of a keysym");
	XtConvertCase(display, keysym, &lower_return, &upper_return);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Second Case converter was invoked");
	invoked = avs_get_event(2);
	check_dec(1, invoked, "XtCPP_Proc2 invoked count");
	tet_result(TET_PASS);
