/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XDrawImageString(display, d, gc, x, y, string, length)
 *   Display	*display;
 *   Drawable d;
 *   GC		gc;
 *   int 	x;
 *   int 	y;
 *   char	*string;
 *   int 	length;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XDrawImageString	1
char    *TestName = "XDrawImageString";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_DRAWABLE d
#define A_GC gc


/*
 * Arguments to the XDrawImageString function
 */
static Display	*display;
static Drawable d;
static GC		gc;
static int 	x;
static int 	y;
static char	*string;
static int 	length;



/* Needed because function not used */
#define	A_DRAW	A_DRAWABLE

static	Font	Xtfonts[XT_NFONTS];

static void
localstartup()
{
	fontstartup();
	if(Dsp) {
		openfonts(Xtfonts, XT_NFONTS);
		setgcfont(Xtfonts[1]);
	}
}


#define	PLANEFG	0x55555555
static	int 	planelist[] = {
	0, 0x1, 0x2, 0x23, 0xf8, 0x765, 0x3987, 0x129078, 0x23567193};



#if !defined(T_XDrawImageString) && !defined(T_XCopyPlane) && !defined(T_XPutImage) && !defined(T_XCopyArea)
#define NEED_STIPPLE
#endif



int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	d = 0;
	gc = 0;
	x = 3;
	y = 30;
	string = "A bCdElMnO";
	length = strlen(string);
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	d = ErrdefDrawable;
	gc = ErrdefGC;
}

static void t001(){

XVisualInfo	*vp;
int 	fn;
unsigned int 	width;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XDrawImageString-1.(A)");
	report_assertion("A call to XDrawImageString first fills the destination");
	report_assertion("rectangle with the background pixel value and next draws a");
	report_assertion("string of 8-bit characters, selected from the gc's font,");
	report_assertion("using the foreground pixel value.");

	report_strategy("Reverse foreground and background pixel values in the gc.");
	report_strategy("For each font");
	report_strategy("  Set the font into the gc.");
	report_strategy("  Draw string");
	report_strategy("  Pixel verify.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		d = makewin(display, vp);
		gc = makegc(display, d);

		XSetForeground(display, gc, W_BG);
		XSetBackground(display, gc, W_FG);

		getsize(display, d, &width, (unsigned int*)0);

		for (fn = 0; fn < XT_NFONTS; fn++) {

			XSetFont(display, gc, Xtfonts[fn]);
			if (fn == 4 || fn == 6)
				x = width-4;
			else
				x = 3;

			startcall(display);
			if (isdeleted())
				return;
			XDrawImageString(display, d, gc, x, y, string, length);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			PIXCHECK(display, d);
			dclear(display, d);
		}
	}

	CHECKPASS(XT_NFONTS*nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion XDrawImageString-2.(-)");
	report_assertion("The upper-left corner of the filled rectangle is at [ x, y");
	report_assertion("- font-ascent], with width equal to the sum of the");
	report_assertion("per-character widths, and with height font-ascent+");
	report_assertion("font-descent, where font-ascent and font-descent are the");
	report_assertion("logical ascent and descent of the font.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t003(){

XVisualInfo	*vp;
unsigned int 	width, height;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XDrawImageString-3.(A)");
	report_assertion("The origin of the string is at [ x, y].");

	report_strategy("Vary x and y");
	report_strategy("  Draw string");
	report_strategy("Pixmap verify.");

	tpstartup();
	setargs();
	string = "v";
	length = 1;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		d = makewin(display, vp);
		gc = makegc(display, d);

		getsize(display, d, &width, &height);

		for (x = 0; x < width; x += 20) {
			for (y = 0; y < width; y += 20) {
				startcall(display);
				if (isdeleted())
					return;
				XDrawImageString(display, d, gc, x, y, string, length);
				endcall(display);
				if (geterr() != Success) {
					report("Got %s, Expecting Success", errorname(geterr()));
					FAIL;
				}
			}
		}

		PIXCHECK(display, d);
	}

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo	*vp;
XImage	*sav;
Pixmap	tile;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XDrawImageString-4.(A)");
	report_assertion("The effective function is GXcopy, and the effective");
	report_assertion("fill_style is FillSolid.");

	report_strategy("Set gc funtion to GXxor");
	report_strategy("Set fill-style to FillTiled");
	report_strategy("Set tile.");
	report_strategy("Verify that these settings have no effect.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		d = makewin(display, vp);
		gc = makegc(display, d);

		XSetForeground(display, gc, W_BG);
		XSetBackground(display, gc, W_FG);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		sav = savimage(display, d);
		dclear(display, d);

		/* Make pixmap with same depth as drawable under test */
		tile = makepixm(display, vp);
		pattern(display, tile);

		XSetFunction(display, gc, GXxor);
		XSetFillStyle(display, gc, FillTiled);
		XSetTile(display, gc, tile);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (compsavimage(display, d, sav))
			CHECK;
		else {
			report("Effective function and fill style test failed");
			FAIL;
		}
	}

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.26925 */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XDrawImageString-5.(B)");
	report_assertion("When the font is defined with 2-byte matrix indexing, then");
	report_assertion("each byte is used as a byte2 with a byte1 of zero.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.26925 */

/* Including from file gc/plane-mas.mc */
static void t006(){

XVisualInfo	*vp;
int 	depthmask;
int 	*ip;
unsigned long	pix;
unsigned long	expected;
int 	pmx = -1, pmy;
int 	ntested;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XDrawImageString-6.(A)");
	report_assertion("The value for plane_mask is truncated to the depth of the");
	report_assertion("GC.");

	report_strategy("Set foreground to pattern of 1's and 0's");
	report_strategy("Set plane-mask to values larger than the depth.");
	report_strategy("Verify that result is what would be expected if the extra bits");
	report_strategy(" were masked off.");

	tpstartup();
	setargs();
	ntested = 0;
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		if (pmx == -1) {
			/*
			 * Get a point that is set in the drawable.
			 */
			startcall(display);
			if (isdeleted())
				return;
			XDrawImageString(display, d, gc, x, y, string, length);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			setfuncpixel(A_DISPLAY, A_DRAW, &pmx, &pmy);
			dclear(A_DISPLAY, A_DRAW);
		}

		depthmask = DEPTHMASK(vp->depth);

		XSetForeground(A_DISPLAY, A_GC, PLANEFG);

		for (ip = planelist; ip < &planelist[NELEM(planelist)]; ip++) {
			if (*ip <= depthmask)
				continue;

			trace("plane-mask 0x%x", *ip);
			XSetPlaneMask(A_DISPLAY, A_GC, *ip);
			ntested++;

			dclear(A_DISPLAY, A_DRAW);
			startcall(display);
			if (isdeleted())
				return;
			XDrawImageString(display, d, gc, x, y, string, length);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			expected = (*ip & PLANEFG) & depthmask;
			pix = getpixel(A_DISPLAY, A_DRAW, pmx, pmy);

			if (pix == expected)
				CHECK;
			else {
				report("got pixel 0x%x, expecting 0x%x", pix, expected);
				FAIL;
			}
		}

	}

	CHECKPASS(ntested);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XVisualInfo	*vp;
int 	depthmask;
int 	*ip;
unsigned long	pix;
unsigned long	expected;
int 	pmx = -1, pmy;
int 	ntested = 0;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XDrawImageString-7.(A)");
	report_assertion("The plane_mask specifies which planes of the destination");
	report_assertion("are to be modified, one bit per plane, with bits being");
	report_assertion("assigned to planes from the least significant bit of the");
	report_assertion("word to the most significant bit.");

	report_strategy("Set foreground to pattern of 1's and 0's");
	report_strategy("Select a variety of plane masks.");
	report_strategy("Verify that the expected pixels are drawn.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		if (pmx == -1) {
			/*
			 * Get a point that is set in the drawable.
			 */
			startcall(display);
			if (isdeleted())
				return;
			XDrawImageString(display, d, gc, x, y, string, length);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			setfuncpixel(A_DISPLAY, A_DRAW, &pmx, &pmy);
			dclear(A_DISPLAY, A_DRAW);
		}

		depthmask = DEPTHMASK(vp->depth);

		XSetForeground(A_DISPLAY, A_GC, PLANEFG);
		for (ip = planelist; ip < &planelist[NELEM(planelist)]; ip++) {
			if (*ip > depthmask)
				break;

			trace("plane-mask 0x%x", *ip);
			XSetPlaneMask(A_DISPLAY, A_GC, *ip);
			ntested++;

			dclear(A_DISPLAY, A_DRAW);
			startcall(display);
			if (isdeleted())
				return;
			XDrawImageString(display, d, gc, x, y, string, length);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			expected = *ip & PLANEFG;
			pix = getpixel(A_DISPLAY, A_DRAW, pmx, pmy);

			if (pix == expected)
				CHECK;
			else {
				report("got pixel 0x%x, expecting 0x%x", pix, expected);
				FAIL;
			}
		}

	}

	CHECKPASS(ntested);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file gc/plane-mas.mc */

/* Including from file gc/font.mc */
/* End of included file gc/font.mc */

/* Including from file gc/subwindow.mc */
static void t008(){

XVisualInfo	*vp;
Window	subwins[10];
unsigned int 	swmwidth, swmheight;
struct	area	area;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XDrawImageString-8.(A)");
	report_assertion("When subwindow_mode is ClipByChildren, then the");
	report_assertion("destination window and source (if it is a window) are");
	report_assertion("clipped by all viewable InputOutput children.");

	report_strategy("Set subwindow-mode to be ClipByChildren");
	report_strategy("Cover window with many strip sub-windows.");
	report_strategy("Do drawing operation");
	report_strategy("Verify that all subwindows are clear.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		XSetSubwindowMode(A_DISPLAY, A_GC, ClipByChildren);

		/*
		 * Place subwindows in strips across the window
		 * leaving spaces between them.
		 */
		getsize(A_DISPLAY, A_DRAW, &swmwidth, &swmheight);
		swmwidth /= 2*NELEM(subwins);

		for (i = 0; i < NELEM(subwins); i++) {
			setarea(&area, 2*i*swmwidth, 0, swmwidth, 0);
			subwins[i] = crechild(A_DISPLAY, A_DRAW, &area);
		}

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		for (i = 0; i < NELEM(subwins); i++) {
			if (checkclear(A_DISPLAY, subwins[i]))
				CHECK;
			else {
				report("Area of subwindow was not clear");
				FAIL;
			}
		}
	}

	CHECKPASS(NELEM(subwins)*nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

XVisualInfo	*vp;
Window	subwins[5];
XImage	*swmsav;
unsigned int 	swmwidth, swmheight;
struct	area	area;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XDrawImageString-9.(A)");
	report_assertion("When subwindow_mode is IncludeInferiors, then neither the");
	report_assertion("destination window nor source (if it is a window) is clipped");
	report_assertion("by inferiors.");

	report_strategy("Place subwindows over parts of the main window");
	report_strategy("Create subwindows over these windows as well.");
	report_strategy("Do graphics operation.");
	report_strategy("Verify that the operation was not affected.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		swmsav = savimage(A_DISPLAY, A_DRAW);
		dclear(A_DISPLAY, A_DRAW);

		XSetSubwindowMode(A_DISPLAY, A_GC, IncludeInferiors);

		/*
		 * Place subwindows in strips across the window
		 * leaving spaces between them.
		 */
		getsize(A_DISPLAY, A_DRAW, &swmwidth, &swmheight);
		swmwidth /= 2*NELEM(subwins);

		for (i = 0; i < NELEM(subwins); i++) {
			setarea(&area, 2*i*swmwidth, 0, swmwidth, 0);
			subwins[i] = crechild(A_DISPLAY, A_DRAW, &area);
			for (j = 0; j < swmheight; j += 10) {
				setarea(&area, 0, j, swmwidth, 6);
				crechild(A_DISPLAY, subwins[i], &area);
			}
		}

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (compsavimage(A_DISPLAY, A_DRAW, swmsav))
			CHECK;
		else {
			report("Inferiors affected result with IncludeInferiors");
			FAIL;
		}

		/*
		 * As a special test due to its importance, test that drawing
		 * on to the root window has the same effect.  Move the test
		 * window to the root window origin.
		 */
		if (vp->depth != DefaultDepth(A_DISPLAY, DefaultScreen(A_DISPLAY)))
			CHECK;
		else {
			Drawable savdraw;

			dclear(A_DISPLAY, A_DRAW);
			XSetWindowBorderWidth(A_DISPLAY, A_DRAW, 0);
			XMoveWindow(A_DISPLAY, A_DRAW, 0, 0);

			savdraw = A_DRAW;
			A_DRAW = DRW(A_DISPLAY);

			startcall(display);
			if (isdeleted())
				return;
			XDrawImageString(display, d, gc, x, y, string, length);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			A_DRAW = savdraw;

			if (compsavimage(A_DISPLAY, A_DRAW, swmsav))
				CHECK;
			else {
				report("Drawing on root window with IncludeInferiors gave incorrect results");
				FAIL;
			}
		}
	}

	CHECKPASS(2*nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

XVisualInfo	*vp1, *vp2;
XImage	*swmsav;
int 	found;
XSetWindowAttributes w_attr;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XDrawImageString-10.(A)");
	report_assertion("When subwindow_mode is IncludeInferiors on a window of one");
	report_assertion("depth with mapped inferiors of differing depth, then no");
	report_assertion("errors occur.");

	report_strategy("If only one depth window supported");
	report_strategy("  Result is UNSUPPORTED");
	report_strategy("");
	report_strategy("Find two visuals with different depths.");
	report_strategy("Use one of these visuals to create a window.");
	report_strategy("Use the other to create a subwindow.");
	report_strategy("Verify that no errors occur.");
	report_strategy("For information purposes only see if graphics operation is rendered properly.");

	tpstartup();
	setargs();
	vp2 = NULL;
	found = 0;

	for (resetvinf(VI_WIN); nextvinf(&vp1); ) {
		if (vp2 == NULL)
			vp2 = vp1;
		if (vp1->depth != vp2->depth) {
			found++;
			break;
		}
	}

	if (!found) {
		report("Only one depth visual supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	A_DRAW = makewin(A_DISPLAY, vp1);
	A_GC = makegc(A_DISPLAY, A_DRAW);

	startcall(display);
	if (isdeleted())
		return;
	XDrawImageString(display, d, gc, x, y, string, length);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	swmsav = savimage(A_DISPLAY, A_DRAW);
	dclear(A_DISPLAY, A_DRAW);

        /*
         * Must explicitly set the colormap and border_pixel parameters
         * to ensure that a BadMatch error doesn't get generated, since
         * it is entire possible that the depth differs from that of the
         * parent window.
         */
        w_attr.colormap = makecolmap(A_DISPLAY, vp2->visual, AllocNone);
        w_attr.border_pixel = 0;
	XCreateWindow(A_DISPLAY
		, A_DRAW
		, 0
		, 0
		, 300
		, 300
		, 0
		, vp2->depth
		, InputOutput
		, vp2->visual
		, CWColormap | CWBorderPixel 
		, &w_attr
		);
	XSetWindowBackground(A_DISPLAY, A_DRAW, W_BG);
	XMapWindow(A_DISPLAY, A_DRAW);

	/* Wait for Expose? */
	/* No.... we're not a top level window so no wmgr interference */
		
	XSetSubwindowMode(A_DISPLAY, A_GC, IncludeInferiors);

	startcall(display);
	if (isdeleted())
		return;
	XDrawImageString(display, d, gc, x, y, string, length);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (compsavimage(A_DISPLAY, A_DRAW, swmsav))
		trace("Drawing through to different depth window produces same results");
	else
		trace("Drawing through to different depth window produces different results");
		
	if (geterr() == Success)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file gc/subwindow.mc */

/* Including from file gc/clip-x-or.mc */
static void t011(){

XVisualInfo	*vp;
Pixmap	cmopixmap;
struct	area	area;
unsigned int 	cmowidth;
unsigned int 	cmoheight;
int 	divsize;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XDrawImageString-11.(A)");
	report_assertion("The clip origin coordinates clip-x-origin and clip-y-origin");
	report_assertion("are interpreted relative to the origin of the destination");
	report_assertion("drawable specified in the graphics operation.");

	report_strategy("Create Pixmap and set clip-mask with it.");
	report_strategy("Vary clip origin");
	report_strategy("Verify nothing is drawn outside the clip_mask based on the origin.");
	report_strategy("Pixmap verify results inside the cliparea.");

	tpstartup();
	setargs();
	divsize = 3;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		/*
		 * Get size of the pixmap.  It is divsize smaller on all sides
		 * than the window.
		 */
		getsize(A_DISPLAY, A_DRAW, &cmowidth, &cmoheight);
		cmowidth /= divsize;
		cmoheight /= divsize;
		debug(2, "clip-mask height=%d, width=%d", cmowidth, cmoheight);

		/*
		 * Create a pixmap that is about divsize^2 of the area of
		 * the window.
		 */
		cmopixmap = XCreatePixmap(A_DISPLAY, A_DRAW, cmowidth, cmoheight, 1);
		dset(A_DISPLAY, cmopixmap, 1L);

		XSetClipMask(A_DISPLAY, A_GC, cmopixmap);
		XFreePixmap(A_DISPLAY, cmopixmap);

		for (i = 0; i < divsize; i++) {
			for (j = 0; j < divsize; j++) {
				setarea(&area, i*cmowidth, j*cmoheight, cmowidth, cmoheight);
				debug(2, "Origin at (%d,%d)", area.x, area.y);
				XSetClipOrigin(A_DISPLAY, A_GC, area.x, area.y);
				startcall(display);
				if (isdeleted())
					return;
				XDrawImageString(display, d, gc, x, y, string, length);
				endcall(display);
				if (geterr() != Success) {
					report("Got %s, Expecting Success", errorname(geterr()));
					FAIL;
				}
				if (checkarea(A_DISPLAY,A_DRAW,&area,W_BG,W_BG,CHECK_OUT))
					CHECK;
				else {
					report("Drawing occurred outside clip_mask");
					FAIL;
				}
				PIXCHECK(A_DISPLAY, A_DRAW);
				dclear(A_DISPLAY, A_DRAW);
			}
		}
	}

	CHECKPASS(2*divsize*divsize*nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file gc/clip-x-or.mc */

/* Including from file gc/clip-y-or.mc */
/* End of included file gc/clip-y-or.mc */

/* Including from file gc/clip-mask.mc */
static void t012(){

XVisualInfo	*vp;
XImage	*cmsav;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XDrawImageString-12.(A)");
	report_assertion("When the clip_mask is set to None, then the pixels are");
	report_assertion("always drawn regardless of the clip origin.");

	report_strategy("Set clip mask to None");
	report_strategy("Verify that things are still drawn.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		cmsav = savimage(A_DISPLAY, A_DRAW);
		dclear(A_DISPLAY, A_DRAW);

		/*
		 * Not very interesting, because this should be the default
		 * anyway.
		 */
		XSetClipMask(A_DISPLAY, A_GC, None);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (compsavimage(A_DISPLAY, A_DRAW, cmsav))
			CHECK;
		else {
			report("Clip mask of None changed graphics");
			FAIL;
		}
	}

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

XVisualInfo	*vp;
Pixmap	cmpm;
struct	area	area;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XDrawImageString-13.(A)");
	report_assertion("When pixels are outside the area covered by the clip_mask,");
	report_assertion("then they are not drawn.");

	report_strategy("Create a pixmap depth 1.");
	report_strategy("Fill it with all ones.");
	report_strategy("Set this pixmap as the clip_mask.");
	report_strategy("Verify that nothing is drawn outside the clip-mask area.");
	report_strategy("Use a pixmap size of 5x5 to ensure that all tests have some part of the");
	report_strategy("drawing outside the clip-mask.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		setarea(&area, 0, 0, 5, 5);
		cmpm = XCreatePixmap(A_DISPLAY, A_DRAW, area.width, area.height, 1);
		dset(A_DISPLAY, cmpm, 1L);
		XSetClipMask(A_DISPLAY, A_GC, cmpm);
		XFreePixmap(A_DISPLAY, cmpm);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (checkarea(A_DISPLAY, A_DRAW, &area, 0L, W_BG, CHECK_OUT))
			CHECK;
		else {
			report("Drawing outside clip mask");
			FAIL;
		}
	}

	CHECKPASS(nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

#define stipple_width 24
#define stipple_height 11
static unsigned char stipple_bits[] = {
   0xff, 0x0f, 0x00, 0x3f, 0xf0, 0xff, 0xcf, 0xff, 0x03, 0xf7, 0x0f, 0xfc,
   0xff, 0xf1, 0x0f, 0x78, 0x7e, 0xf0, 0x80, 0x8f, 0x1f, 0x2a, 0xf0, 0xe1,
   0x80, 0x07, 0x1e, 0xaa, 0xff, 0xe0, 0x80, 0xff, 0x0f};
XVisualInfo	*vp;
Pixmap	cmpixmap;
Pixmap	cmstip;
XImage	*cmsav;
GC		cmgc;
unsigned int 	cmwidth, cmheight;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XDrawImageString-14.(A)");
	report_assertion("When pixels have a clip_mask bit set to 1, and they would");
	report_assertion("be drawn, then they are drawn.");

	report_strategy("Do graphics operation.");
	report_strategy("Save the image on the drawable.");
	report_strategy("Clear drawable.");
	report_strategy("Create a pixmap depth 1 that is the same size as the window.");
	report_strategy("Set all bits in pixmap to 1.");
	report_strategy("Set GC component clip-mask to pixmap using XSetClipMask.");
	report_strategy("Do graphics operation.");
	report_strategy("Verify that the images drawn were the same.");
	report_strategy("");
	report_strategy("Set pixmap to a pattern.");
	report_strategy("Do graphics operation.");
	report_strategy("Pixmap verify the result.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		cmsav = savimage(A_DISPLAY, A_DRAW);
		if (isdeleted())
			return;
		/* Must clear the drawable - otherwise there is no way 
		of proving clip mask of all 1's allowed drawing */
		dclear(A_DISPLAY, A_DRAW);

		getsize(A_DISPLAY, A_DRAW, &cmwidth, &cmheight);
		cmpixmap = XCreatePixmap(A_DISPLAY, A_DRAW, cmwidth, cmheight, 1);
		if (isdeleted())
			return;
		dset(A_DISPLAY, cmpixmap, 1L);

		XSetClipMask(A_DISPLAY, A_GC, cmpixmap);

		trace("Clip mask of all 1's");
		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (compsavimage(A_DISPLAY, A_DRAW, cmsav))
			CHECK;
		else {
			report("fail on clip_mask of all 1's");
			FAIL;
		}
		dclear(A_DISPLAY, A_DRAW);

		cmstip = XCreateBitmapFromData(A_DISPLAY, A_DRAW, (char*)stipple_bits,
			stipple_width, stipple_height);
		cmgc = makegc(A_DISPLAY, cmstip);
		if (isdeleted())
			return;

		for (i = 0; i < cmwidth; i += stipple_width) {
			for (j = 0; j < cmheight; j += stipple_height) {
				XCopyArea(A_DISPLAY, cmstip, cmpixmap, cmgc, 0, 0,
					stipple_width, stipple_height, i, j);
			}
		}
		XSetClipMask(A_DISPLAY, A_GC, cmpixmap);

		trace("Clip mask with pattern");
		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		PIXCHECK(A_DISPLAY, A_DRAW);

		XFreePixmap(A_DISPLAY, cmpixmap);
		XFreePixmap(A_DISPLAY, cmstip);
	}

	CHECKPASS(2*nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

XVisualInfo	*vp;
Pixmap	cmpixmap;
unsigned int 	cmwidth, cmheight;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XDrawImageString-15.(A)");
	report_assertion("When pixels have a clip_mask bit set to 0, then they are");
	report_assertion("not drawn.");

	report_strategy("Create a pixmap depth 1 that is the same size as the window.");
	report_strategy("Set all bits in pixmap to 0.");
	report_strategy("Set GC component clip_mask to pixmap using XSetClipMask.");
	report_strategy("Do graphics operation.");
	report_strategy("Verify that nothing is drawn.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		getsize(A_DISPLAY, A_DRAW, &cmwidth, &cmheight);
		cmpixmap = XCreatePixmap(A_DISPLAY, A_DRAW, cmwidth, cmheight, 1);
		if (isdeleted())
			return;
		dset(A_DISPLAY, cmpixmap, 0L);

		XSetClipMask(A_DISPLAY, A_GC, cmpixmap);

		trace("Clip mask of all 0's");
		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (checkclear(A_DISPLAY, A_DRAW))
			CHECK;
		else {
			report("Pixels were drawn with clip_mask of all zeros");
			FAIL;
		}

		XFreePixmap(A_DISPLAY, cmpixmap);
	}

	CHECKPASS(nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file gc/clip-mask.mc */

/* Including from file gc/foregroun.mc */
static void t016(){

static unsigned long fglist[] = {
	0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x10, 0x33, 0x81,
	0xa3, 0xff, 256, 300, 1000,
	0x111111, 0x400200, 0x777777,
	};
XVisualInfo	*vp;
long	fgind;
unsigned long	fg;
int 	nchecks = 0;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XDrawImageString-16.(A)");
	report_assertion("The foregound component of the gc is used to determine the");
	report_assertion("foreground pixel value.");

	report_strategy("Set foreground to various values.");
	report_strategy("Pixmap verify the results.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		for (fgind = 0; fgind < sizeof(fglist)/sizeof(unsigned long); fgind++) {

			fg = fglist[fgind];
			if (fg > DEPTHMASK(vp->depth))
				break;

			nchecks++;
			trace("Testing fg pixel of %d", fg);
			XSetForeground(A_DISPLAY, A_GC, fg);

			startcall(display);
			if (isdeleted())
				return;
			XDrawImageString(display, d, gc, x, y, string, length);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			PIXCHECK(A_DISPLAY, A_DRAW);

			dclear(A_DISPLAY, A_DRAW);
		}
	}

	CHECKPASS(nchecks);
	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

XVisualInfo	*vp;
XImage	*imp;
unsigned long	pix;
unsigned long	fgfg;
int 	found;
int 	i_x, i_y;
unsigned int 	i_width, i_height;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XDrawImageString-17.(A)");
	report_assertion("The value for foreground is truncated to the depth of the");
	report_assertion("GC.");

	report_strategy("Set foreground to value with all bits set.");
	report_strategy("Find a non background pixel.");
	report_strategy("Check that this is truncated to the depth.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		XSetForeground(A_DISPLAY, A_GC, ~0L);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		imp = savimage(A_DISPLAY, A_DRAW);
		getsize(A_DISPLAY, A_DRAW, &i_width, &i_height);
		found = 0;
		/*
		 * Look for a non background pixel, if there is one then this
		 * should be the foreground truncated to the depth.
		 */
		for (i_y = 0; i_y < i_height; i_y++) {
			for (i_x = 0; i_x < i_width; i_x++) {
				pix = XGetPixel(imp, i_x, i_y);
				if (pix != W_BG) {
					found = 1;
					if (pix == DEPTHMASK(vp->depth)) {
						CHECK;
					} else {
						report("Pixel was set to %d, expecting %d", pix, DEPTHMASK(vp->depth));
						FAIL;
					}
					i_y = i_height;	/* So that we leave loop XXX */
					break;
				}
			}
		}
		if (found == 0) {
			if (W_BG == (~0 & DEPTHMASK(vp->depth))) {
				report("WARNING: W_BG != 0; this should not be the case");
				CHECK;
			} else {
				report("After setting foreground to (~0)");
				report("no non-background pixel was drawn");
				FAIL;
			}
		}

		dclear(A_DISPLAY, A_DRAW);

		/* Set all bits other than the bottom one */
		fgfg = (~0)^1;
		XSetForeground(A_DISPLAY, A_GC, fgfg);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		imp = savimage(A_DISPLAY, A_DRAW);
		getsize(A_DISPLAY, A_DRAW, &i_width, &i_height);
		found = 0;
		/*
		 * Look for a non background pixel, if there is one then this
		 * should be the foreground truncated to the depth.
		 */
		for (i_y = 0; i_y < i_height; i_y++) {
			for (i_x = 0; i_x < i_width; i_x++) {
				pix = XGetPixel(imp, i_x, i_y);
				if (pix != W_BG) {
					found = 1;
					if (pix == (fgfg & DEPTHMASK(vp->depth))) {
						CHECK;
					} else {
						report("Pixel was set to %d, expecting %d", pix, (fgfg & DEPTHMASK(vp->depth)));
						FAIL;
					}
					i_y = i_height;	/* So that we leave loop XXX */
					break;
				}
			}
		}
		if (found == 0) {
			/*
			 * This should be the case on monochrome displays
			 */
			if (W_BG == (fgfg & DEPTHMASK(vp->depth))) {
				CHECK;
			} else {
				report("After setting foreground to (~0)^1");
				report("no non-background pixel was drawn");
				FAIL;
			}
		}
	}

	CHECKPASS(2*nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file gc/foregroun.mc */

/* Including from file gc/backgroun.mc */
static void t018(){

static unsigned long bglist[] = {
	0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x10, 0x33, 0x81,
	0xa3, 0xff, 256, 300, 1000,
	0x111111, 0x400200, 0x777777,
	};
XVisualInfo	*vp;
#ifdef NEED_STIPPLE
Pixmap	stip;
char	*stipbit = "\0";
#endif
long	bgind;
unsigned long	bg;
int 	nchecks = 0;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XDrawImageString-18.(A)");
	report_assertion("The background component of the gc is used to determine the");
	report_assertion("background pixel value.");

	report_strategy("Set GC component background to various values.");
	report_strategy("Pixmap verify the results.");

	tpstartup();
	setargs();
#ifdef NEED_STIPPLE
	stip = XCreateBitmapFromData(A_DISPLAY, DRW(A_DISPLAY), stipbit, 1, 1);
#endif

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

		for (bgind = 0; bgind < NELEM(bglist); bgind++) {

			bg = bglist[bgind];
			if (bg > DEPTHMASK(vp->depth))
				break;

			trace("Testing bg pixel of %d", bg);
			nchecks++;

#ifdef NEED_STIPPLE
			/*
			 * Set a stipple to all zero's and set the fill style
			 * to be FillOpaqueStippled.  This will mean that everything
			 * should be drawn in the background colour.
			 * (different for XCopyPlane, which doesn't use fill style,
			 * nor does XPutImage or XCopyArea).
			 */
			XSetStipple(A_DISPLAY, A_GC, stip);
			XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
#endif
/* now set the background to bg and do the call. If it's XCopyPlane/XPutImage then
 * we have cleared the src drawable/image to zero so we will always find 0 in the
 * selected plane so we will fill with bg. If we're XDrawImageString then
 * we do the equivalent of the background fill anyway,  if we're
 * XCopyArea then we have to do a dset of src with bg otherwise we'll have
 * used FillOpaqueStippled and a stipple of a lone zero, only, to get the
 * same effect of a background fill.
 */
			XSetBackground(A_DISPLAY, A_GC, bg);

			startcall(display);
			if (isdeleted())
				return;
			XDrawImageString(display, d, gc, x, y, string, length);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			PIXCHECK(A_DISPLAY, A_DRAW);

			dclear(A_DISPLAY, A_DRAW);
		}
	}

#ifdef NEED_STIPPLE
	XFreePixmap(A_DISPLAY, stip);
#endif

	CHECKPASS(nchecks);
	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

XVisualInfo	*vp;
XImage	*imp;
#ifdef NEED_STIPPLE
Pixmap	stip;
char	*stipbit = "\0\0\0\0";
#endif
unsigned long	pix;
int 	found;
int 	i_x, i_y;
unsigned int 	i_width, i_height;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XDrawImageString-19.(A)");
	report_assertion("The value for background is truncated to the depth of the");
	report_assertion("GC.");

	report_strategy("Set GC component background to value with all bits set.");
	report_strategy("If not (XDrawImageString  || XCopyPlane || XPutImage || XCopyArea)");
	report_strategy("  Set GC component stipple to all zeros");
	report_strategy("  Set GC component FillStyle to FillOpaqueStippled.");
	report_strategy("else if (XCopyPlane || XPutImage)");
	report_strategy("  Fill source drawable/image-bitmap with 0's to ensure we draw with background");
	report_strategy("else if XCopyArea");
	report_strategy("  Fill source drawable/image-bitmap with all 1's");
	report_strategy("Draw item.");
	report_strategy("Find a pixel with a value other than W_BG.");
	report_strategy("Check that this is truncated to the depth.");

	tpstartup();
	setargs();
#ifdef NEED_STIPPLE
	stip = XCreateBitmapFromData(A_DISPLAY, DRW(A_DISPLAY), stipbit, 1, 1);
#endif

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		A_DRAW = makewin(A_DISPLAY, vp);
		A_GC = makegc(A_DISPLAY, A_DRAW);

#ifdef NEED_STIPPLE
		/*
		 * Set a stipple to all zero's and set the fill style
		 * to be FillOpaqueStippled.  This will mean that everything
		 * should be drawn in the background colour.
		 */
		XSetStipple(A_DISPLAY, A_GC, stip);
		XSetFillStyle(A_DISPLAY, A_GC, FillOpaqueStippled);
#endif

/* now set the background to ~0 and do the call. If it's XCopyPlane/XPutImage then
 * we have cleared the src drawable/image to zero so we will always find 0 in the
 * selected plane so we will fill with ~0. If we're XDrawImageString then
 * we do the equivalent of the background fill anyway, if we're XCopyArea
 * then we need to fill the src will all 1's, otherwise we'll have
 * used FillOpaqueStippled and a stipple of a lone zero, only, to get the
 * same effect of a background fill.
 */
		XSetBackground(A_DISPLAY, A_GC, ~0L);

		startcall(display);
		if (isdeleted())
			return;
		XDrawImageString(display, d, gc, x, y, string, length);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		imp = savimage(A_DISPLAY, A_DRAW);
		getsize(A_DISPLAY, A_DRAW, &i_width, &i_height);
		found = 0;
		for (i_y = 0; i_y < i_height; i_y++) {
			for (i_x = 0; i_x < i_width; i_x++) {
				pix = XGetPixel(imp, i_x, i_y);
				if (pix != W_BG) {
					found = 1;
					if (pix == DEPTHMASK(vp->depth)) {
						CHECK;
					} else {
						report("Pixel was set to %d, expecting %d", pix, DEPTHMASK(vp->depth));
#ifdef NEED_STIPPLE
						report("FillOpaqueStippled is also used in this test, and could affect the result");
#endif
						FAIL;
					}
					i_y = i_height;	/* So that we leave loop XXX */
					break;
				}
			}
		}
		if (found == 0) {
			report("Nothing was drawn");
#ifdef NEED_STIPPLE
			report("FillOpaqueStippled is also used in this test, and could affect the result");
#endif
			FAIL;
		}
	}
#ifdef NEED_STIPPLE
	XFreePixmap(A_DISPLAY, stip);
#endif

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file gc/backgroun.mc */

/* Including from file error/EDra.mc */
/* End of included file error/EDra.mc */

/* Including from file error/EDra.mc */
static void t020(){

int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XDrawImageString-20.(A)");
	report_assertion("When a drawable argument does not name a valid Drawable,");
	report_assertion("then a BadDrawable error occurs.");

	report_strategy("Create a bad drawable by creating and destroying a window.");
	report_strategy("Call test function using bad drawable as the drawable argument.");
	report_strategy("Verify that a BadDrawable error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_DRAWABLE = (Drawable)badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XDrawImageString(display, d, gc, x, y, string, length);
	endcall(display);
	if (geterr() != BadDrawable) {
		report("Got %s, Expecting BadDrawable", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadDrawable)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EDra.mc */

/* Including from file error/EGC.mc */
/* End of included file error/EGC.mc */

/* Including from file error/EGC.mc */
static void t021(){

int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XDrawImageString-21.(A)");
	report_assertion("When the GC argument does not name a defined GC, then a");
	report_assertion("BadGC error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Set GC id to -1 using XTestSetGContextOfGC.");
	report_strategy("Call test function using bad GC as the GC argument.");
	report_strategy("Verify that a BadGC error occurs.");

	tpstartup();
	setargs();
	seterrdef();


	A_GC = badgc(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XDrawImageString(display, d, gc, x, y, string, length);
	endcall(display);
	if (geterr() != BadGC) {
		report("Got %s, Expecting BadGC", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadGC)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EGC.mc */

/* Including from file error/EMat1.mc */
/* End of included file error/EMat1.mc */

/* Including from file error/EMat1.mc */
static void t022(){

int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion XDrawImageString-22.(A)");
	report_assertion("When a drawable argument is an InputOnly window then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Create an InputOnly window.");
	report_strategy("Call test function using InputOnly window as the drawable argument.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	seterrdef();


	A_DRAWABLE = (Drawable)iponlywin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XDrawImageString(display, d, gc, x, y, string, length);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EMat1.mc */

/* Including from file error/EMat2.mc */
/* End of included file error/EMat2.mc */

/* Including from file error/EMat2.mc */
static void t023(){

XVisualInfo	*vp;
Drawable	errpm;
int 	founddepth = 0;
int 	pass = 0, fail = 0;

 	report_purpose(23);

	report_assertion("Assertion XDrawImageString-23.(A)");
	report_assertion("When the graphics context and the drawable do not have the");
	report_assertion("same depth, then a BadMatch error occurs.");

	report_strategy("If only one depth supported");
	report_strategy("  report UNSUPPORTED");
	report_strategy("Create pixmap of depth 1.");
	report_strategy("Create gc of different depth.");
	report_strategy("Call test function with this pixmap and gc.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	for (resetvinf(VI_PIX); nextvinf(&vp); ) {
		if (vp->depth != 1) {
			founddepth++;

			errpm = makewin(A_DISPLAY, vp);
			A_GC = makegc(A_DISPLAY, errpm);

			break;
		}
	}

	if (!founddepth) {
		report("Only one depth supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	vp->depth = 1;
	A_DRAWABLE = makewin(A_DISPLAY, vp);

	startcall(display);
	if (isdeleted())
		return;
	XDrawImageString(display, d, gc, x, y, string, length);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EMat2.mc */

/* Including from file error/EMat3.mc */
/* End of included file error/EMat3.mc */

/* Including from file error/EMat3.mc */
static void t024(){

XVisualInfo	vi;
Pixmap	errpm;
int 	scr_num;
int 	pass = 0, fail = 0;

 	report_purpose(24);

	report_assertion("Assertion XDrawImageString-24.(A)");
	report_assertion("When the graphics context and the drawable were not created");
	report_assertion("for the same root, then a BadMatch error occurs.");

	report_strategy("If multiple screens are supported");
	report_strategy("  Create pixmap of depth 1.");
	report_strategy("  Create gc on alternate screen.");
	report_strategy("  Call test function with this pixmap and gc.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  report UNSUPPORTED");

	tpstartup();
	setargs();
        if (config.alt_screen == -1) {
                unsupported("No alternate root supported");
                return;
        }

	scr_num = config.alt_screen;
	if (scr_num == DefaultScreen(A_DISPLAY)) {
		delete("The alternate root was the same as the one under test");
		return;
	}
	if (scr_num >= ScreenCount(A_DISPLAY)) {
		delete("The alternate root could not be accessed");
		return;
	}

	vi.visual = NULL;
	vi.screen = DefaultScreen(A_DISPLAY);	/* XXX */
	vi.depth = 1;
	A_DRAWABLE = makepixm(A_DISPLAY, &vi);

	/*
	 * Create a 1x1 depth 1 pixmap on other screen
	 * and use it to create a gc
	 */
	errpm = XCreatePixmap(A_DISPLAY, RootWindow(A_DISPLAY, scr_num), 1, 1, 1);
	A_GC = makegc(A_DISPLAY, errpm);

	startcall(display);
	if (isdeleted())
		return;
	XDrawImageString(display, d, gc, x, y, string, length);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreePixmap(A_DISPLAY, errpm);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EMat3.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = localstartup;
void	(*tet_cleanup)() = fontcleanup;
