/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XEventsQueued(display, mode)
 *   Display *display;
 *   int mode;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XEventsQueued	1
char    *TestName = "XEventsQueued";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XEventsQueued function
 */
static Display *display;
static int mode;


static int 	ValueReturn;


/*
 * Can not use "xcall" because it empties the event queue.
 */
#define	_xcall_(return_value)	\
		_startcall(display);\
		return_value = XEventsQueued(display, mode);\
		_endcall(display)

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	mode = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int	eventsput;
int	event_count;
XEvent	event;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XEventsQueued-1.(A)");
	report_assertion("When the number of events already in the event queue is");
	report_assertion("non-zero, then a call to XEventsQueued returns the number of");
	report_assertion("events in the event queue.");

	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAlready.");
	report_strategy("Verify that XEventsQueued returned the correct number of events.");
	report_strategy("Call XEventsQueued with mode QueuedAfterFlush.");
	report_strategy("Verify that XEventsQueued returned the correct number of events.");
	report_strategy("Call XEventsQueued with mode QueuedAfterReading.");
	report_strategy("Verify that XEventsQueued returned the correct number of events.");

	tpstartup();
	setargs();
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = MapNotify;
	eventsput = 0;
	XPutBackEvent(display, &event), eventsput++;
	XPutBackEvent(display, &event), eventsput++;
	XPutBackEvent(display, &event), eventsput++;
/* Call XEventsQueued with mode QueuedAlready. */
	mode = QueuedAlready;
	_xcall_(event_count);
/* Verify that XEventsQueued returned the correct number of events. */
	if (event_count != eventsput) {
		report("Returned %d, expected %d", event_count, eventsput);
		FAIL;
	}
	else
		CHECK;
/* Call XEventsQueued with mode QueuedAfterFlush. */
	mode = QueuedAfterFlush;
	_xcall_(event_count);
/* Verify that XEventsQueued returned the correct number of events. */
	if (event_count != eventsput) {
		report("Returned %d, expected %d", event_count, eventsput);
		FAIL;
	}
	else
		CHECK;
/* Call XEventsQueued with mode QueuedAfterReading. */
	mode = QueuedAfterReading;
	_xcall_(event_count);
/* Verify that XEventsQueued returned the correct number of events. */
	if (event_count != eventsput) {
		report("Returned %d, expected %d", event_count, eventsput);
		FAIL;
	}
	else
		CHECK;
	/* empty event queue */
	XSync(display, True);

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	eventsput;
XEvent	event;
Block_Info info;
int	block_status;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XEventsQueued-2.(A)");
	report_assertion("When the number of events already in the event queue is");
	report_assertion("non-zero, then a call to XEventsQueued does not block.");

	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAlready");
	report_strategy("and verify that blocking did not occur.");
	report_strategy("Verify that XEventsQueued returned the expected number of events.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAfterFlush");
	report_strategy("and verify that blocking did not occur.");
	report_strategy("Verify that XEventsQueued returned the expected number of events.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAfterReading");
	report_strategy("and verify that blocking did not occur.");
	report_strategy("Verify that XEventsQueued returned the expected number of events.");

	tpstartup();
	setargs();
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = MapNotify;
	eventsput = 0;
	XPutBackEvent(display, &event), eventsput++;
	XPutBackEvent(display, &event), eventsput++;
	XPutBackEvent(display, &event), eventsput++;
/* Call XEventsQueued with mode QueuedAlready */
/* and verify that blocking did not occur. */
	XEventsQueued_Type(info, QueuedAlready);
	block_status = block(display, (XEvent *) NULL, &info);
	if (block_status == -1)
		return;
	else
		CHECK;
	if (block_status == 1) {
		report("Blocking occurred when it should not have.");
		FAIL;
	}
	else
		CHECK;
/* Verify that XEventsQueued returned the expected number of events. */
	if (info.int_return != eventsput) {
		delete("Unexpected number of events in event queue: %d", info.int_return);
		return;
	}
	else
		CHECK;
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = MapNotify;
	eventsput = 0;
	XPutBackEvent(display, &event), eventsput++;
	XPutBackEvent(display, &event), eventsput++;
	XPutBackEvent(display, &event), eventsput++;
/* Call XEventsQueued with mode QueuedAfterFlush */
/* and verify that blocking did not occur. */
	XEventsQueued_Type(info, QueuedAfterFlush);
	block_status = block(display, (XEvent *) NULL, &info);
	if (block_status == -1)
		return;
	else
		CHECK;
	if (block_status == 1) {
		report("Blocking occurred when it should not have.");
		FAIL;
	}
	else
		CHECK;
/* Verify that XEventsQueued returned the expected number of events. */
	if (info.int_return != eventsput) {
		delete("Unexpected number of events in event queue: %d", info.int_return);
		return;
	}
	else
		CHECK;
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = MapNotify;
	eventsput = 0;
	XPutBackEvent(display, &event), eventsput++;
	XPutBackEvent(display, &event), eventsput++;
	XPutBackEvent(display, &event), eventsput++;
/* Call XEventsQueued with mode QueuedAfterReading */
/* and verify that blocking did not occur. */
	XEventsQueued_Type(info, QueuedAfterReading);
	block_status = block(display, (XEvent *) NULL, &info);
	if (block_status == -1)
		return;
	else
		CHECK;
	if (block_status == 1) {
		report("Blocking occurred when it should not have.");
		FAIL;
	}
	else
		CHECK;
/* Verify that XEventsQueued returned the expected number of events. */
	if (info.int_return != eventsput) {
		delete("Unexpected number of events in event queue: %d", info.int_return);
		return;
	}
	else
		CHECK;
	CHECKPASS(9);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XEvent	event;
int	eventsput;
int	event_count;
Pixmap	pm;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XEventsQueued-3.(A)");
	report_assertion("When the number of events already in the event queue is");
	report_assertion("non-zero, then a call to XEventsQueued does not flush the");
	report_assertion("output buffer.");

	report_strategy("Create client2.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Create pixmap.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAlready.");
	report_strategy("Empty the buffer.");
	report_strategy("Ensure the server has dealt with anything flushed to it: do XSync()");
	report_strategy("Verify that the output buffer was not flushed by effect on server.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Create pixmap.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAfterFlush.");
	report_strategy("Empty the buffer.");
	report_strategy("Ensure the server has dealt with anything flushed to it: do XSync()");
	report_strategy("Verify that the output buffer was not flushed by effect on server.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Create pixmap.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAfterReading.");
	report_strategy("Empty the buffer.");
	report_strategy("Ensure the server has dealt with anything flushed to it: do XSync()");
	report_strategy("Verify that the output buffer was not flushed by effect on server.");
	report_strategy("Discard all left-over events in the event queue.");

	tpstartup();
	setargs();
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Discard all events on the event queue. */
	XSync(display, True);
/* Check whether this Xlib auto-flushes. */
	XNoOp(display);
	if (!XTestDiscard(display))
	{
		report("Flushing appears to happen automatically");
		UNTESTED;
		return;
	}
/* Create pixmap. */
	/* avoid using makepixm() */
	pm = XCreatePixmap(display, DRW(display), 10, 10, 1);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = MapNotify;
	eventsput = 0;
	XPutBackEvent(display, &event), eventsput++;
/* Call XEventsQueued with mode QueuedAlready. */
	mode = QueuedAlready;
	_xcall_(event_count);
/* Empty the buffer. */
	(void)XTestDiscard(display);
/* Ensure the server has dealt with anything flushed to it: do XSync() */
	XSync(display, False);
/* Verify that the output buffer was not flushed by effect on server. */
	_startcall(client2);
	XFreePixmap(client2, pm);
	XSync(client2, True);
	_endcall(client2);
	if (geterr() == Success) {
		/* pixmap was free'd */
		report("The output buffer was flushed.");
		FAIL;
	}
	else	/* no need to free as not created */
		CHECK;

	if (event_count != eventsput) {
		report("Incorrect number of events returned.");
		FAIL;
	}
	else
		CHECK;
/* Discard all events on the event queue. */
	XSync(display, True);
/* Create pixmap. */
	/* avoid using makepixm() */
	pm = XCreatePixmap(display, DRW(display), 10, 10, 1);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = MapNotify;
	eventsput = 0;
	XPutBackEvent(display, &event), eventsput++;
/* Call XEventsQueued with mode QueuedAfterFlush. */
	mode = QueuedAfterFlush;
	_xcall_(event_count);
/* Empty the buffer. */
	(void)XTestDiscard(display);
/* Ensure the server has dealt with anything flushed to it: do XSync() */
	XSync(display, False);
/* Verify that the output buffer was not flushed by effect on server. */
	_startcall(client2);
	XFreePixmap(client2, pm);
	XSync(client2, True);
	_endcall(client2);
	if (geterr() == Success) {
		/* pixmap was free'd */
		report("The output buffer was flushed.");
		FAIL;
	}
	else	/* no need to free as not created */
		CHECK;

	if (event_count != eventsput) {
		report("Incorrect number of events returned.");
		FAIL;
	}
	else
		CHECK;
/* Discard all events on the event queue. */
	XSync(display, True);
/* Create pixmap. */
	/* avoid using makepixm() */
	pm = XCreatePixmap(display, DRW(display), 10, 10, 1);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = MapNotify;
	eventsput = 0;
	XPutBackEvent(display, &event), eventsput++;
/* Call XEventsQueued with mode QueuedAfterReading. */
	mode = QueuedAfterReading;
	_xcall_(event_count);
/* Empty the buffer. */
	(void)XTestDiscard(display);
/* Ensure the server has dealt with anything flushed to it: do XSync() */
	XSync(display, False);
/* Verify that the output buffer was not flushed by effect on server. */
	_startcall(client2);
	XFreePixmap(client2, pm);
	XSync(client2, True);
	_endcall(client2);
	if (geterr() == Success) {
		/* pixmap was free'd */
		report("The output buffer was flushed.");
		FAIL;
	}
	else	/* no need to free as not created. */
		CHECK;

	if (event_count != eventsput) {
		report("Incorrect number of events returned.");
		FAIL;
	}
	else
		CHECK;
/* Discard all left-over events in the event queue. */
	_startcall(display);
	XSync(display, True);
	_endcall(display);

	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int	event_count;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XEventsQueued-4.(A)");
	report_assertion("When there are no events in the event queue, then a call to");
	report_assertion("XEventsQueued with mode set to QueuedAlready returns zero.");

	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAlready.");
	report_strategy("Verify that XEventsQueued returned the correct number of events.");

	tpstartup();
	setargs();
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XEventsQueued with mode QueuedAlready. */
	mode = QueuedAlready;
	_xcall_(event_count);
/* Verify that XEventsQueued returned the correct number of events. */
	if (event_count != 0) {
		report("Returned %d, expected none", event_count);
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int	event_count;
Pixmap	pm;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XEventsQueued-5.(A)");
	report_assertion("When there are no events in the event queue, then a call to");
	report_assertion("XEventsQueued with mode set to QueuedAfterFlush flushes the");
	report_assertion("output buffer.");

	report_strategy("Create client2.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Create pixmap.");
	report_strategy("Call XEventsQueued with mode QueuedAfterFlush.");
	report_strategy("Empty the buffer.");
	report_strategy("Ensure the server has dealt with anything flushed to it: do XSync()");
	report_strategy("Verify that the output buffer was flushed by effect on server.");
	report_strategy("Verify that XEventsQueued returned the correct number of events.");
	report_strategy("Verify that errors did not occur after call to XEventsQueued.");

	tpstartup();
	setargs();
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Discard all events on the event queue. */
	XSync(display, True);
/* Create pixmap. */
	/* avoid using makepixm() */
	pm = XCreatePixmap(display, DRW(display), 10, 10, 1);
/* Call XEventsQueued with mode QueuedAfterFlush. */
	mode = QueuedAfterFlush;
	_xcall_(event_count);
/* Empty the buffer. */
	(void)XTestDiscard(display);
/* Ensure the server has dealt with anything flushed to it: do XSync() */
	XSync(display, False);
/* Verify that the output buffer was flushed by effect on server. */
	_startcall(client2);
	XFreePixmap(client2, pm);
	XSync(client2, True);
	_endcall(client2);
	if (geterr() != Success) {
		report("The output buffer was not flushed.");
		XFreePixmap(display, pm);
		FAIL;
	}
	else
		CHECK;
/* Verify that XEventsQueued returned the correct number of events. */
	if (event_count != 0) {
		report("Returned %d, expected none", event_count);
		FAIL;
	}
	else
		CHECK;
/* Verify that errors did not occur after call to XEventsQueued. */
	if (geterr() != Success) {
		report("The output buffer was flushed.");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Block_Info info;
int	block_status;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XEventsQueued-6.(A)");
	report_assertion("When there are no events in the event queue, then a call to");
	report_assertion("XEventsQueued with mode set to QueuedAfterFlush or");
	report_assertion("QueuedAfterReading attempts to read more events out of the");
	report_assertion("client's connection without blocking and returns the number");
	report_assertion("read.");

	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAfterFlush");
	report_strategy("and verify that blocking did not occur.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XEventsQueued with mode QueuedAfterReading");
	report_strategy("and verify that blocking did not occur.");

	tpstartup();
	setargs();
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XEventsQueued with mode QueuedAfterFlush */
/* and verify that blocking did not occur. */
	XEventsQueued_Type(info, QueuedAfterFlush);
	block_status = block(display, (XEvent *) NULL, &info);
	if (block_status == -1)
		return;
	else
		CHECK;
	if (block_status == 1) {
		report("Blocking occurred with QueuedAfterFlush when it should not have.");
		FAIL;
	}
	else
		CHECK;
	if (info.int_return != 0) {
		delete("Unexpected number of events in event queue: %d", info.int_return);
		return;
	}
	else
		CHECK;
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XEventsQueued with mode QueuedAfterReading */
/* and verify that blocking did not occur. */
	XEventsQueued_Type(info, QueuedAfterReading);
	block_status = block(display, (XEvent *) NULL, &info);
	if (block_status == -1)
		return;
	else
		CHECK;
	if (block_status == 1) {
		report("Blocking occurred with QueuedAfterReading when it should not have.");
		FAIL;
	}
	else
		CHECK;
	if (info.int_return != 0) {
		delete("Unexpected number of events in event queue: %d", info.int_return);
		return;
	}
	else
		CHECK;
	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
