/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetWMProtocols(display, w, protocols_return, count_return)
 *   Display	*display;
 *   Window	w;
 *   Atom	**protocols_return;
 *   int	*count_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetWMProtocols	1
char    *TestName = "XGetWMProtocols";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XGetWMProtocols function
 */
static Display	*display;
static Window	w;
static Atom	**protocols_return;
static int	*count_return;


static int 	StatusReturn;

#include	"X11/Xatom.h"
Atom	*protret;
int	countret;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	protocols_return = &protret;
	count_return = &countret;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status		status;
XVisualInfo	*vp;
int		nats = 5;
Atom		prots[5];
Atom		*retprots = NULL;
Atom		at, *atp;
int 		i, cntret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetWMProtocols-1.(A)");
	report_assertion("When the WM_PROTOCOLS property is set on the window w, is");
	report_assertion("of type ATOM, and is of format 32, then a call to");
	report_assertion("XGetWMProtocols returns the list of atoms stored in the");
	report_assertion("property, which can be freed with XFree, in the");
	report_assertion("protocols_return argument, the number of atoms in the");
	report_assertion("count_return argument and returns non-zero.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Set the WM_PROTOCOLS property using XSetWMProtocols.");
	report_strategy("Obtain the value of the WM_PROTOCOLS property using XGetWMProtocols.");
	report_strategy("Verify that the call did not return False.");
	report_strategy("Verify that the value was correct.");
	report_strategy("Free the allocated memory using XFree.");

	tpstartup();
	setargs();

	for(i=0, at = XA_LAST_PREDEFINED; i<nats; i++)
		prots[i] = (int) --at;

	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);

	XSetWMProtocols(display, w, prots, nats);

	protocols_return = &retprots;
	count_return = &cntret;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMProtocols(display, w, protocols_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == False) {
		delete("%s() returned False.", TestName);
		return;
	} else
		CHECK;

	if(cntret != nats) {
		report("The number of elements set for the WM_PROTOCOLS property was %d instead of %d", cntret, nats);
		FAIL;
	} else
		CHECK;

	if(retprots == (Atom *) NULL) {
		report("The WM_PROTOCOLS property had no associated value.");
		FAIL;		
	} else {

		CHECK;
		for(i = 0, atp = retprots; i<nats; i++, atp++)
			if( *atp != prots[i]) {
				report("Element %d of the WM_PROTOCOLS value was %lu instead of %lu", i+1, (long) *atp, (long) prots[i]);
				FAIL;
			} else
				CHECK;
		
		XFree((char*)retprots);
	}

	CHECKPASS(nats + 3);


	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.9717 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetWMProtocols-2.(B)");
	report_assertion("When the atom name (lqWM_PROTOCOLS(rq cannot be interned,");
	report_assertion("then a call to XGetWMProtocols does not set the");
	report_assertion("protocols_return or count_return arguments and returns zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.9717 */

static void t003(){

Status		status;
Atom		at, xa_wm_protocols;
Atom		*rat;
int		rcnt;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetWMProtocols-3.(A)");
	report_assertion("When the WM_PROTOCOLS property is not set on the window w,");
	report_assertion("or is not of type ATOM, or is not of format 32, then a call");
	report_assertion("to XGetWMProtocols does not set the protocols_return or");
	report_assertion("count_return arguments and returns zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Insure that the name \"WM_PROTOCOLS\" is interned using XSetWMProtocols.");
	report_strategy("Obtain the WM_PROTOCOLS atom using XInternAtom.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Initialise the protocols_return and count_return arguments.");
	report_strategy("Obtain the value of the WM_PROTOCOLS property with XGetWMProtocols.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that protocols_return and count_return arguments were unchanged.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_PROTOCOLS property with format 16 and type ATOM using XChangeProperty.");
	report_strategy("Initialise the protocols_return and count_return arguments.");
	report_strategy("Obtain the value of the WM_PROTOCOLS property with XGetWMProtocols.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that protocols_return and count_return arguments were unchanged.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Initialise the protocols_return and count_return arguments.");
	report_strategy("Set the WM_PROTOCOLS property with format 32 type STRING using XChangeProperty.");
	report_strategy("Obtain the value of the WM_PROTOCOLS property with XGetWMProtocols.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that protocols_return and count_return arguments were unchanged.");
	report_strategy("");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);

	protocols_return = &rat;
	count_return = &rcnt;
	w = makewin(display, vp);
	
	if( (at = XInternAtom(display, XT_TIMESTAMP, False)) == None) {
		delete("The \"%s\" string was not interned.", XT_TIMESTAMP);
		return;
	} else
		CHECK;

	if(XSetWMProtocols(display, w, &at, 1) == False) {
		delete("XSetWMProtocols() returned False.");
		return;
	} else
		CHECK;

	if( (xa_wm_protocols = XInternAtom(display, "WM_PROTOCOLS", True)) == None) {
		delete("The \"WM_PROTOCOLS\" string was not interned.");
		return;
	} else
		CHECK;

	w = makewin(display, vp);

/* Property unset */

	rat = (Atom *) -1;
	rcnt = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMProtocols(display, w, protocols_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the WM_PROTOCOLS property was not set.", TestName);
		FAIL;
	} else
		CHECK;

	if( rat != (Atom *) -1) {
		report("Atom list pointer variable was updated when the WM_PROTOCOLS property was not set.");
		FAIL;
	} else
		CHECK;

	if( rcnt != -1) {
		report("Atom count variable was updated when the WM_PROTOCOLS property was not set.");
		FAIL;
	} else
		CHECK;



	w = makewin(display, vp);


/* format 16 */
 	XChangeProperty(display, w, xa_wm_protocols, XA_ATOM, 16, PropModeReplace, (unsigned char *) &at, 1);

	rat = (Atom *) -1;
	rcnt = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMProtocols(display, w, protocols_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the WM_PROTOCOLS property had format 16.", TestName);
		FAIL;
	} else
		CHECK;

	if( rat != (Atom *) -1) {
		report("Atom list pointer variable was updated when the WM_PROTOCOLS property had format 16.");
		FAIL;
	} else
		CHECK;

	if( rcnt != -1) {
		report("Atom count variable was updated when the WM_PROTOCOLS property had format 16.");
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);

/* Type STRING */
 	XChangeProperty(display, w, xa_wm_protocols, XA_STRING, 32, PropModeReplace, (unsigned char *) &at, 1);

	rat = (Atom *) -1;
	rcnt = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMProtocols(display, w, protocols_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the WM_PROTOCOLS property had type STRING.", TestName);
		FAIL;
	} else
		CHECK;

	if( rat != (Atom *) -1) {
		report("Atom list pointer variable was updated when the WM_PROTOCOLS property had type STRING.");
		FAIL;
	} else
		CHECK;

	if( rcnt != -1) {
		report("Atom count variable was updated when the WM_PROTOCOLS property had type STRING.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(12);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGetWMProtocols-4.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetWMProtocols(display, w, protocols_return, count_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
