/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XrmStringToQuarkList(string, quarks_return)
 *   char *string;
 *   XrmQuarkList quarks_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmStringToQuarkList	1
char    *TestName = "XrmStringToQuarkList";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmStringToQuarkList function
 */
static char *string;
static XrmQuarkList quarks_return;


#define XSTQL_MAX_RETURN 10
static XrmQuark xstql_ret[XSTQL_MAX_RETURN];

static char *xstql_s1[]={
	"xstql_test",
	"ena",
	"deo",
	"tria"};

static char *xstql_s1sep[]={
	".",
	".",
	".",
	""};

static int xstql_ns1=NELEM(xstql_s1);

static char *xstql_s2[]={
	"XStql_test",
	"une",
	"deux",
	"trois",
	"erm",
	"five"};
static char *xstql_s2sep[]={
	"*",
	".",
	"*",
	"*",
	".",
	""};
static int xstql_ns2=NELEM(xstql_s2);

static char *xstql_s3[]={
	"XStqL_test.",
	"jack.",
	"and.",
	"jill"};
static int xstql_ns3=NELEM(xstql_s3);

static void
xstqlclear(value)
XrmQuark value;
{
	int i;

/* Clear the return array, to avoid rogue results. */
	for(i=0; i<XSTQL_MAX_RETURN; i++) 
		xstql_ret[i]=value;

}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	string = 0;
	quarks_return = (XrmQuarkList)xstql_ret;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int  t;
char *buffer1;
char *buffer2;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmStringToQuarkList-1.(A)");
	report_assertion("When string is a valid null-terminated resource name format");
	report_assertion("string, then a call to XrmStringToQuarkList returns a quark");
	report_assertion("list in quarks_return corresponding to the components of");
	report_assertion("string.");

	report_strategy("Create the test string.");
	report_strategy("Call XrmStringToQuarkList to obtain quark list.");
	report_strategy("Verify that the quark list returned was as expected.");

	tpstartup();
	setargs();
	buffer1 = (char *)malloc( (size_t)256);
	if (buffer1==(char *)NULL) {
		delete("Could not malloc 256 bytes for buffer1.");
		return;
	} else
		CHECK;

	buffer2 = (char *)malloc( (size_t)4096);
	if (buffer2==(char *)NULL) {
		delete("Could not malloc 4096 bytes for buffer2.");
		return;
	} else
		CHECK;

	*buffer1='\0'; /* Make the buffers empty strings. */
	*buffer2='\0';

/* Create the test string. */
	for(t=0; t<xstql_ns1; t++) {
		strcat(buffer1, xstql_s1[t]);
		strcat(buffer1, xstql_s1sep[t]);
	}
	trace("Testing with '%s'", buffer1);

	xstqlclear((XrmQuark)0);

/* Call xname to obtain quark list. */
	string= buffer1;
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmStringToQuarkList(string, quarks_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

#ifdef TESTING
	xstql_ret[0]=0;
	xstql_ret[1]=XrmStringToQuark("TESTING");
#endif

/* Verify that the quark list returned was as expected. */
	for(t=0; t<xstql_ns1; t++) {
		char *ts;

		ts = XrmQuarkToString( xstql_ret[t] );
		if (ts == (char *)NULL) {
			FAIL;
			report("Quark array[%d]=%d. Represents: NO STRING (expecting '%s')",
				t, xstql_ret[t], xstql_s1[t]);
			strcat(buffer2,"<NO STRING>");
		} else
		{
			if(strcmp(xstql_s1[t], ts)) {
				FAIL;
				report("Quark array[%d]=%d. Represents: '%s' (expecting '%s')",
					t, xstql_ret[t], ts, xstql_s1[t]);
			} else {
				CHECK;
				trace("Quark array[%d]=%d. Represents: '%s' as expected.",
					t, xstql_ret[t], ts );
			}
			strcat(buffer2, ts);
		}
		strcat(buffer2, " ");
	}

	if (fail) {
		report("%s did not split the string into the quarks as expected",
			TestName);
		report("String passed to %s: '%s'", TestName, buffer1);
		report("Quark array represents: %s", buffer2);
	} else
		CHECK;

	CHECKPASS(2+xstql_ns1+1);
	free(buffer1);
	free(buffer2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int  t;
char *buffer1;
char *buffer2;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmStringToQuarkList-2.(A)");
	report_assertion("On a call to XrmStringToQuarkList, the string is separated");
	report_assertion("into components according to the positions of periods and");
	report_assertion("asterisks.");

	report_strategy("Create the test string.");
	report_strategy("Call XrmStringToQuarkList to obtain quark list.");
	report_strategy("Verify that the quark list returned was as expected.");

	tpstartup();
	setargs();
	buffer1 = (char *)malloc( (size_t)256);
	if (buffer1==(char *)NULL) {
		delete("Could not malloc 256 bytes for buffer1.");
		return;
	} else
		CHECK;

	buffer2 = (char *)malloc( (size_t)4096);
	if (buffer2==(char *)NULL) {
		delete("Could not malloc 4096 bytes for buffer2.");
		return;
	} else
		CHECK;

	*buffer1='\0'; /* Make the buffers empty strings. */
	*buffer2='\0';

/* Create the test string. */
	for(t=0; t<xstql_ns2; t++) {
		strcat(buffer1, xstql_s2[t]);
		strcat(buffer1, xstql_s2sep[t]);
	}
	trace("Testing with '%s'", buffer1);

	xstqlclear((XrmQuark)0);

/* Call xname to obtain quark list. */
	string= buffer1;
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmStringToQuarkList(string, quarks_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

#ifdef TESTING
	xstql_ret[0]=0;
	xstql_ret[1]=XrmStringToQuark("TESTING");
#endif

/* Verify that the quark list returned was as expected. */
	for(t=0; t<xstql_ns2; t++) {
		char *ts;

		ts = XrmQuarkToString( xstql_ret[t] );
		if (ts == (char *)NULL) {
			FAIL;
			report("Quark array[%d]=%d. Represents: NO STRING (expecting '%s')",
				t, xstql_ret[t], xstql_s2[t]);
			strcat(buffer2,"<NO STRING>");
		} else
		{
			if(strcmp(xstql_s2[t], ts)) {
				FAIL;
				report("Quark array[%d]=%d. Represents: '%s' (expecting '%s')",
					t, xstql_ret[t], ts, xstql_s2[t]);
			} else {
				CHECK;
				trace("Quark array[%d]=%d. Represents: '%s' as expected.",
					t, xstql_ret[t], ts );
			}
			strcat(buffer2, ts);
		}
		strcat(buffer2, " ");
	}

	if (fail) {
		report("%s did not split the string into the quarks as expected",
			TestName);
		report("String passed to %s: '%s'", TestName, buffer1);
		report("Quark array represents: '%s'", buffer2);
	} else
		CHECK;

	CHECKPASS(2+xstql_ns2+1);
	free(buffer1);
	free(buffer2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

char *buffer1;
XrmQuark unq;
int t;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XrmStringToQuarkList-3.(A)");
	report_assertion("On a call to XrmStringToQuarkList, the quarks_return list");
	report_assertion("is terminated with a zero.");

	report_strategy("Create the test string.");
	report_strategy("Set return buffer with unique quark value.");
	report_strategy("Call XrmStringToQuarkList to obtain quark list.");
	report_strategy("Verify that the quark list was zero terminated.");

	tpstartup();
	setargs();
	buffer1 = (char *)malloc( (size_t)256);
	if (buffer1==(char *)NULL) {
		delete("Could not malloc 256 bytes for buffer1.");
		return;
	} else
		CHECK;

	*buffer1='\0';

/* Create the test string. */
	for(t=0; t<xstql_ns3; t++) {
		strcat(buffer1, xstql_s3[t]);
	}
	trace("Testing with '%s'", buffer1);

/* Set return buffer with unique quark value. */
	unq=XrmUniqueQuark();
	xstqlclear(unq);

/* Call xname to obtain quark list. */
	string= buffer1;
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmStringToQuarkList(string, quarks_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the quark list was zero terminated. */
	t=0;
	while(t<XSTQL_MAX_RETURN
		&& xstql_ret[t] != unq
		&& xstql_ret[t] != (XrmQuark)0) {
		t++;
	}

	if (t==XSTQL_MAX_RETURN) {
		int i;
		FAIL;
		report("%s did not return the quark array as expected.",
			TestName);
		report("At least %d quarks returned.", XSTQL_MAX_RETURN);
		for (i=0; i<XSTQL_MAX_RETURN; i++)
			report("Quark array[%d]=%d", i, xstql_ret[i]);
	} else {
		if (xstql_ret[t] == unq) {
			FAIL;
			report("%s did not terminate the array with a zero.",
				TestName);
		} else
			CHECK;
	}

	CHECKPASS(2);
	free(buffer1);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
