/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XCirculateSubwindows(display, w, direction)
 *   Display	*display;
 *   Window	w;
 *   int 	direction;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCirculateSubwindows	1
char    *TestName = "XCirculateSubwindows";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XCirculateSubwindows function
 */
static Display	*display;
static Window	w;
static int 	direction;



static char	*SimpleTemplate[] = {
	".",
	"zero . (20,10) 40x40",
	"one . (30,20) 40x40",
	"two . (10,30) 40x40",
	"other1 . (75,10) 15x70",
};
static int	NSimpleTemplate = NELEM(SimpleTemplate);

static char	*Expose1Template[] = {
	".",
	"zero . (20,10) 40x40",
	"other1 . (75,10) 15x70",
};
static int	NExpose1Template = NELEM(Expose1Template);

static char	*Expose2Template[] = {
	".",
	"one . (30,20) 40x40",
	"two . (10,30) 40x40",
};
static int	NExpose2Template = NELEM(Expose2Template);



/* Value list for use in test t006 */
static int 	directionvallist[] = {
	RaiseLowest,
	LowerHighest,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
	direction = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Window	parent;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCirculateSubwindows-1.(A)");
	report_assertion("When direction is RaiseLowest and there is a mapped child");
	report_assertion("that is occluded by another child, then a call to");
	report_assertion("XCirculateSubwindows raises the lowest such mapped child to");
	report_assertion("the top of the stack.");

	report_strategy("Create a window hierarchy using buildtree.");
	report_strategy("Call XCirculateSubwindows with direction of RaiseLowest upon parent.");
	report_strategy("Verify that the lowest occluded mapped child window was raised");

	tpstartup();
	setargs();
/* Create a window hierarchy using buildtree. */
	parent =  defwin(display);
	buildtree(display, parent, SimpleTemplate, NSimpleTemplate);

/* Call xname with direction of RaiseLowest upon parent. */
	w = parent;
	direction = RaiseLowest;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindows(display, w, direction);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the lowest occluded mapped child window was raised */
	PIXCHECK(display, parent);

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window	parent;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCirculateSubwindows-2.(A)");
	report_assertion("When direction is LowerHighest and there is a mapped child");
	report_assertion("that occludes another child, then a call to");
	report_assertion("XCirculateSubwindows lowers the highest such mapped child to");
	report_assertion("the bottom of the stack.");

	report_strategy("Create a window hierarchy using buildtree.");
	report_strategy("Call XCirculateSubwindows with direction of LowerHighest upon parent.");
	report_strategy("Verify that the highest occluding mapped child window was lowered");

	tpstartup();
	setargs();
/* Create a window hierarchy using buildtree. */
	parent =  defwin(display);
	buildtree(display, parent, SimpleTemplate, NSimpleTemplate);

/* Call xname with direction of LowerHighest upon parent. */
	w = parent;
	direction = LowerHighest;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindows(display, w, direction);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the highest occluding mapped child window was lowered */
	PIXCHECK(display, parent);

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

struct	buildtree	*tree1;
Window	parent, zero;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCirculateSubwindows-3.(A)");
	report_assertion("When a call to XCirculateSubwindows uncovers part of any");
	report_assertion("window that was formerly obscured, then either Expose events");
	report_assertion("are generated or the contents are restored from backing");
	report_assertion("store.");

	report_strategy("Create a window hierarchy using buildtree.");
	report_strategy("Call setforexpose on window 'zero' to allow Expose event checking.");
	report_strategy("Select Expose events on window 'zero'.");
	report_strategy("Call XCirculateSubwindows in order to expose window 'zero'.");
	report_strategy("Use exposecheck to ensure that the window 'zero' was restored correctly.");

	tpstartup();
	setargs();
/* Create a window hierarchy using buildtree. */
	parent =  defwin(display);
	tree1= buildtree(display, parent, Expose1Template, NExpose1Template);
	zero = btntow(tree1, "zero");

/* Call setforexpose on window 'zero' to allow Expose event checking. */
	setforexpose(display, zero);	
	buildtree(display, parent, Expose2Template, NExpose2Template);

/* Select Expose events on window 'zero'. */
	XSelectInput(display, zero, ExposureMask);

/* Call xname in order to expose window 'zero'. */
	w = parent;
	direction = RaiseLowest;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindows(display, w, direction);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Use exposecheck to ensure that the window 'zero' was restored correctly. */
	if (!exposecheck(display, zero)) {
		report("Neither Expose events or backing store processing");
		report("could correctly restore the window contents.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display	*client1,*client2;
struct	buildtree	*c1tree;
XImage	*image;
Window	parent, zero, one, two;
XEvent	ev;
int	numevent;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCirculateSubwindows-4.(A)");
	report_assertion("When some other client has selected");
	report_assertion("SubstructureRedirectMask on the window, then a");
	report_assertion("CirculateRequest event is generated, and no further");
	report_assertion("processing is performed.");

	report_strategy("Create client1 and client2 with a window on client1");
	report_strategy("Create a window hierarchy for client1.");
	report_strategy("Save parent window image as reference image.");
	report_strategy("Select all events other than SubstructureRedirectMask events on all the windows for client1, to catch rogue events.");
	report_strategy("Select SubstructureRedirectMask on the parent window for client2.");
	report_strategy("Call XCirculateSubwindows with direction RaiseLowest on client1 in order to raise window zero.");
	report_strategy("Verify that no events were delivered to client1 using getevent.");
	report_strategy("Verify that a correct CirculateRequest event was delievered to client2 using getevent and checkevent.");
	report_strategy("Verify that no further processing occurred by comparing the window and our reference image.");
	report_strategy("Call XCirculateSubwindows with direction LowerHighest on client1 in order to lower window two.");
	report_strategy("Verify that no events were delivered to client1 using getevent.");
	report_strategy("Verify that a correct CirculateRequest event was delievered to client2 using getevent and checkevent.");
	report_strategy("Verify that no further processing occurred by comparing the window and our reference image.");

	tpstartup();
	setargs();
/* Create client1 and client2 with a window on client1 */
	client1 = opendisplay();
	if (client1 == NULL) {
		delete("could not create client1");
		return;
	}
	else
		CHECK;
	client2 = opendisplay();
	if (client2 == NULL) {
		delete("could not create client2");
		return;
	}
	else
		CHECK;

/* Create a window hierarchy for client1. */
	parent = defwin(client1);
	c1tree = buildtree(client1, parent, SimpleTemplate, NSimpleTemplate);
	zero = btntow(c1tree, "zero");
	one  = btntow(c1tree, "one");
	two  = btntow(c1tree, "two");

/* Save parent window image as reference image. */
	image= savimage(client1, parent);

/* Select all events other than SubstructureRedirectMask events on all the windows for client1, to catch rogue events. */
	XSelectInput(client1, parent, ALLEVENTS & ~(SubstructureRedirectMask));
	XSelectInput(client1, zero, ALLEVENTS & ~(SubstructureRedirectMask));
	XSelectInput(client1, one, ALLEVENTS & ~(SubstructureRedirectMask));
	XSelectInput(client1, two, ALLEVENTS & ~(SubstructureRedirectMask));

/* Select SubstructureRedirectMask on the parent window for client2. */
	XSelectInput(client2, parent, SubstructureRedirectMask);
	XSync(client2, True);

/* Call xname with direction RaiseLowest on client1 in order to raise window zero. */
	display = client1;
	w = parent;
	direction = RaiseLowest;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindows(display, w, direction);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

/* Verify that no events were delivered to client1 using getevent. */
	numevent = getevent(client1, &ev);
	if( numevent != 0 ) {
		FAIL;
		report("%d unexpected %s delivered to client1",
			numevent, (numevent==1)?"event was":"events were");
		report("%sevent was %s", (numevent!=1)?"first ":"",
			eventname(ev.type));
		while(getevent(client1, &ev) != 0)
			report("next event was %s", eventname(ev.type));
	} else
		CHECK;

/* Verify that a correct CirculateRequest event was delievered to client2 using getevent and checkevent. */
	numevent = getevent(client2, &ev);
	if( numevent != 1 ) {
		FAIL;
		report("Expecting a single CirculateRequest event");
		report("Received %d events", numevent);
		if(numevent != 0) {
			report("First event was %s", eventname(ev.type));
			while(getevent(client2, &ev) != 0)
				report("next event was %s", eventname(ev.type));
		}
	} else {
		XCirculateRequestEvent	good;

		good.type = CirculateRequest;
		good.serial = 0;
		good.send_event = False;
		good.display = client2;
		good.parent = parent;
		good.window = zero;
		good.place = PlaceOnTop;
		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Verify that no further processing occurred by comparing the window and our reference image. */
	if(!compsavimage(client1, parent, image)) {
		FAIL;
	} else {
		CHECK;
	}

/* Call xname with direction LowerHighest on client1 in order to lower window two. */
	display = client1;
	w = parent;
	direction = LowerHighest;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindows(display, w, direction);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

/* Verify that no events were delivered to client1 using getevent. */
	numevent = getevent(client1, &ev);
	if( numevent != 0 ) {
		FAIL;
		report("%d unexpected %s delivered to client1",
			numevent, (numevent==1)?"event was":"events were");
		report("%sevent was %s", (numevent!=1)?"first ":"",
			eventname(ev.type));
		while(getevent(client1, &ev) != 0)
			report("next event was %s", eventname(ev.type));
	} else
		CHECK;

/* Verify that a correct CirculateRequest event was delievered to client2 using getevent and checkevent. */
	numevent = getevent(client2, &ev);
	if( numevent != 1 ) {
		FAIL;
		report("Expecting a single CirculateRequest event");
		report("Received %d events", numevent);
		if(numevent != 0) {
			report("First event was %s", eventname(ev.type));
			while(getevent(client2, &ev) != 0)
				report("next event was %s", eventname(ev.type));
		}
	} else {
		XCirculateRequestEvent	good;

		good.type = CirculateRequest;
		good.serial = 0;
		good.send_event = False;
		good.display = client2;
		good.parent = parent;
		good.window = two;
		good.place = PlaceOnBottom;
		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Verify that no further processing occurred by comparing the window and our reference image. */
	if(!compsavimage(client1, parent, image)) {
		FAIL;
	} else {
		CHECK;
	}
	CHECKPASS(8);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Display	*client1, *client2, *client3;
struct	buildtree	*tree;
Window	parent, zero, one, two;
XEvent	ev;
int	numevent;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCirculateSubwindows-5.(A)");
	report_assertion("When a child is actually restacked, then a CirculateNotify");
	report_assertion("event is generated.");

	report_strategy("Create client1, client2, and client3, with a window on client1");
	report_strategy("Create a window hierarchy using buildtree.");
	report_strategy("Select StructureNotifyMask events on the windows zero on client2");
	report_strategy("Select SubstructureNotifyMask events on the parent window on client3");
	report_strategy("Call XCirculateSubwindows in order to raise window zero with direction RaiseLowest.");
	report_strategy("Verify that a correct CirculateNotify event was delivered to window zero");
	report_strategy("Verify that a correct CirculateNotify event was delivered to the");
	report_strategy("     parent window on client3 using getevent and checkevent.");
	report_strategy("Call XCirculateSubwindows in order to lower window zero with direction LowerHighest");
	report_strategy("Verify that a correct CirculateNotify event was delivered to ");
	report_strategy("	window zero on client2 using getevent and checkevent.");
	report_strategy("Verify that a correct CirculateNotify event was delivered to the");
	report_strategy("	parent window on client3 using getevent and checkevent.");

	tpstartup();
	setargs();
/* Create client1, client2, and client3, with a window on client1 */
	client1 = opendisplay();
	if (client1 == NULL) {
		delete("could not create client1");
		return;
	}
	else
		CHECK;
	client2 = opendisplay();
	if (client2 == NULL) {
		delete("could not create client2");
		return;
	}
	else
		CHECK;
	client3 = opendisplay();
	if (client3 == NULL) {
		delete("could not create client3");
		return;
	}
	else
		CHECK;
	parent = defwin(client1);

/* Create a window hierarchy using buildtree. */
	tree = buildtree(client1, parent, SimpleTemplate, NSimpleTemplate);
	zero = btntow(tree, "zero"); trace("window zero is %0x", zero);
	one  = btntow(tree, "one");  trace("window one is %0x", one);
	two  = btntow(tree, "two");  trace("window two is %0x", two);

/* Select StructureNotifyMask events on the windows zero on client2 */
	XSelectInput(client2, zero, StructureNotifyMask);
	XSync(client2, True);

/* Select SubstructureNotifyMask events on the parent window on client3 */
	XSelectInput(client3, parent, SubstructureNotifyMask);
	XSync(client3 , True);

/* Call xname in order to raise window zero with direction RaiseLowest. */
	display = client1;
	w = parent;
	direction = RaiseLowest;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindows(display, w, direction);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);
	XSync(client3, False);

/* Verify that a correct CirculateNotify event was delivered to window zero */
/*	on client2 using getevent and checkevent. */
	numevent = getevent(client2, &ev);
	trace("%d events were queued on client2", numevent);
	if (numevent == 0) {
		FAIL;
		report("No event was delivered to client2 when the child windows");
		report("were restacked. Expecting a CirculateNotify event");
	} else {
		XCirculateEvent	good;

		trace("Checking that:");
		trace("display==client2, event==zero, window==zero,");
		trace("place==PlaceOnTop");

		good.type = CirculateNotify;
		good.serial = 0;
		good.send_event = False;
		good.display = client2;
		good.event = zero;
		good.window = zero;
		good.place = PlaceOnTop;
		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Verify that a correct CirculateNotify event was delivered to the */
/*      parent window on client3 using getevent and checkevent. */
	numevent = getevent(client3, &ev);
	trace("%d events were queued on client3", numevent);
	if (numevent == 0) {
		FAIL;
		report("No event was delivered to client3 when the child windows");
		report("were restacked. Expecting a CirculateNotify event");
	} else {
		XCirculateEvent	good;

		trace("Checking that:");
		trace("display==client3, event==parent, window==zero,");
		trace("place==PlaceOnTop");

		good.type = CirculateNotify;
		good.serial = 0;
		good.send_event = False;
		good.display = client3;
		good.event = parent;
		good.window = zero;
		good.place = PlaceOnTop;
		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Call xname in order to lower window zero with direction LowerHighest */
	display = client1;
	w = parent;
	direction = LowerHighest;
	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindows(display, w, direction);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);
	XSync(client3, False);

/* Verify that a correct CirculateNotify event was delivered to  */
/* 	window zero on client2 using getevent and checkevent. */
	numevent = getevent(client2, &ev);
	trace("%d events were queued on client2", numevent);
	if (numevent == 0) {
		FAIL;
		report("No event was delivered to client2 when the child windows");
		report("were restacked. Expecting a CirculateNotify event");
	} else {
		XCirculateEvent	good;

		trace("Checking that:");
		trace("display==client2, event==zero, window==zero,");
		trace("place==PlaceOnBottom");
		good.type = CirculateNotify;
		good.serial = 0;
		good.send_event = False;
		good.display = client2;
		good.event = zero;
		good.window = zero;
		good.place = PlaceOnBottom;
		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Verify that a correct CirculateNotify event was delivered to the */
/* 	parent window on client3 using getevent and checkevent. */
	numevent = getevent(client3, &ev);
	trace("%d events were queued on client3", numevent);
	if (numevent == 0) {
		FAIL;
		report("No event was delivered to client3 when the child windows");
		report("were restacked. Expecting a CirculateNotify event");
	} else {
		XCirculateEvent	good;

		trace("Checking that:");
		trace("display==client3, event==parent, window==zero,");
		trace("place==PlaceOnBottom");
		good.type = CirculateNotify;
		good.serial = 0;
		good.send_event = False;
		good.display = client3;
		good.event = parent;
		good.window = zero;
		good.place = PlaceOnBottom;
		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.7457 */
/* End of included file Mval.tmc.7457 */

/* Including from file error/EVal.mc */
static void t006(){

#undef	VALUE_ARG
#define	VALUE_ARG direction
#undef	VALUE_LIST
#define	VALUE_LIST directionvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCirculateSubwindows-6.(A)");
	report_assertion("When the value of direction is other than RaiseLowest or");
	report_assertion("LowerHighest, then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XCirculateSubwindows(display, w, direction);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XCirculateSubwindows-7.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCirculateSubwindows(display, w, direction);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
