/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Window
 *   XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background)
 *   Display *display;
 *   Window  parent;
 *   int 	x;
 *   int 	y;
 *   unsigned int width;
 *   unsigned int height;
 *   unsigned int border_width;
 *   unsigned long border;
 *   unsigned long background;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCreateSimpleWindow	1
char    *TestName = "XCreateSimpleWindow";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW parent
#define A_DRAWABLE parent


/*
 * Arguments to the XCreateSimpleWindow function
 */
static Display *display;
static Window  parent;
static int 	x;
static int 	y;
static unsigned int width;
static unsigned int height;
static unsigned int border_width;
static unsigned long border;
static unsigned long background;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	parent = DefaultRootWindow(Dsp);
	x = 10;
	y = 20;
	width = 5;
	height = 5;
	border_width = 3;
	border = 1;
	background = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window	w;
XWindowAttributes atts;
Status	s;
Window	junk;
Window	father;
Window	*children;
unsigned int	nchildren;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCreateSimpleWindow-1.(A)");
	report_assertion("A call to XCreateSimpleWindow creates an unmapped");
	report_assertion("InputOutput subwindow with a parent window of parent and");
	report_assertion("returns the window ID of the created window.");

	report_strategy("Call XCreateSimpleWindow.");
	report_strategy("Get window attributes.");
	report_strategy("Verify that map_state is IsUnmapped.");
	report_strategy("Verify that the class is InputOutput.");
	report_strategy("Call XQueryTree and check parent is parent.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	s = XGetWindowAttributes(Dsp, w, &atts);
	if (s == False) {
		delete("XGetWindowAttributes failed");
		return;
	} else
		CHECK;

	trace("Window created with class %s", classname(atts.class));

	if (atts.class == InputOutput) {
		CHECK;
	} else {
		report("expected class InputOutput got %s", classname(atts.class));
		FAIL;
	}

	trace("Window created with map_state %s", mapstatename(atts.map_state));

	if (atts.map_state == IsUnmapped) {
		CHECK;
	} else {
		report("expected map_state IsUnmapped got %s", mapstatename(atts.map_state));
		FAIL;
	}

	s = XQueryTree(Dsp, w, &junk, &father, &children, &nchildren);
	if (s == False) {
		delete("XQueryTree failed");
		return;
	} else
		CHECK;

	if (father != parent) {
		report("expected parent to be %lx but was %lx", parent, father);
		FAIL;
	} else
		CHECK;

	if (nchildren != 0)
		XFree((char*)children);
	XDestroyWindow(Dsp, w);
	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window	w;
XEvent	event;
XCreateWindowEvent	ge;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCreateSimpleWindow-2.(A)");
	report_assertion("On a call to XCreateSimpleWindow a CreateNotify event is");
	report_assertion("generated on the parent window.");

	report_strategy("Call XCreateSimpleWindow.");
	report_strategy("Verify that a CreateNotify event is received with correct values.");

	tpstartup();
	setargs();
	/*
	 * Create a window as the parent for this test just to insulate
	 * us from window managers a bit.
	 */
	parent = defdraw(display, VI_WIN);
	if (isdeleted())
		return;
	else
		CHECK;

	XSelectInput(Dsp, parent, ALLEVENTS);

	startcall(display);
	if (isdeleted())
		return;
	w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(Dsp, parent, NoEventMask);

	if (getevent(Dsp, &event) != 1 || event.type != CreateNotify) {
		report("Expecting one CreateNotify event");
		FAIL;
		return;
	} else
		CHECK;

	/* Set up a good event structure of what we are expecting */
	ge.type = CreateNotify;
	ge.display = display;
	ge.parent  = parent;
	ge.window  = w;
	ge.x = x;
	ge.y = y;
	ge.width   = width;
	ge.height  = height;
	ge.border_width = border_width;
	ge.override_redirect = False;

	n = checkevent((XEvent *)&ge, &event);
	if (n == 0) {
		CHECK;
	} else {
		report("error in %d field%s of event", n, (n!=1)?"s":"");
		FAIL;
	}

	XDestroyWindow(Dsp, w);
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Window	w1, w2;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCreateSimpleWindow-3.(A)");
	report_assertion("The created window is placed on top in the stacking order");
	report_assertion("with respect to siblings.");

	report_strategy("Create a parent window.");
	report_strategy("Create two overlapping sibling windows.");
	report_strategy("Verify that second window is at top of stacking order.");
	report_strategy("Verify that first sibling is next in the stacking order.");

	tpstartup();
	setargs();
	parent = defdraw(display, VI_WIN);
	if (isdeleted())
		return;
	else
		CHECK;

	startcall(display);
	if (isdeleted())
		return;
	w1 = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	startcall(display);
	if (isdeleted())
		return;
	w2 = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if ((n = stackorder(Dsp, w1)) != 0) {
		report("Stacking order for w1 was %d, expected 0", n);
		FAIL;
	} else if ((n = stackorder(Dsp, w2)) != 1) {
		report("Stacking order for w2 was %d, expected 1", n);
		FAIL;
	} else
		CHECK;

	XDestroyWindow(Dsp, w1);
	XDestroyWindow(Dsp, w2);
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Window	top;
Window	clipwin;
Window	w;
XVisualInfo	*vp;
struct	area	area;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCreateSimpleWindow-4.(A)");
	report_assertion("Any part of the window that extends outside its parent");
	report_assertion("window is clipped.");

	report_strategy("Create window to use as parent.");
	report_strategy("Create a subwindow on that with crechild.");
	report_strategy("Create a window that would extend outside previous window.");
	report_strategy("Set background to W_FG.");
	report_strategy("Map all windows.");
	report_strategy("Pixmap verify that window is clipped.");

	tpstartup();
	setargs();

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		top = (Window)makedrawable(display, vp);
		setarea(&area, 5, 5, 40, 40);
		clipwin = crechild(display, top, &area);

		parent = clipwin;
		x = 20; y = 20;
		width = 100; height = 100;
		background = W_FG;
		startcall(display);
		if (isdeleted())
			return;
		w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XMapWindow(display, w);
		if (isdeleted())
			return;
		else
			CHECK;

		PIXCHECK(display, top);
		XDestroyWindow(Dsp, w);
	}
	CHECKPASS(2*nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

XVisualInfo	*vp;
Window	w;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCreateSimpleWindow-5.(A)");
	report_assertion("The created window is not displayed.");

	report_strategy("Create window to use as parent.");
	report_strategy("Set background to other than W_BG.");
	report_strategy("Create window with XCreateSimpleWindow.");
	report_strategy("Verify that parent window is still clear.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = (Window)makedrawable(display, vp);

		background = W_FG;
		startcall(display);
		if (isdeleted())
			return;
		w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (checkclear(display, parent))
			CHECK;
		else {
			report("Created window was visible");
			FAIL;
		}
		XDestroyWindow(Dsp, w);
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Status	s;
Window	w;
XWindowAttributes	childatts;
XWindowAttributes	parentatts;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCreateSimpleWindow-6.(A)");
	report_assertion("The depth, class and visual are inherited from the parent");
	report_assertion("window.");

	report_strategy("Create window.");
	report_strategy("Verify that values of depth, class and visual are same as in parent.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	s = XGetWindowAttributes(Dsp, w, &childatts);
	if (s == False) {
		delete("XGetWindowAttributes failed");
		return;
	} else
		CHECK;

	s = XGetWindowAttributes(Dsp, DefaultRootWindow(Dsp), &parentatts);
	if (s == False) {
		delete("XGetWindowAttributes failed");
		return;
	} else
		CHECK;

	if (childatts.visual != parentatts.visual) { /* XXX have to compare */
		report("Visual is different to parent");
		FAIL;
	} else if (childatts.class != parentatts.class) {
		report("Class was different to parent");
		FAIL;
	} else if (childatts.depth != parentatts.depth) {
		report("Depth was different to parent");
		FAIL;
	} else
		CHECK;

	XDestroyWindow(Dsp, w);
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Window	w;
XWindowAttributes	atts;
XWindowAttributes	parentatts;
Status	s;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XCreateSimpleWindow-7.(A)");
	report_assertion("All window attributes, other than depth, class, visual,");
	report_assertion("background and border, have their default values.");

	report_strategy("Call XCreateSimpleWindow.");
	report_strategy("Get the window attributes");
	report_strategy("Verify that these are the default values");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	s = XGetWindowAttributes(Dsp, w, &atts);
	if (s == False) {
		delete("XGetWindowAttributes failed");
		return;
	} else
		CHECK;

	s = XGetWindowAttributes(Dsp, DefaultRootWindow(Dsp), &parentatts);
	if (s == False) {
		delete("XGetWindowAttributes failed");
		return;
	} else
		CHECK;

	/* background-pixmap - None */
	/* border-pixmap - CopyFromParent */

	if (atts.bit_gravity != ForgetGravity) {
		report("bit_gravity was %s, expecting ForgetGravity"
			, bitgravityname(atts.bit_gravity));
		FAIL;
	} else
		CHECK;

	if (atts.win_gravity != NorthWestGravity) {
		report("win_gravity was %s, expecting NorthWestGravity"
			, wingravityname(atts.win_gravity)
			);
		FAIL;
	} else
		CHECK;

	if (atts.backing_store != NotUseful) {
		report("backing_store was %s, expecting NotUseful"
			, backingstorename(atts.backing_store));
		FAIL;
	} else
		CHECK;

	if (atts.backing_planes != 0xffffffff) {
		report("backing_planes was 0x%x, expecting all ones", atts.backing_planes);
		FAIL;
	} else
		CHECK;

	if (atts.backing_pixel != 0) {
		report("backing_pixel was 0x%x, expecting 0", atts.backing_pixel);
		FAIL;
	} else
		CHECK;

	if (atts.save_under != False) {
		report("save_under was 0x%x, expecting False", atts.save_under);
		FAIL;
	} else
		CHECK;

	if (atts.your_event_mask != NoEventMask) {
		report("your_event_mask was %s, expecting NoEventMask"
			, eventmaskname(atts.your_event_mask));
		FAIL;
	} else
		CHECK;

	if (atts.do_not_propagate_mask != NoEventMask) {
		report("do_not_propagate_mask was %s, expecting NoEventMask"
			, eventmaskname(atts.do_not_propagate_mask));
		FAIL;
	} else
		CHECK;

	if (atts.override_redirect != False) {
		report("override_redirect was %d, expecting False"
			, atts.override_redirect);
		FAIL;
	} else
		CHECK;

	if (atts.colormap != parentatts.colormap) {
		report("colormap was 0x%x, expecting 0x%x"
			, atts.colormap, parentatts.colormap);
		FAIL;
	} else
		CHECK;

	/* Cursor -- None */

	XDestroyWindow(Dsp, w);
	CHECKPASS(12);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Window	w;
Cursor	pcur;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XCreateSimpleWindow-8.(B)");
	report_assertion("The cursor is taken from the parent window.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a parent window.");
	report_strategy("  Set the parents cursor to a non-default cursor.");
	report_strategy("  Verify that the parent's cursor was set correctly.");
	report_strategy("  Create a child window using XCreateSimpleWindow.");
	report_strategy("  Map the child window.");
	report_strategy("  Warp the pointer to the child window.");
	report_strategy("  Verify that the current cursor is that of the parent.");
	report_strategy("  Set the parents cursor to a different cursor.");
	report_strategy("  Verify that the parent's cursor was set correctly.");
	report_strategy("  Verify that the current cursor has changed to that of the parent.");

	tpstartup();
	setargs();
	/* If extended testing is required: */
	if(noext(0))
		return;

	pcur = makecur(display);

		/* Create a parent window. */
	parent = defwin(display);
	
		/* Set the parents cursor to a non-default cursor. */
	XDefineCursor(display, parent, pcur);

		/* Verify that the parent's cursor was set correctly. */
	if(curofwin(display, pcur, parent) == False) {
		delete("XDefineCursor() did not set the parent's window correctly.");
		return;
	} else
		CHECK;

		/* Create a child window using xname. */
	x = 10;
	y = 10;
	startcall(display);
	if (isdeleted())
		return;
	w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
		/* Map the child window. */
	XMapWindow(display, w);

		/* Warp the pointer to the child window. */
	warppointer(display, w, 0,0);

		/* Verify that the current cursor is that of the parent. */
	if(spriteiswin(display, parent) == False) {	
		report("The cursor used for the child window was not that of its parent.");
		FAIL;
	} else
		CHECK;

	pcur = makecur2(display);

		/* Set the parents cursor to a different cursor. */
	XDefineCursor(display, parent, pcur);

		/* Verify that the parent's cursor was set correctly. */
	if(curofwin(display, pcur, parent) == False) {
		delete("XDefineCursor() did not set the parent's window correctly.");
		return;
	} else
		CHECK;

		/* Verify that the current cursor has changed to that of the parent. */
	if(spriteiswin(display, parent) == False) {	
		report("The cursor used for the child window was not that of its parent.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XCreateSimpleWindow-9.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* Including from file error/EMat1.mc */
/* End of included file error/EMat1.mc */

/* Including from file error/EMat1.mc */
static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XCreateSimpleWindow-10.(A)");
	report_assertion("When a drawable argument is an InputOnly window then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Create an InputOnly window.");
	report_strategy("Call test function using InputOnly window as the drawable argument.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	seterrdef();


	A_DRAWABLE = (Drawable)iponlywin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EMat1.mc */

static void t011(){

Window w;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XCreateSimpleWindow-11.(A)");
	report_assertion("When width or height is zero, then a BadValue error occurs.");

	report_strategy("Create window with width of 0");
	report_strategy("Verify that BadValue error occurs");
	report_strategy("Create window with height of 0");
	report_strategy("Verify that BadValue error occurs");
	report_strategy("Create window with height of 0 and width of 0");
	report_strategy("Verify that BadValue error occurs");

	tpstartup();
	setargs();
	/* First check for width 0 */
	width = 0;
	height = 10;

	startcall(display);
	if (isdeleted())
		return;
	w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadValue) {
		CHECK;
	} else {
		report("Width 0 did not give BadValue.");
		FAIL;
	}

	/* Now check for height 0 */
	width = 10;
	height = 0;

	startcall(display);
	if (isdeleted())
		return;
	w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue) {
		CHECK;
	} else {
		report("Height 0 did not give BadValue.");
		FAIL;
	}

	/* Now check for height 0 && width 0 */
	width = 0;
	height = 0;

	startcall(display);
	if (isdeleted())
		return;
	w = XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue) {
		CHECK;
	} else {
		report("Height 0 and width 0 did not give BadValue.");
		FAIL;
	}

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XCreateSimpleWindow-12.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
