/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XFreeColormap(display, colormap)
 *   Display *display;
 *   Colormap colormap;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XFreeColormap	1
char    *TestName = "XFreeColormap";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XFreeColormap function
 */
static Display *display;
static Colormap colormap;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(display, DefaultScreen(display));
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo *vi;
unsigned long vmask;
XColor col;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XFreeColormap-1.(A)");
	report_assertion("A call to XFreeColormap removes the association between the");
	report_assertion("colormap argument and the colourmap ID, and frees the");
	report_assertion("associated storage.");

	report_strategy("For each supported visual type:");
	report_strategy("  Create a colourmap with XCreateColormap.");
	report_strategy("  Free the colourmap with XFreeColormap.");
	report_strategy("  Verify that XAllocColor fails.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals are supported.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vi); ) {
		trace("Attempting XFreeColormap() for class %s", displayclassname(vi->class));
		colormap = XCreateColormap(display, DRW(display), vi->visual, AllocNone);

		startcall(display);
		if (isdeleted())
			return;
		XFreeColormap(display, colormap);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		startcall(display);
		XAllocColor(display, colormap, &col);
		endcall(display);

		if( geterr() == Success) {
			report("XAllocColor() succeeded with a freed colormap");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XColor col;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XFreeColormap-2.(A)");
	report_assertion("When the colormap argument is the default colourmap, then a");
	report_assertion("call to XFreeColormap does not remove the association");
	report_assertion("between the colormap argument and the colourmap ID or free");
	report_assertion("the associated storage.");

	report_strategy("Free the default colourmap with XFreeColormap.");
	report_strategy("Verify that XAllocColor succeeds in allocating 1 shared cell with this colormap.");

	tpstartup();
	setargs();
	col.red = col.green = col.blue = 0;
	colormap = DefaultColormap(display, DefaultScreen(display));
	startcall(display);
	if (isdeleted())
		return;
	XFreeColormap(display, colormap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(XAllocColor(display, colormap, &col) == False) {
		report("XAllocColor() failed to allocate a colourcell with the default colormap.");
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int i, len, notfound;
XVisualInfo *vi;
Colormap *maplist;
unsigned long vmask;
XColor col;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XFreeColormap-3.(A)");
	report_assertion("When the colormap argument is an installed colourmap, then");
	report_assertion("a call to XFreeColormap uninstalls the colourmap.");

	report_strategy("For each visual class:");
	report_strategy("  Create a colourmap with XCreateColormap.");
	report_strategy("  Install the colourmap with XInstallColormap.");
	report_strategy("  Obtain a list of installed colourmaps with XListInstalledColormaps.");
	report_strategy("  Verify that the created colourmap is in the list.");
	report_strategy("  Free the colourmap with XFreeColormap.");
	report_strategy("  Obtain a list of installed colourmaps with XListInstalledColormaps.");
	report_strategy("  Verify that the created colourmap is not in the list.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals are supported.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vi); ) {
		trace("Attempting XFreeColormap() for class %s", displayclassname(vi->class));
		colormap = XCreateColormap(display, DRW(display), vi->visual, AllocNone);


		XAllocColor(display, colormap, &col);
		XInstallColormap(display, colormap);
		maplist = XListInstalledColormaps(display, DRW(display), &len);
		for(i=0, notfound = 1; i<len  && notfound; i++ )
			if(maplist[i] == colormap) {
				CHECK;
				trace("Found map at position %d of the required list", i);
				notfound = 0;
			}

		XFree((char*)maplist);
		if(notfound) {
			delete("The installed colourmap was not on the required list.");
			return;
		}

		startcall(display);
		if (isdeleted())
			return;
		XFreeColormap(display, colormap);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		maplist = XListInstalledColormaps(display, DRW(display), &len);

		for(i=0, notfound = 1 ; i<len && notfound; i++)
			if(maplist[i] == colormap) {
				report("Colormap is still on the required list.");
				FAIL;
				notfound = 0;
			}

		XFree((char*)maplist);

		if(notfound == 1)
			CHECK;
	}

	CHECKPASS(2*nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo *vi;
XWindowAttributes watts;
XEvent ev;
unsigned long vmask;
XColor col;
Window win;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XFreeColormap-4.(A)");
	report_assertion("When the specified colourmap is defined as the colourmap");
	report_assertion("for a window, then a call to XFreeColormap changes the");
	report_assertion("colourmap associated with the window to None and generates a");
	report_assertion("ColormapNotify event.");

	report_strategy("For each supported visual class:");
	report_strategy("  Create a colourmap with XCreateColormap.");
	report_strategy("  Create a window with XCreateWindow.");
	report_strategy("  Select ColormapNotify events with XSelectInput.");
	report_strategy("  Make the colormap the colormap for the window with XSetWindowColormap.");
	report_strategy("  Free the colormap with XFreeColormap");
	report_strategy("  Verify that a ColorMapnotify event was generated with XNextEvent.");
	report_strategy("  Verify that the window's colourmap is set to none with XGetWindowAttributes.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals are supported.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vi); ) {
		trace("Attempting XFreeColormap() for class %s", displayclassname(vi->class));
		colormap = XCreateColormap(display, DRW(display), vi->visual, AllocNone);
		XAllocColor(display, colormap, &col);

		win = makewin(display, vi);
		XSetWindowColormap(display, win, colormap);
		XGetWindowAttributes(display, win, &watts);

		XSelectInput(display, win, ColormapChangeMask);

		
		if(watts.colormap != colormap) {
			delete("XSetWindowColormap() did not set the window colormap.");
			return;
		}

		XInstallColormap(display, colormap);

		startcall(display);
		if (isdeleted())
			return;
		XFreeColormap(display, colormap);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XGetWindowAttributes(display, win, &watts);
		if(watts.colormap != None) {
			report("Colormap of window was not set to None.");
			FAIL;
		}

		if(getevent(display, &ev) == 0) {
			report("No Event was generated");
			FAIL;
		} else
			if(ev.type != ColormapNotify) {
				report("Event generated was not ColormapNotify");
				FAIL;
			} else
				CHECK;

	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XFreeColormap-5.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	XFreeColormap(display, colormap);
	endcall(display);
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
