/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XStoreNamedColor(display, colormap, color, pixel, flags)
 *   Display *display;
 *   Colormap colormap;
 *   char *color;
 *   unsigned long pixel;
 *   int flags;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XStoreNamedColor	1
char    *TestName = "XStoreNamedColor";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XStoreNamedColor function
 */
static Display *display;
static Colormap colormap;
static char *color;
static unsigned long pixel;
static int flags;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(display, DefaultScreen(display));
	color = "";
	pixel = 0;
	flags = DoRed|DoGreen|DoBlue;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo *vp;
char *goodname;
XColor namedcol, testcol, storedcol;
unsigned long vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XStoreNamedColor-1.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: A call to XStoreNamedColor obtains");
	report_assertion("the closest available RGB values for the colormap argument");
	report_assertion("to those specified for the colour named color in the");
	report_assertion("database, and stores those values in the read-write");
	report_assertion("colourmap entry specified by the pixel component of the");
	report_assertion("XColor structure.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with alloc set to AllocAll.");
	report_strategy("  Store the r,g and b colour values of XT_GOOD_COLOUR_NAME in the colourmap with XStoreNamedColor.");
	report_strategy("  Obtain the rbg values of the stored color with XQueryColor.");
	report_strategy("  Store those rgb values in the colormap with XStoreColor.");
	report_strategy("  Obtain the stored rgb values with XQueryColor.");
	report_strategy("  Verify the rgb values stored in the two cells are identical.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	if((goodname = tet_getvar("XT_GOOD_COLORNAME")) == (char *) 0) {
		delete("XT_GOOD_COLORNAME is not defined.");
		return;
	}

	flags = DoRed|DoGreen|DoBlue;
	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting XStoreNamedColor() for class %s, color %s", displayclassname(vp->class), goodname);
		colormap = makecolmap(display, vp -> visual, AllocAll);
		color = goodname;
		pixel = 0L;

		startcall(display);
		if (isdeleted())
			return;
		XStoreNamedColor(display, colormap, color, pixel, flags);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		namedcol.pixel = 0L;
		XQueryColor(display, colormap, &namedcol);
		testcol = namedcol;
		testcol.pixel = 1L;
		testcol.flags = flags;
		XStoreColor(display, colormap, &testcol);
		storedcol.pixel = 1L;
		storedcol.flags = flags;
		XQueryColor(display, colormap, &storedcol);

		trace("Named Color : pixel %lu, r %u g %u b %u", namedcol.pixel , namedcol.red, namedcol.green, namedcol.blue);
		trace("Stored Color: pixel %lu, r %u g %u b %u", storedcol.pixel, storedcol.red, storedcol.green, storedcol.blue);


		if( (namedcol.red != storedcol.red) || (namedcol.green != storedcol.green) || (namedcol.blue != storedcol.blue) ) {
			report("XStoreNamedColor() return RGB values r %u g %u b %u instead of r %u g %u b %u.", 
				namedcol.red, namedcol.green, namedcol.blue, storedcol.red, storedcol.green, storedcol.blue);
				FAIL;
		} else
			CHECK;
	}

	CHECKPASS(nsupvis());


	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
int 		i;
char 		*goodname;
XColor		namedcol, testcol, storedcol;
unsigned long 	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
unsigned short	redval, greenval, blueval;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XStoreNamedColor-2.(A)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: A call to XStoreNamedColor changes");
	report_assertion("the red, green and blue values in the read-write colourmap");
	report_assertion("entry in accordance with the flags argument.");

	report_strategy("For each supported visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Store XT_GOOD_COLOR_NAME r, g and b values in cell 0 with XStoreNamedColor.");
	report_strategy("  Obtain the r,g and b values with XQueryColor.");
	report_strategy("  Complement the rgb values and store the value in cell 0 with XStoreColor.");
	report_strategy("  Obtain the bitwise complemented rgb values using XQueryColor.");
	report_strategy("  For each possible combination DoRed, DoGreen and DoBlue in flags:");
	report_strategy("    Store the bitwise complementary rgb values in the same cell with XStoreColor.");
	report_strategy("    Store the XT_GOOD_COLOR_NAME values in the colourmap cell using XStoreNamedColor.");
	report_strategy("    Verify that only the components of the colourcell specified by the flags value have been altered with XQueryColor.");

	tpstartup();
	setargs();

	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	if((goodname = tet_getvar("XT_GOOD_COLORNAME")) == (char *) 0) {
		delete("XT_GOOD_COLORNAME is not defined.");
		return;
	}

	color = goodname;
	pixel = 0L;
	storedcol.pixel = 0L;
	testcol.pixel = 0L;
	namedcol.pixel = 0L;

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting XStoreNamedColor() for class %s, color %s", displayclassname(vp->class), goodname);
		colormap = makecolmap(display, vp -> visual, AllocAll);
		flags = DoRed|DoGreen|DoBlue;
		startcall(display);
		if (isdeleted())
			return;
		XStoreNamedColor(display, colormap, color, pixel, flags);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XQueryColor(display, colormap, &namedcol);

		testcol = namedcol;
		testcol.red ^= 0xffff;
		testcol.green ^= 0xffff;
		testcol.blue ^= 0xffff;
		testcol.flags = DoRed | DoGreen | DoBlue;

		XStoreColor(display, colormap, &testcol);
		XQueryColor(display, colormap, &testcol);

		for(i=0; i<8; i++) {

			flags = 0;

			if(i&DoRed) {
				flags |= DoRed;
				redval = namedcol.red;
			} else
				redval = testcol.red;

			if(i&DoGreen) {
				flags |= DoGreen;
				greenval = namedcol.green;
			} else
				greenval = testcol.green;

			if(i&DoBlue) {
				flags |= DoBlue;
				blueval = namedcol.blue;
			} else
				blueval = testcol.blue;

			XStoreColor(display, colormap, &testcol);
			startcall(display);
			if (isdeleted())
				return;
			XStoreNamedColor(display, colormap, color, pixel, flags);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			XQueryColor(display, colormap, &storedcol);

			if( (redval != storedcol.red) || (greenval != storedcol.green) || (blueval != storedcol.blue) ){
				report("XStoreNamedColor() RGB value r %u g %u b %u instead of r %u g %u b %u.", 
					storedcol.red, storedcol.green, storedcol.blue, redval, greenval, blueval);
				FAIL;
				}
		}

		if(i == 8)
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo *vp;
char *cp, *goodname, *casename;
XColor casecol, testcol;
unsigned long vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int		i;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XStoreNamedColor-3.(A)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: Upper and lower case characters in");
	report_assertion("the color argument refer to the same color.");

	report_strategy("For each supported visual class:");
	report_strategy("  Create a colomap with alloc set to AllocAll.");
	report_strategy("  Store colour XT_GOOD_COLOR_NAME in the colourmap with XStoreNamedColor.");
	report_strategy("  Obtain the stored rgb values with XQueryColor,");
	report_strategy("  Store colour XT_GOOD_COLOR_NAME  with alternating characters in alternating case with XStoreNamedColor.");
	report_strategy("  Verify that the rgb values written by both calls was identical.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	if( (goodname = tet_getvar("XT_GOOD_COLORNAME")) == (char *) 0) {
		delete("XT_GOOD_COLORNAME is not defined.");
		return;
	}


	casename = (char *) malloc( strlen(goodname) + 1);
	strcpy(casename, goodname);

	for(i=0, cp=casename; *cp; i++, cp++)
		if(i&1)
			*cp = tolower(*cp);
		else
			*cp = toupper(*cp);


	testcol.pixel = 0L;
	casecol.pixel = 0L;
	pixel = 0L;
	flags = DoRed|DoGreen|DoBlue;

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp -> visual, AllocAll);
		color = goodname;

		startcall(display);
		if (isdeleted())
			return;
		XStoreNamedColor(display, colormap, color, pixel, flags);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
			
		XQueryColor(display, colormap, &testcol);

	
		color = casename;
		trace("Testing colourname %s", color);
		
		startcall(display);
		if (isdeleted())
			return;
		XStoreNamedColor(display, colormap, color, pixel, flags);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		
		XQueryColor(display, colormap, &casecol);

		if((casecol.pixel != testcol.pixel) || (casecol.red != testcol.red) || (casecol.green != testcol.green) || (casecol.blue != testcol.blue)) {
			report("Colour name %s pixel %lu ( r %u g %u b %u) instead of pixel %lu ( r %u g %u b %u)",
				goodname, casecol.pixel, casecol.red, casecol.green, casecol.blue,
					  testcol.pixel, testcol.red, testcol.green, testcol.blue);
			FAIL;
		} else
			CHECK;

	}
	CHECKPASS(nsupvis());


	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo *vp;
char *goodname;
unsigned long vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XStoreNamedColor-4.(A)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: When the pixel argument is not a");
	report_assertion("valid entry in the colormap argument, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colourmap with alloc set to AllocAll.");
	report_strategy("  Store the colour XT_GOOD_COLOR_NAME at pixel = colourmap_size with XStoreNamedColor.");
	report_strategy("  Verify that a BadValue error is generated.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	if((goodname = tet_getvar("XT_GOOD_COLORNAME")) == (char *) 0) {
		delete("XT_GOOD_COLORNAME is not defined.");
		return;
	}

	flags = DoRed|DoGreen|DoBlue;
	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting XStoreNamedColor() for class %s, color %s", displayclassname(vp->class), goodname);
		colormap = makecolmap(display, vp -> visual, AllocAll);
		color = goodname;
		pixel = maxsize(vp) + 1;
		if (vp->class == DirectColor) {
			pixel = (vp->red_mask | vp->green_mask | vp->blue_mask);
			pixel |= pixel << 1;
		}
		trace("Pixel set to %ld", pixel);
		startcall(display);
		if (isdeleted())
			return;
		XStoreNamedColor(display, colormap, color, pixel, flags);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadValue)
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAcc3.mc */
/* End of included file error/EAcc3.mc */

static void t005(){

XVisualInfo	*vp;
XColor		testcol;
char 		*goodname;
Display		*disp2;
unsigned long vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XStoreNamedColor-5.(A)");
	report_assertion("When an attempt to store into a read-only or an unallocated");
	report_assertion("colormap entry is made, then a BadAccess error occurs.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap (r/o) with alloc set to AllocNone.");
	report_strategy("  Store the color XT_GOOD_COLORNAME with XStoreNamedColor");
	report_strategy("  Verify that a BadAccess error is generated.");
	report_strategy("  Create a new client with XOpenDisplay.");
	report_strategy("  Allocate a full red readonly cell for the new client with XAllocColor.");
	report_strategy("  Store the color XT_GOOD_COLORNAME with XStoreNamedColor.");
	report_strategy("  Verify that a BadAccess error occurred.");
	report_strategy("  Allocate another readonly cell with XAllocColor.");
	report_strategy("  Store the color XT_GOOD_COLORNAME with XStoreNamedColor.");
	report_strategy("  Verify that a BadAccess error occurred.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	if((goodname = tet_getvar("XT_GOOD_COLORNAME")) == (char *) 0) {
		delete("XT_GOOD_COLORNAME is not defined.");
		return;
	}

	color = goodname;
	for(resetsupvis(vmask); nextsupvis(&vp); ) {		

		pixel = 0L;
		colormap = makecolmap(display, vp->visual, AllocNone);
		trace("Testing a colormap with no allocated cells.");
		startcall(display);
		if (isdeleted())
			return;
		XStoreNamedColor(display, colormap, color, pixel, flags);
		endcall(display);
		if (geterr() != BadAccess) {
			report("Got %s, Expecting BadAccess", errorname(geterr()));
			FAIL;
		}

		if(geterr() == BadAccess)
			CHECK;

		disp2 = opendisplay();

		testcol.flags = DoRed;
		testcol.red = 65535;
		if(XAllocColor(disp2, colormap, &testcol) == False) {
			delete("XAllocColor() failed to allocate a full red r/o cell for a second client.");
			return;
		} else
			CHECK;

		trace("Trying to write into a r/o cell allocated by another client.");
		pixel = testcol.pixel;
		startcall(display);
		if (isdeleted())
			return;
		XStoreNamedColor(display, colormap, color, pixel, flags);
		endcall(display);
		if (geterr() != BadAccess) {
			report("Got %s, Expecting BadAccess", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadAccess)
			CHECK;

		testcol.red ^= 0xffff;
		testcol.green ^= 0xffff;
		testcol.blue ^= 0xffff;
		testcol.flags = flags;

		if(XAllocColor(display, colormap, &testcol) == False) {
			delete("XAllocColor() failed to allocate a r/o cell with r,g,b = 0x%x,0x%x,0x%x", testcol.red, testcol.green, testcol.blue);
			return;
		} else
			CHECK;

		trace("Trying to write into a r/o cell allocated by self.");
		pixel = testcol.pixel;
		startcall(display);
		if (isdeleted())
			return;
		XStoreNamedColor(display, colormap, color, pixel, flags);
		endcall(display);
		if (geterr() != BadAccess) {
			report("Got %s, Expecting BadAccess", errorname(geterr()));
			FAIL;
		}

		if(geterr() == BadAccess)
			CHECK;
	}

	CHECKPASS(5*nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XStoreNamedColor-6.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	XStoreNamedColor(display, colormap, color, pixel, flags);
	endcall(display);
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

/* Including from file error/ENam2.mc */
/* End of included file error/ENam2.mc */

static void t007(){

XVisualInfo *vp;
char *badname;
unsigned long vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XStoreNamedColor-7.(A)");
	report_assertion("When the specified colour does not exist, then a BadName");
	report_assertion("error occurs.");

	report_strategy("For the visual classes DirectColor, PseudoColor and GrayScale :");
	report_strategy("  Create a colormap with alloc set to AllocAll.");
	report_strategy("  Allocate a cell with colour XT_BAD_COLORNAME ");
	report_strategy("    in the colourmap with XStoreNamedColor.");
	report_strategy("  Verify that a BadName error occurred.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		unsupported("DirectColor, PseudoColor visual classes are not supported.");
		return;
	}

	if( (badname = tet_getvar("XT_BAD_COLORNAME")) == (char *) 0) {
		delete("XT_BAD_COLORNAME is not defined.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		colormap = makecolmap(display, vp -> visual, AllocAll);
		color = badname;		
		startcall(display);
		if (isdeleted())
			return;
		XStoreNamedColor(display, colormap, color, pixel, flags);		
		endcall(display);
		if (geterr() != BadName) {
			report("Got %s, Expecting BadName", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadName)
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.7848 */
static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XStoreNamedColor-8.(D)");
	report_assertion("When rmask_return, gmask_return and bmask_return have been");
	report_assertion("returned by a previous call to XAllocColorPlanes and a");
	report_assertion("read-write colourmap entry for a pixel value is changed by a");
	report_assertion("call to XStoreNamedColor, then the pixel value is");
	report_assertion("decomposed into three components using the masks and the");
	report_assertion("independent colourmap entries are updated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.7848 */

/* Including from file Mdefcode.tmc.7848 */
static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XStoreNamedColor-9.(D)");
	report_assertion("If the visual class DirectColor is supported: When the");
	report_assertion("colormap argument was created with visual type DirectColor");
	report_assertion("and with alloc set to AllocAll, and a read-write colourmap");
	report_assertion("entry for a pixel value is changed by a call to");
	report_assertion("XStoreNamedColor, then the pixel value is decomposed into");
	report_assertion("three components using the red_mask, green_mask and");
	report_assertion("blue_mask in the visual and the independent colourmap");
	report_assertion("entries are updated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.7848 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
