/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAppReleaseCacheRefs()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

XrmValue from;
XrmValue to_in_out;

unsigned char tochar;

char buf[32];

void init_args()
{
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr)+1;
	to_in_out.addr = (XtPointer)&tochar;
	to_in_out.size = sizeof(unsigned char);
}

#ifndef XavsRChar
#define XavsRChar "Char"
#endif
Boolean XtCVT_Proc(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	/*
	** Conveter to convert String to Char
	*/
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	avs_set_event(1,avs_get_event(1)+1);
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
	return True;
}
void XtDES_Proc(app_ctext, to_val, converter_data, args, num_args )
XtAppContext	app_ctext;
XrmValue *to_val;
XtPointer converter_data;
XrmValue *args;
Cardinal *num_args;
{
	avs_set_event(2,avs_get_event(2)+1);
}


#define T_XtAppReleaseCacheRefs	1
char    *TestName = "XtAppReleaseCacheRefs";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XtCacheRef cache_ref_return1[2], cache_ref_return2[2];
int status1, status2;
Boolean flag;
Display *display_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppReleaseCacheRefs-1.(A)");
	report_assertion("A successful call to void");
	report_assertion("XtAppReleaseCacheRefs(app_context, refs) shall decrement the");
	report_assertion("reference count for each conversion entry in the list");
	report_assertion("specified by refs.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Taprelcre1", "XtSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter and destructor");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll|XtCacheRefCount,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke resource converter twice");
	display_good = XtDisplay(topLevel);
	init_args();
	flag = XtCallConverter(display_good,
		XtCVT_Proc,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&(cache_ref_return1[0])
		);
	check_dec(True, flag, "return value");
	flag = XtCallConverter(display_good,
		XtCVT_Proc,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&(cache_ref_return2[0])
		);
	cache_ref_return1[1] = 0;
	cache_ref_return2[1] = 0;
	check_dec(True, flag, "return value");
	tet_infoline("TEST: Resource converter was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "Resource converter invoked count");
	tet_infoline("TEST: Release the cached resource value");
	XtAppReleaseCacheRefs(app_ctext, cache_ref_return1);
	tet_infoline("TEST: Resource destructor was not invoked");
	status2 = avs_get_event(2);
	check_dec(0, status2, "Resource destructor invoked count");
	tet_infoline("TEST: Release the cached resource value again");
	XtAppReleaseCacheRefs(app_ctext, cache_ref_return2);
	tet_infoline("TEST: Resource destructor was invoked");
	status2 = avs_get_event(2);
	check_dec(1, status2, "Resource destructor invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11616 */
/* End of included file Mdefcode.tmc.11616 */

static void t002(){

XtCacheRef cache_ref_return1[2], cache_ref_return2[2];
int status1, status2;
Boolean flag;
Display *display_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppReleaseCacheRefs-2.(A)");
	report_assertion("A successful call to void");
	report_assertion("XtAppReleaseCacheRefs(app_context, refs) shall call the");
	report_assertion("destructor procedure and remove the resource from the");
	report_assertion("conversion cache for any conversion entry in refs that");
	report_assertion("reaches a conversion count of zero.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Taprelcre1", "XtSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter and destructor");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll|XtCacheRefCount,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke resource converter twice");
	display_good = XtDisplay(topLevel);
	init_args();
	flag = XtCallConverter(display_good,
		XtCVT_Proc,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&(cache_ref_return1[0])
		);
	check_dec(True, flag, "return value");
	flag = XtCallConverter(display_good,
		XtCVT_Proc,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&(cache_ref_return2[0])
		);
	cache_ref_return1[1] = 0;
	cache_ref_return2[1] = 0;
	check_dec(True, flag, "return value");
	tet_infoline("TEST: Resource converter was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "Resource converter invoked count");
	tet_infoline("TEST: Release the cached resource value");
	XtAppReleaseCacheRefs(app_ctext, cache_ref_return1);
	tet_infoline("TEST: Release the cached resource value again");
	XtAppReleaseCacheRefs(app_ctext, cache_ref_return2);
	tet_infoline("TEST: Resource destructor was invoked");
	status2 = avs_get_event(2);
	check_dec(1, status2, "Resource destructor invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11616 */
/* End of included file Mdefcode.tmc.11616 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
