/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   ArgList
 *   XtMergeArgLists()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtMergeArgLists	1
char    *TestName = "XtMergeArgLists";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Arg list_one[1], list_two[1] ;
ArgList ArgPtr;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtMergeArgLists-1.(A)");
	report_assertion("A call to ArgList XtMergeArgLists(args1, num_args1, args2,");
	report_assertion("num_args2) shall combine args1 and args2, store them in a");
	report_assertion("newly allocated ArgList, and return a pointer the new");
	report_assertion("ArgList.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tmrgarglst1", "XtMergeArgLists");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Allocate memory for list");
	ArgPtr = (Arg *) malloc(sizeof(Arg));
	tet_infoline("PREP: Construct two argument lists to be merged");
	list_one[0].name = "Hello";
	list_one[0].value = (XtArgVal) 100;
	list_two[0].name = "World";
	list_two[0].value = (XtArgVal) 100;
	tet_infoline("PREP: Call XtMergeArgList");
	ArgPtr = XtMergeArgLists(&list_one[0], 1, &list_two[0], 1);
	tet_infoline("TEST: Two lists were merged");
	check_str("Hello", ArgPtr[0].name, "ArgPtr[0].name");
	check_dec(100, ArgPtr[0].value, "ArgPtr[0].value");
	check_str("World", ArgPtr[1].name, "ArgPtr[1].name");
	check_dec(100, ArgPtr[1].value, "ArgPtr[1].value");
	XtFree((char *)ArgPtr);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.10930 */
/* End of included file Mdefcode.tmc.10930 */

static void t002(){

Arg	list_one[1], list_two[1] ;
ArgList	ArgPtr;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtMergeArgLists-2.(A)");
	report_assertion("A call to ArgList XtMergeArgLists(args1, num_args1, args2,");
	report_assertion("num_args2) shall not check for duplicate entries in args1");
	report_assertion("and args2.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tmrgarglst2", "XtMergeArgLists");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Allocate memory for list");
	ArgPtr = (Arg *) malloc(sizeof(Arg));
	tet_infoline("PREP: Construct two overlapping argument lists to be merged");
	list_one[0].name = "Hello";
	list_one[0].value = (XtArgVal) 100;
	list_two[0].name = "Hello";
	list_two[0].value = (XtArgVal) 100;
	tet_infoline("PREP: Call XtMergeArgList");
	ArgPtr = XtMergeArgLists(&list_one[0], 1, &list_two[0], 1);
	tet_infoline("TEST: Duplicates retained when two lists were merged");
	check_str("Hello", ArgPtr[0].name, "ArgPtr[0].name");
	check_dec(100, ArgPtr[0].value, "ArgPtr[0].value");
	check_str("Hello", ArgPtr[1].name, "ArgPtr[1].name");
	check_dec(100, ArgPtr[1].value, "ArgPtr[1].value");
	XtFree((char *)ArgPtr);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.10930 */
/* End of included file Mdefcode.tmc.10930 */

/* Including from file Mdefcode.tmc.10930 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtMergeArgLists-3.(B)");
	report_assertion("On a call to ArgList XtMergeArgLists(args1, num_args1,");
	report_assertion("args2, num_args2) the length of the new list shall be the");
	report_assertion("sum of args1 and args2.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10930 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
