/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XtGrabKeyboard()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#ifdef XTESTEXTENSION
#include <X11/extensions/XTest.h>
#endif

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

Widget panedw, boxw1, boxw2;
Widget click_pass, click_fail;
char label[80];
XKeyboardControl kbvalues;
Widget topLevel;
Widget labelw;
int eflag = 3;

#ifdef XTESTEXTENSION
void hack()
{
		eflag = 2;
		kbvalues.auto_repeat_mode = AutoRepeatModeOn;
		XChangeKeyboardControl(XtDisplay(topLevel), KBAutoRepeatMode, &kbvalues);
		/*this hack seems to be necessary to get the kbd control to take*/
		send_event(topLevel, FocusIn, FocusChangeMask, TRUE);
		send_event(topLevel, FocusOut, FocusChangeMask, TRUE);
}

/*
** procedure XtTMO_Proc
*/
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
XEvent event;
	/*fake user input to get autorepeat back*/
	event.xkey.type = KeyRelease;
	event.xkey.display = XtDisplay(labelw);
	event.xkey.window = XtWindow(labelw);
	event.xkey.x = -1;
	XSelectInput( XtDisplay(topLevel), XtWindow(labelw), KeyReleaseMask);
	XSendEvent(XtDisplay(labelw), XtWindow(labelw), False, KeyReleaseMask, &event);
	tet_infoline("ERROR: Timed out waiting for user input");
	tet_result(TET_UNRESOLVED);
}

static void analyse_events(TestWidget)
Widget TestWidget;
{
	XtAppContext app_context;
	Display *display;
	XEvent event;
	int didthis = 0;
	Window window;
	int ret_value;
	Position rootx, rooty;

	app_context = XtWidgetToApplicationContext(TestWidget);
	display = XtDisplay(TestWidget);
	window = XtWindow(TestWidget);
	for (;;) {
	 XtAppNextEvent(app_context, &event);
	if (eflag < 3)
		eflag--;
	 XSync(display, False);
	 if (event.type == KeyPress) {
		if (event.xkey.window != window) {
			sprintf(ebuf, "ERROR: KeyPress event in wrong window. Wanted 0x%08lx, got 0x%08lx", window, event.xkey.window);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			hack();
		}
	}
	if (event.type == KeyRelease) {
		if (event.xkey.window != window) {
		 sprintf(ebuf, "ERROR: KeyRelease event in wrong window. Wanted 0x%08lx, got 0x%08lx", window, event.xkey.window);
		 tet_infoline(ebuf);
		 tet_result(TET_FAIL);
			hack();
		}
		else {
			tet_result(TET_PASS);
			hack();
		}
	}
	 if (event.type == Expose && event.xexpose.window == window) {
		if (didthis == 0) {
			didthis = 1;
			tet_infoline("PREP: Grab Keyboard");
				ret_value = XtGrabKeyboard(TestWidget, FALSE, GrabModeAsync, GrabModeAsync, CurrentTime);
				if (ret_value != Success) {
				sprintf(ebuf, "ERROR: XtGrabKeyboard Call Failed with result %d.", ret_value);
				tet_infoline(ebuf);
				tet_result(TET_FAIL);
				hack();
				}
			tet_infoline("PREP: Simulate user input");
			XtTranslateCoords(TestWidget, 0,0,&rootx, &rooty);
			XTestFakeMotionEvent(XtDisplay(TestWidget), -1, rootx-100, rooty, CurrentTime);
			XTestFakeKeyEvent(XtDisplay(TestWidget), XKeysymToKeycode(XtDisplay(TestWidget), 32), True, CurrentTime);
			XTestFakeKeyEvent(XtDisplay(TestWidget), XKeysymToKeycode(XtDisplay(TestWidget), 32), False, CurrentTime);
			tet_infoline("TEST: Analyze events");
		}
	} 
 XtDispatchEvent(&event);
	 if (eflag == 0) {
		exit(0);
	}
	} /* end for */
}
#endif


#define T_XtGrabKeyboard	1
char    *TestName = "XtGrabKeyboard";



static int 	ValueReturn;

int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int status;
char *msg = "This is the widget which will grab the keyboard";
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGrabKeyboard-1.(A)");
	report_assertion("When the widget widget is realized a successful call to int");
	report_assertion("XtGrabKeyboard(widget, owner_events, pointer_mode,");
	report_assertion("keyboard_mode, time) shall call XGrabKeyboard to make an");
	report_assertion("active grab of the keyboard for the specified widget.");
	FORK(pid);
	initconfig();

#ifdef XTESTEXTENSION
	FORK(pid2);
	xt_tomultiple=3;
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevel root widget");
	topLevel = (Widget) avs_xt_init("Tgrabkybd1", NULL, 0);
	tet_infoline("PREP: Set up the XtToolkitError handler");
	app_ctext = XtWidgetToApplicationContext(topLevel);
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("PREP: Disable autorepeat (which would break this test)");
	kbvalues.auto_repeat_mode = AutoRepeatModeOff;
	XChangeKeyboardControl(XtDisplay(topLevel), KBAutoRepeatMode, &kbvalues);
	tet_infoline("PREP: Set up widget tree of depth eight (8) return panedw widget");
	panedw = (Widget) avs_xt_tree(topLevel);
	tet_infoline("PREP: Create boxw1 widget in panedw widget");
	boxw1 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Get the label widget name");
	strcpy(label, (char *)title("XtGrabKeyboard") );
	sprintf(ebuf, "PREP: Create label: %s in boxw1 widget", label);
	tet_infoline(ebuf);
	labelw = (Widget) CreateLabelWidget(label, boxw1);
	tet_infoline("PREP: Create boxw2 widget in panedw widget");
	boxw2 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Set height and width of boxw2 widget");
	ConfigureDimension(topLevel, boxw2);
	labelw = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtAppAddTimeOut(app_ctext, (unsigned long)5000, XtTMO_Proc, topLevel);
	XtRealizeWidget(topLevel);
	analyse_events(labelw);
	LKROF(pid2, (AVSXTTIMEOUT-2)*xt_tomultiple);
#else
		tet_infoline("INFO: XTEST extension is not configured");
		tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11400 */
/* End of included file Mdefcode.tmc.11400 */

static void t002(){

int ret_value;
char *msg = "This is the widget which will grab the keyboard";
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGrabKeyboard-2.(A)");
	report_assertion("A call to int XtGrabKeyboard(widget, owner_events,");
	report_assertion("pointer_mode, keyboard_mode, time) when the widget widget is");
	report_assertion("not realized shall not activate the keyboard grab and shall");
	report_assertion("return GrabNotViewable.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	xt_tomultiple=3;
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevel root widget");
	topLevel = (Widget) avs_xt_init("Tgrabkybd1", NULL, 0);
	tet_infoline("PREP: Set up the XtToolkitError handler");
	app_ctext = XtWidgetToApplicationContext(topLevel);
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("PREP: Disable autorepeat (which would break this test)");
	kbvalues.auto_repeat_mode = AutoRepeatModeOff;
	XChangeKeyboardControl(XtDisplay(topLevel), KBAutoRepeatMode, &kbvalues);
	tet_infoline("PREP: Set up widget tree of depth eight (8) return panedw widget");
	panedw = (Widget) avs_xt_tree(topLevel);
	tet_infoline("PREP: Create boxw1 widget in panedw widget");
	boxw1 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Get the label widget name");
	strcpy(label, (char *)title("XtGrabKeyboard") );
	sprintf(ebuf, "PREP: Create label: %s in boxw1 widget", label);
	tet_infoline(ebuf);
	labelw = (Widget) CreateLabelWidget(label, boxw1);
	tet_infoline("PREP: Create boxw2 widget in panedw widget");
	boxw2 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Set height and width of boxw2 widget");
	ConfigureDimension(topLevel, boxw2);
	labelw = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("TEST: Grab the keyboard without realizing the widgets");
	ret_value = XtGrabKeyboard(labelw, FALSE, GrabModeAsync, GrabModeAsync, CurrentTime);
	tet_infoline("TEST: Return value");
	if (ret_value != GrabNotViewable) {
		sprintf(ebuf, "ERROR: XtGrabKeyboard returned %d, expected GrabNotViewable (%d)", ret_value, GrabNotViewable);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, (AVSXTTIMEOUT-2)*xt_tomultiple);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11400 */
/* End of included file Mdefcode.tmc.11400 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
