/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtWorkProcId
 *   XtAddWorkProc()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

char client_stuff[] = "Four score and seven years ago";

void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
        exit(0);
}

Boolean XtWKP1_Proc4(client_data)
XtPointer client_data;
{
	avs_set_event(3, avs_get_event(1));
	exit(0);
}
Boolean XtWKP1_Proc3(client_data)
XtPointer client_data;
{
	avs_set_event(1,avs_get_event(1)+1);
	if (avs_get_event(1) == 1) {
		tet_infoline("PREP: Add work procedure from inside original one");
		XtAddWorkProc(XtWKP1_Proc4, client_stuff);

		return(False);
	}
	if (avs_get_event(1) == 5)
		return(True);

	return(False);
}
Boolean XtWKP1_Proc(client_data)
XtPointer client_data;
{
	avs_set_event(1,avs_get_event(1)+1);
	if (strcmp(client_data, client_stuff) != 0) {
		sprintf(ebuf, "ERROR: Expected client_data = \"%s\", received \"%s\"", client_stuff, client_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (avs_get_event(1) == 5)
		exit(0);
	else
		return(False);
}
Boolean XtWKP1_Proc6(client_data)
XtPointer client_data;
{
	avs_set_event(1,avs_get_event(1)+1);
	tet_infoline("TEST: Client_data passed correctly to handler");
	if (strcmp(client_data, client_stuff) != 0) {
		sprintf(ebuf, "ERROR: Expected client_data = \"%s\", received \"%s\"", client_stuff, client_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}
Boolean XtWKP1_Proc2(client_data)
XtPointer client_data;
{
	avs_set_event(1,avs_get_event(1)+1);
	if (strcmp(client_data, client_stuff) != 0) {
		sprintf(ebuf, "ERROR: Expected client_data = \"%s\", received \"%s\"", client_stuff, client_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (avs_get_event(1) == 5)
		return(True);
	else
		return(False);
}
Boolean XtWKP2_Head(client_data)
XtPointer client_data;
{
	sprintf(ebuf, "ERROR: Unexpected invocation of XtWKP2_Head");
 	tet_infoline(ebuf);
	tet_result(TET_FAIL); 
	exit(0);
}
Boolean XtWKP2_Tail(client_data)
XtPointer client_data;
{
		avs_set_event(1,1);
		exit(0);
}


#define T_XtAddWorkProc	1
char    *TestName = "XtAddWorkProc";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
int status;
XEvent event;
Display *display;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAddWorkProc-1.(A)");
	report_assertion("A successful call to XtWorkProcId XtAddWorkProc(proc,");
	report_assertion("client_data) shall register proc as the work procedure that");
	report_assertion("will be called when the default application context for the");
	report_assertion("calling process waits for an event input, and return a");
	report_assertion("unique identifier for the work procedure.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tadwkproc1", "XtAddWorkProc");
	FORK(pid2);
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Add work procedure XtWKP1_Proc");
	XtAddWorkProc(XtWKP1_Proc, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Work procedure is invoked");
	for (i = 0; i == 0;) {
		/*flag when NextEvent could block*/
	 	if (XtPending() == 0)
		avs_set_event(2, 1);
	 	XtNextEvent(&event);
	 	XSync(display, False);
	 	XtDispatchEvent(&event);
	} /* end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		status = avs_get_event(1);
		check_dec(5, status, "XtWKP1_Proc invocations count");
		tet_infoline("TEST: XtNextEvent would have blocked");
		status = avs_get_event(2);
		check_dec(1, status, "XtNextEvent without events pending");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12310 */
/* End of included file Mdefcode.tmc.12310 */

static void t002(){

pid_t pid2;
int status;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAddWorkProc-2.(A)");
	report_assertion("When multiple procedures are registered by calls to");
	report_assertion("XtWorkProcId XtAddWorkProc(proc, client_data) the most");
	report_assertion("recently registered procedure shall be called.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tadwkproc2", "XtAddWorkProc");
	FORK(pid2);
	tet_infoline("PREP: Add work procedure XtWKP2_Head");
	XtAddWorkProc(XtWKP2_Head, (Widget)topLevel);
	tet_infoline("PREP: Add work procedure XtWKP2_Tail");
	XtAddWorkProc(XtWKP2_Tail, (Widget)topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Procedure XtWKP2_Tail was invoked");
	XtMainLoop();
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_result(TET_UNRESOLVED);
        }
	else {
		status = avs_get_event(1);
		check_dec(1, status, "XtWKP2_Tail invocations count");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12310 */
/* End of included file Mdefcode.tmc.12310 */

static void t003(){

pid_t pid2;
int status;
XEvent event;
Display *display;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAddWorkProc-3.(A)");
	report_assertion("When a work procedure registered by a call to XtWorkProcId");
	report_assertion("XtAddWorkProc(proc, client_data) returns True it shall be");
	report_assertion("unregistered and not called when the default application");
	report_assertion("context next waits for event input.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tadwkproc1", "XtAddWorkProc");
	FORK(pid2);
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Add work procedure XtWKP1_Proc");
	XtAddWorkProc(XtWKP1_Proc2, client_stuff);
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Work procedure is invoked until returns True");
	for (i = 0; i == 0;) {
		/*flag when NextEvent could block*/
	 	if (XtPending() == 0)
			avs_set_event(2, 1);
	 	XtNextEvent(&event);
	 	XSync(display, False);
	 	XtDispatchEvent(&event);
	} /* end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		status = avs_get_event(1);
		check_dec(5, status, "XtWKP1_Proc invocations count");
		tet_infoline("TEST: XtNextEvent would have blocked");
		status = avs_get_event(2);
		check_dec(1, status, "XtNextEvent without events pending");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12310 */
/* End of included file Mdefcode.tmc.12310 */

static void t004(){

pid_t pid2;
int status;
XEvent event;
Display *display;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAddWorkProc-4.(A)");
	report_assertion("When a work procedure registered by a call to XtWorkProcId");
	report_assertion("XtAddWorkProc(proc, client_data) registers a work procedure");
	report_assertion("the newly added procedure shall have lower priority.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tadwkproc1", "XtAddWorkProc");
	FORK(pid2);
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Add work procedure");
	XtAddWorkProc(XtWKP1_Proc3, client_stuff);
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	for (i = 0; i == 0;) {
		/*flag when NextEvent could block*/
	 	if (XtPending() == 0)
			avs_set_event(2, 1);
	 	XtNextEvent(&event);
	 	XSync(display, False);
	 	XtDispatchEvent(&event);
	} /* end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Added work procedure not invoked until first unregistered");
		status = avs_get_event(1);
		check_dec(5, status, "Original work proc invocations count");
		status = avs_get_event(3);
		check_dec(5, status, "Original work proc invocations prior to invocation of second");
		tet_infoline("TEST: XtNextEvent would have blocked");
		status = avs_get_event(2);
		check_dec(1, status, "XtNextEvent without events pending");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12310 */
/* End of included file Mdefcode.tmc.12310 */

static void t005(){

pid_t pid2;
int status;
XEvent event;
Display *display;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAddWorkProc-5.(A)");
	report_assertion("A successful call to XtWorkProcId XtAddWorkProc(proc,");
	report_assertion("client_data) shall cause client_data to be passed to proc");
	report_assertion("when it is invoked.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tadwkproc1", "XtAddWorkProc");
	FORK(pid2);
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Add work procedure XtWKP1_Proc");
	XtAddWorkProc(XtWKP1_Proc6, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Work procedure is invoked");
	for (i = 0; i == 0;) {
		/*flag when NextEvent could block*/
	 	if (XtPending() == 0)
		avs_set_event(2, 1);
	 	XtNextEvent(&event);
	 	XSync(display, False);
	 	XtDispatchEvent(&event);
	} /* end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		status = avs_get_event(1);
		check_dec(1, status, "Work procedure invocations count");
		tet_infoline("TEST: XtNextEvent would have blocked");
		status = avs_get_event(2);
		check_dec(1, status, "XtNextEvent without events pending");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12310 */
/* End of included file Mdefcode.tmc.12310 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
