/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_FENCE_H
#define VN_PROTOCOL_DRIVER_FENCE_H

#include "vn_instance.h"
#include "vn_protocol_driver_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkGetFenceFdKHR
 */

/* struct VkExportFenceCreateInfo chain */

static inline size_t
vn_sizeof_VkExportFenceCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExportFenceCreateInfo_self(const VkExportFenceCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->handleTypes);
    return size;
}

static inline size_t
vn_sizeof_VkExportFenceCreateInfo(const VkExportFenceCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExportFenceCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkExportFenceCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkExportFenceCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExportFenceCreateInfo_self(struct vn_cs_encoder *enc, const VkExportFenceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->handleTypes);
}

static inline void
vn_encode_VkExportFenceCreateInfo(struct vn_cs_encoder *enc, const VkExportFenceCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO });
    vn_encode_VkExportFenceCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkExportFenceCreateInfo_self(enc, val);
}

/* struct VkFenceCreateInfo chain */

static inline size_t
vn_sizeof_VkFenceCreateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFenceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkExportFenceCreateInfo_self((const VkExportFenceCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFenceCreateInfo_self(const VkFenceCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    return size;
}

static inline size_t
vn_sizeof_VkFenceCreateInfo(const VkFenceCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFenceCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkFenceCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkFenceCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFenceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkExportFenceCreateInfo_self(enc, (const VkExportFenceCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFenceCreateInfo_self(struct vn_cs_encoder *enc, const VkFenceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
}

static inline void
vn_encode_VkFenceCreateInfo(struct vn_cs_encoder *enc, const VkFenceCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FENCE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FENCE_CREATE_INFO });
    vn_encode_VkFenceCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkFenceCreateInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkCreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateFence_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkFenceCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pFence);
    if (pFence)
        cmd_size += vn_sizeof_VkFence(pFence);

    return cmd_size;
}

static inline void vn_encode_vkCreateFence(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateFence_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkFenceCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pFence))
        vn_encode_VkFence(enc, pFence);
}

static inline size_t vn_sizeof_vkCreateFence_reply(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateFence_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pFence);
    if (pFence)
        cmd_size += vn_sizeof_VkFence(pFence);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateFence_reply(struct vn_cs_decoder *dec, VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateFence_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkFence(dec, pFence);
    } else {
        pFence = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyFence_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkFence(&fence);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyFence(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyFence_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkFence(enc, &fence);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyFence_reply(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyFence_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip fence */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyFence_reply(struct vn_cs_decoder *dec, VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyFence_EXT);

    /* skip device */
    /* skip fence */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetFences_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&fenceCount);
    if (pFences) {
        cmd_size += vn_sizeof_array_size(fenceCount);
        for (uint32_t i = 0; i < fenceCount; i++)
            cmd_size += vn_sizeof_VkFence(&pFences[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkResetFences(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t fenceCount, const VkFence* pFences)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetFences_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &fenceCount);
    if (pFences) {
        vn_encode_array_size(enc, fenceCount);
        for (uint32_t i = 0; i < fenceCount; i++)
            vn_encode_VkFence(enc, &pFences[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkResetFences_reply(VkDevice device, uint32_t fenceCount, const VkFence* pFences)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetFences_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip fenceCount */
    /* skip pFences */

    return cmd_size;
}

static inline VkResult vn_decode_vkResetFences_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t fenceCount, const VkFence* pFences)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkResetFences_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip fenceCount */
    /* skip pFences */

    return ret;
}

static inline size_t vn_sizeof_vkGetFenceStatus(VkDevice device, VkFence fence)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetFenceStatus_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkFence(&fence);

    return cmd_size;
}

static inline void vn_encode_vkGetFenceStatus(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkFence fence)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetFenceStatus_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkFence(enc, &fence);
}

static inline size_t vn_sizeof_vkGetFenceStatus_reply(VkDevice device, VkFence fence)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetFenceStatus_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip fence */

    return cmd_size;
}

static inline VkResult vn_decode_vkGetFenceStatus_reply(struct vn_cs_decoder *dec, VkDevice device, VkFence fence)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetFenceStatus_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip fence */

    return ret;
}

static inline size_t vn_sizeof_vkWaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWaitForFences_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&fenceCount);
    if (pFences) {
        cmd_size += vn_sizeof_array_size(fenceCount);
        for (uint32_t i = 0; i < fenceCount; i++)
            cmd_size += vn_sizeof_VkFence(&pFences[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_VkBool32(&waitAll);
    cmd_size += vn_sizeof_uint64_t(&timeout);

    return cmd_size;
}

static inline void vn_encode_vkWaitForFences(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWaitForFences_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &fenceCount);
    if (pFences) {
        vn_encode_array_size(enc, fenceCount);
        for (uint32_t i = 0; i < fenceCount; i++)
            vn_encode_VkFence(enc, &pFences[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkBool32(enc, &waitAll);
    vn_encode_uint64_t(enc, &timeout);
}

static inline size_t vn_sizeof_vkWaitForFences_reply(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWaitForFences_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip fenceCount */
    /* skip pFences */
    /* skip waitAll */
    /* skip timeout */

    return cmd_size;
}

static inline VkResult vn_decode_vkWaitForFences_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkWaitForFences_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip fenceCount */
    /* skip pFences */
    /* skip waitAll */
    /* skip timeout */

    return ret;
}

static inline void vn_submit_vkCreateFence(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateFence(device, pCreateInfo, pAllocator, pFence);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateFence_reply(device, pCreateInfo, pAllocator, pFence) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateFence(enc, cmd_flags, device, pCreateInfo, pAllocator, pFence);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDestroyFence(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyFence(device, fence, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyFence_reply(device, fence, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroyFence(enc, cmd_flags, device, fence, pAllocator);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkResetFences(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t fenceCount, const VkFence* pFences, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkResetFences(device, fenceCount, pFences);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkResetFences_reply(device, fenceCount, pFences) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkResetFences(enc, cmd_flags, device, fenceCount, pFences);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetFenceStatus(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkFence fence, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetFenceStatus(device, fence);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetFenceStatus_reply(device, fence) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetFenceStatus(enc, cmd_flags, device, fence);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkWaitForFences(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkWaitForFences(device, fenceCount, pFences, waitAll, timeout);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkWaitForFences_reply(device, fenceCount, pFences, waitAll, timeout) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkWaitForFences(enc, cmd_flags, device, fenceCount, pFences, waitAll, timeout);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkCreateFence(struct vn_instance *vn_instance, VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkCreateFence(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pFence, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateFence_reply(dec, device, pCreateInfo, pAllocator, pFence);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateFence(struct vn_instance *vn_instance, VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreateFence(vn_instance, 0, device, pCreateInfo, pAllocator, pFence, &submit);
}

static inline void vn_call_vkDestroyFence(struct vn_instance *vn_instance, VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyFence(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, fence, pAllocator, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkDestroyFence_reply(dec, device, fence, pAllocator);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkDestroyFence(struct vn_instance *vn_instance, VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyFence(vn_instance, 0, device, fence, pAllocator, &submit);
}

static inline VkResult vn_call_vkResetFences(struct vn_instance *vn_instance, VkDevice device, uint32_t fenceCount, const VkFence* pFences)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkResetFences(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, fenceCount, pFences, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkResetFences_reply(dec, device, fenceCount, pFences);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkResetFences(struct vn_instance *vn_instance, VkDevice device, uint32_t fenceCount, const VkFence* pFences)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkResetFences(vn_instance, 0, device, fenceCount, pFences, &submit);
}

static inline VkResult vn_call_vkGetFenceStatus(struct vn_instance *vn_instance, VkDevice device, VkFence fence)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetFenceStatus(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, fence, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkGetFenceStatus_reply(dec, device, fence);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetFenceStatus(struct vn_instance *vn_instance, VkDevice device, VkFence fence)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetFenceStatus(vn_instance, 0, device, fence, &submit);
}

static inline VkResult vn_call_vkWaitForFences(struct vn_instance *vn_instance, VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkWaitForFences(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, fenceCount, pFences, waitAll, timeout, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkWaitForFences_reply(dec, device, fenceCount, pFences, waitAll, timeout);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkWaitForFences(struct vn_instance *vn_instance, VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkWaitForFences(vn_instance, 0, device, fenceCount, pFences, waitAll, timeout, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_FENCE_H */
