/* DO NOT EDIT *************************************************
 * THIS FILE AUTOMATICALLY GENERATED BY THE es_generator.py SCRIPT
 * API specification file:   APIspec.txt
 * GLES version:             GLES2.0
 * date:                     2009-05-12 14:09:26
 */


/* We need to define this to get prototypes for the extension functions. */
#define GL_GLEXT_PROTOTYPES

#include "GLES2/gl2.h"
#include "GLES2/gl2ext.h"
#include "st_platform.h"


/* These types are needed for the Mesa veneer, but are not defined in
 * the standard GLES headers.
 */
typedef double GLdouble;
typedef double GLclampd;

/* This type is normally in glext.h, but needed here */
typedef char GLchar;

/* Mesa error handling requires these */
extern void *_mesa_get_current_context(void);
extern void _mesa_error(void *ctx, GLenum error, const char *fmtString, ... );


ST_IMPORT void ST_APIENTRY glGetIntegerv(GLenum, GLint *);
static unsigned int _get_size(GLenum pname)
{
    /* In case of error, make sure the value returned is 0. */
    GLint value = 0;
    glGetIntegerv(pname, &value);
    return (unsigned int) value;
}

/*************************************************************
 * Generated functions begin here
 */

ST_IMPORT void ST_APIENTRY _mesa_ActiveTextureARB(GLenum texture);
ST_EXPORT void ST_APIENTRY glActiveTexture(GLenum texture)
{
    switch(texture) {
        case GL_TEXTURE0:
        case GL_TEXTURE1:
        case GL_TEXTURE2:
        case GL_TEXTURE3:
        case GL_TEXTURE4:
        case GL_TEXTURE5:
        case GL_TEXTURE6:
        case GL_TEXTURE7:
        case GL_TEXTURE8:
        case GL_TEXTURE9:
        case GL_TEXTURE10:
        case GL_TEXTURE11:
        case GL_TEXTURE12:
        case GL_TEXTURE13:
        case GL_TEXTURE14:
        case GL_TEXTURE15:
        case GL_TEXTURE16:
        case GL_TEXTURE17:
        case GL_TEXTURE18:
        case GL_TEXTURE19:
        case GL_TEXTURE20:
        case GL_TEXTURE21:
        case GL_TEXTURE22:
        case GL_TEXTURE23:
        case GL_TEXTURE24:
        case GL_TEXTURE25:
        case GL_TEXTURE26:
        case GL_TEXTURE27:
        case GL_TEXTURE28:
        case GL_TEXTURE29:
        case GL_TEXTURE30:
        case GL_TEXTURE31:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glActiveTexture(texture=0x%x)", texture);
            return;
    } 

    _mesa_ActiveTextureARB(texture);
}

ST_IMPORT void ST_APIENTRY _mesa_AttachShader(GLuint program, GLuint shader);
ST_EXPORT void ST_APIENTRY glAttachShader(GLuint program, GLuint shader)
{
    _mesa_AttachShader(program, shader);
}

ST_IMPORT void ST_APIENTRY _mesa_BindAttribLocationARB(GLuint program, GLuint index, const char * name);
ST_EXPORT void ST_APIENTRY glBindAttribLocation(GLuint program, GLuint index, const char * name)
{
    _mesa_BindAttribLocationARB(program, index, name);
}

ST_IMPORT void ST_APIENTRY _mesa_BindBufferARB(GLenum target, GLuint buffer);
ST_EXPORT void ST_APIENTRY glBindBuffer(GLenum target, GLuint buffer)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindBuffer(target=0x%x)", target);
            return;
    } 

    _mesa_BindBufferARB(target, buffer);
}

ST_IMPORT void ST_APIENTRY _mesa_BindFramebufferEXT(GLenum target, GLuint framebuffer);
ST_EXPORT void ST_APIENTRY glBindFramebuffer(GLenum target, GLuint framebuffer)
{
    switch(target) {
        case GL_FRAMEBUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindFramebuffer(target=0x%x)", target);
            return;
    } 

    _mesa_BindFramebufferEXT(target, framebuffer);
}

ST_IMPORT void ST_APIENTRY _mesa_BindRenderbufferEXT(GLenum target, GLuint renderbuffer);
ST_EXPORT void ST_APIENTRY glBindRenderbuffer(GLenum target, GLuint renderbuffer)
{
    switch(target) {
        case GL_RENDERBUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindRenderbuffer(target=0x%x)", target);
            return;
    } 

    _mesa_BindRenderbufferEXT(target, renderbuffer);
}

ST_IMPORT void ST_APIENTRY _mesa_BindTexture(GLenum target, GLuint texture);
ST_EXPORT void ST_APIENTRY glBindTexture(GLenum target, GLuint texture)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindTexture(target=0x%x)", target);
            return;
    } 

    _mesa_BindTexture(target, texture);
}

ST_IMPORT void ST_APIENTRY _mesa_BlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
ST_EXPORT void ST_APIENTRY glBlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
    _mesa_BlendColor(red, green, blue, alpha);
}

ST_IMPORT void ST_APIENTRY _mesa_BlendEquation(GLenum mode);
ST_EXPORT void ST_APIENTRY glBlendEquation(GLenum mode)
{
    switch(mode) {
        case GL_FUNC_ADD:
        case GL_FUNC_SUBTRACT:
        case GL_FUNC_REVERSE_SUBTRACT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendEquation(mode=0x%x)", mode);
            return;
    } 

    _mesa_BlendEquation(mode);
}

ST_IMPORT void ST_APIENTRY _mesa_BlendEquationSeparateEXT(GLenum modeRGB, GLenum modeAlpha);
ST_EXPORT void ST_APIENTRY glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    switch(modeRGB) {
        case GL_FUNC_ADD:
        case GL_FUNC_SUBTRACT:
        case GL_FUNC_REVERSE_SUBTRACT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendEquationSeparate(modeRGB=0x%x)", modeRGB);
            return;
    }
    switch(modeAlpha) {
        case GL_FUNC_ADD:
        case GL_FUNC_SUBTRACT:
        case GL_FUNC_REVERSE_SUBTRACT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendEquationSeparate(modeAlpha=0x%x)", modeAlpha);
            return;
    } 

    _mesa_BlendEquationSeparateEXT(modeRGB, modeAlpha);
}

ST_IMPORT void ST_APIENTRY _mesa_BlendFunc(GLenum sfactor, GLenum dfactor);
ST_EXPORT void ST_APIENTRY glBlendFunc(GLenum sfactor, GLenum dfactor)
{
    switch(sfactor) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_SRC_ALPHA_SATURATE:
        case GL_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFunc(sfactor=0x%x)", sfactor);
            return;
    }
    switch(dfactor) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_COLOR:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFunc(dfactor=0x%x)", dfactor);
            return;
    } 

    _mesa_BlendFunc(sfactor, dfactor);
}

ST_IMPORT void ST_APIENTRY _mesa_BlendFuncSeparateEXT(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
ST_EXPORT void ST_APIENTRY glBlendFuncSeparate(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    switch(srcRGB) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_SRC_ALPHA_SATURATE:
        case GL_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(srcRGB=0x%x)", srcRGB);
            return;
    }
    switch(dstRGB) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(dstRGB=0x%x)", dstRGB);
            return;
    }
    switch(srcAlpha) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_SRC_ALPHA_SATURATE:
        case GL_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(srcAlpha=0x%x)", srcAlpha);
            return;
    }
    switch(dstAlpha) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(dstAlpha=0x%x)", dstAlpha);
            return;
    } 

    _mesa_BlendFuncSeparateEXT(srcRGB, dstRGB, srcAlpha, dstAlpha);
}

ST_IMPORT void ST_APIENTRY _mesa_BufferDataARB(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage);
ST_EXPORT void ST_APIENTRY glBufferData(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBufferData(target=0x%x)", target);
            return;
    }
    switch(usage) {
        case GL_STATIC_DRAW:
        case GL_DYNAMIC_DRAW:
        case GL_STREAM_DRAW:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBufferData(usage=0x%x)", usage);
            return;
    } 

    _mesa_BufferDataARB(target, size, data, usage);
}

ST_IMPORT void ST_APIENTRY _mesa_BufferSubDataARB(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data);
ST_EXPORT void ST_APIENTRY glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBufferSubData(target=0x%x)", target);
            return;
    } 

    _mesa_BufferSubDataARB(target, offset, size, data);
}

ST_IMPORT GLenum ST_APIENTRY _mesa_CheckFramebufferStatusEXT(GLenum target);
ST_EXPORT GLenum ST_APIENTRY glCheckFramebufferStatus(GLenum target)
{
    switch(target) {
        case GL_FRAMEBUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCheckFramebufferStatus(target=0x%x)", target);
            return (GLenum) 0;
    } 

    return _mesa_CheckFramebufferStatusEXT(target);
}

ST_IMPORT void ST_APIENTRY _mesa_Clear(GLbitfield mask);
ST_EXPORT void ST_APIENTRY glClear(GLbitfield mask)
{
    switch(mask) {
        case 0:
        case (GL_COLOR_BUFFER_BIT):
        case (GL_DEPTH_BUFFER_BIT):
        case (GL_STENCIL_BUFFER_BIT):
        case (GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT):
        case (GL_COLOR_BUFFER_BIT|GL_STENCIL_BUFFER_BIT):
        case (GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT):
        case (GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT):
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glClear(mask=0x%x)", mask);
            return;
    } 

    _mesa_Clear(mask);
}

ST_IMPORT void ST_APIENTRY _mesa_ClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
ST_EXPORT void ST_APIENTRY glClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
    _mesa_ClearColor(red, green, blue, alpha);
}

ST_IMPORT void ST_APIENTRY _mesa_ClearDepth(GLclampd  depth);
ST_EXPORT void ST_APIENTRY glClearDepthf(GLclampf depth)
{
    GLclampd converted_depth; 

    converted_depth = (GLclampd) (depth); 

    _mesa_ClearDepth(converted_depth);
}

ST_IMPORT void ST_APIENTRY _mesa_ClearStencil(GLint s);
ST_EXPORT void ST_APIENTRY glClearStencil(GLint s)
{
    _mesa_ClearStencil(s);
}

ST_IMPORT void ST_APIENTRY _mesa_ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
ST_EXPORT void ST_APIENTRY glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    _mesa_ColorMask(red, green, blue, alpha);
}

ST_IMPORT void ST_APIENTRY _mesa_CompileShaderARB(GLuint shader);
ST_EXPORT void ST_APIENTRY glCompileShader(GLuint shader)
{
    _mesa_CompileShaderARB(shader);
}

ST_IMPORT void ST_APIENTRY _mesa_CompressedTexImage3DARB(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imagesize, const GLvoid * data);
/* Extension OES_texture_3D */
ST_EXPORT void ST_APIENTRY glCompressedTexImage3DOES(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imagesize, const GLvoid * data)
{
    switch(target) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexImage3D(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ALPHA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
        case GL_RGB:
        case GL_RGBA:
        case GL_3DC_X_AMD:
        case GL_3DC_XY_AMD:
        case GL_ATC_RGB_AMD:
        case GL_ATC_RGBA_EXPLICIT_ALPHA_AMD:
        case GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexImage3D(internalFormat=0x%x)", internalFormat);
            return;
    } 

    _mesa_CompressedTexImage3DARB(target, level, internalFormat, width, height, depth, border, imagesize, data);
}

ST_IMPORT void ST_APIENTRY _mesa_CompressedTexSubImage2DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data);
ST_EXPORT void ST_APIENTRY glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexSubImage2D(target=0x%x)", target);
            return;
    }
    switch(format) {
        case GL_PALETTE4_RGB8_OES:
        case GL_PALETTE4_RGBA8_OES:
        case GL_PALETTE4_R5_G6_B5_OES:
        case GL_PALETTE4_RGBA4_OES:
        case GL_PALETTE4_RGB5_A1_OES:
        case GL_PALETTE8_RGB8_OES:
        case GL_PALETTE8_RGBA8_OES:
        case GL_PALETTE8_R5_G6_B5_OES:
        case GL_PALETTE8_RGBA4_OES:
        case GL_PALETTE8_RGB5_A1_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexSubImage2D(format=0x%x)", format);
            return;
    } 

    _mesa_CompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}

ST_IMPORT void ST_APIENTRY _mesa_CompressedTexSubImage3DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imagesize, const GLvoid * data);
/* Extension OES_texture_3D */
ST_EXPORT void ST_APIENTRY glCompressedTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imagesize, const GLvoid * data)
{
    switch(target) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexSubImage3D(target=0x%x)", target);
            return;
    } 

    _mesa_CompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imagesize, data);
}

ST_IMPORT void ST_APIENTRY _mesa_CopyTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
ST_EXPORT void ST_APIENTRY glCopyTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCopyTexImage2D(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ALPHA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
        case GL_RGB:
        case GL_RGBA:
            break;
        case GL_DEPTH_COMPONENT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCopyTexImage2D(internalFormat=0x%x)", internalFormat);
            return;
    }
    switch(border) {
        case 0:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glCopyTexImage2D(border=%d)", border);
            return;
    } 

    _mesa_CopyTexImage2D(target, level, internalFormat, x, y, width, height, border);
}

ST_IMPORT void ST_APIENTRY _mesa_CopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
ST_EXPORT void ST_APIENTRY glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCopyTexSubImage2D(target=0x%x)", target);
            return;
    } 

    _mesa_CopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}

ST_IMPORT void ST_APIENTRY _mesa_CopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
/* Extension OES_texture_3D */
ST_EXPORT void ST_APIENTRY glCopyTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    switch(target) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCopyTexSubImage3D(target=0x%x)", target);
            return;
    } 

    _mesa_CopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

ST_IMPORT GLuint ST_APIENTRY _mesa_CreateProgram();
ST_EXPORT GLuint ST_APIENTRY glCreateProgram(void)
{
    return _mesa_CreateProgram();
}

ST_IMPORT GLuint ST_APIENTRY _mesa_CreateShader(GLenum type);
ST_EXPORT GLuint ST_APIENTRY glCreateShader(GLenum type)
{
    switch(type) {
        case GL_VERTEX_SHADER:
        case GL_FRAGMENT_SHADER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCreateShader(type=0x%x)", type);
            return (GLuint) 0;
    } 

    return _mesa_CreateShader(type);
}

ST_IMPORT void ST_APIENTRY _mesa_CullFace(GLenum mode);
ST_EXPORT void ST_APIENTRY glCullFace(GLenum mode)
{
    switch(mode) {
        case GL_FRONT:
        case GL_BACK:
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCullFace(mode=0x%x)", mode);
            return;
    } 

    _mesa_CullFace(mode);
}

ST_IMPORT void ST_APIENTRY _mesa_DeleteBuffersARB(GLsizei n, const GLuint * buffer);
ST_EXPORT void ST_APIENTRY glDeleteBuffers(GLsizei n, const GLuint * buffer)
{
    _mesa_DeleteBuffersARB(n, buffer);
}

ST_IMPORT void ST_APIENTRY _mesa_DeleteFramebuffersEXT(GLsizei n, const GLuint * framebuffers);
ST_EXPORT void ST_APIENTRY glDeleteFramebuffers(GLsizei n, const GLuint * framebuffers)
{
    _mesa_DeleteFramebuffersEXT(n, framebuffers);
}

ST_IMPORT void ST_APIENTRY _mesa_DeleteProgram(GLuint program);
ST_EXPORT void ST_APIENTRY glDeleteProgram(GLuint program)
{
    _mesa_DeleteProgram(program);
}

ST_IMPORT void ST_APIENTRY _mesa_DeleteRenderbuffersEXT(GLsizei n, const GLuint * renderbuffers);
ST_EXPORT void ST_APIENTRY glDeleteRenderbuffers(GLsizei n, const GLuint * renderbuffers)
{
    _mesa_DeleteRenderbuffersEXT(n, renderbuffers);
}

ST_IMPORT void ST_APIENTRY _mesa_DeleteShader(GLuint shader);
ST_EXPORT void ST_APIENTRY glDeleteShader(GLuint shader)
{
    _mesa_DeleteShader(shader);
}

ST_IMPORT void ST_APIENTRY _mesa_DeleteTextures(GLsizei n, const GLuint * textures);
ST_EXPORT void ST_APIENTRY glDeleteTextures(GLsizei n, const GLuint * textures)
{
    _mesa_DeleteTextures(n, textures);
}

ST_IMPORT void ST_APIENTRY _mesa_DepthFunc(GLenum func);
ST_EXPORT void ST_APIENTRY glDepthFunc(GLenum func)
{
    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_EQUAL:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_NOTEQUAL:
        case GL_GEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDepthFunc(func=0x%x)", func);
            return;
    } 

    _mesa_DepthFunc(func);
}

ST_IMPORT void ST_APIENTRY _mesa_DepthMask(GLboolean flag);
ST_EXPORT void ST_APIENTRY glDepthMask(GLboolean flag)
{
    _mesa_DepthMask(flag);
}

ST_IMPORT void ST_APIENTRY _mesa_DepthRange(GLclampd  zNear, GLclampd  zFar);
ST_EXPORT void ST_APIENTRY glDepthRangef(GLclampf zNear, GLclampf zFar)
{
    GLclampd converted_zNear;
    GLclampd converted_zFar; 

    converted_zNear = (GLclampd) (zNear);
    converted_zFar = (GLclampd) (zFar); 

    _mesa_DepthRange(converted_zNear, converted_zFar);
}

ST_IMPORT void ST_APIENTRY _mesa_DetachShader(GLuint program, GLuint shader);
ST_EXPORT void ST_APIENTRY glDetachShader(GLuint program, GLuint shader)
{
    _mesa_DetachShader(program, shader);
}

ST_IMPORT void ST_APIENTRY _mesa_Disable(GLenum cap);
ST_EXPORT void ST_APIENTRY glDisable(GLenum cap)
{
    switch(cap) {
        case GL_CULL_FACE:
        case GL_SCISSOR_TEST:
        case GL_POLYGON_OFFSET_FILL:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_COVERAGE:
        case GL_STENCIL_TEST:
        case GL_DEPTH_TEST:
        case GL_DITHER:
        case GL_BLEND:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDisable(cap=0x%x)", cap);
            return;
    } 

    _mesa_Disable(cap);
}

ST_IMPORT void ST_APIENTRY _mesa_DisableVertexAttribArrayARB(GLuint index);
ST_EXPORT void ST_APIENTRY glDisableVertexAttribArray(GLuint index)
{
    _mesa_DisableVertexAttribArrayARB(index);
}

ST_IMPORT void ST_APIENTRY _mesa_DrawArrays(GLenum mode, GLint first, GLsizei count);
ST_EXPORT void ST_APIENTRY glDrawArrays(GLenum mode, GLint first, GLsizei count)
{
    switch(mode) {
        case GL_POINTS:
        case GL_LINE_STRIP:
        case GL_LINE_LOOP:
        case GL_LINES:
        case GL_TRIANGLE_STRIP:
        case GL_TRIANGLE_FAN:
        case GL_TRIANGLES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDrawArrays(mode=0x%x)", mode);
            return;
    } 

    _mesa_DrawArrays(mode, first, count);
}

ST_IMPORT void ST_APIENTRY _mesa_DrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices);
ST_EXPORT void ST_APIENTRY glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices)
{
    switch(mode) {
        case GL_POINTS:
        case GL_LINE_STRIP:
        case GL_LINE_LOOP:
        case GL_LINES:
        case GL_TRIANGLE_STRIP:
        case GL_TRIANGLE_FAN:
        case GL_TRIANGLES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDrawElements(mode=0x%x)", mode);
            return;
    }
    switch(type) {
        case GL_UNSIGNED_BYTE:
        case GL_UNSIGNED_SHORT:
        case GL_UNSIGNED_INT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDrawElements(type=0x%x)", type);
            return;
    } 

    _mesa_DrawElements(mode, count, type, indices);
}

ST_IMPORT void ST_APIENTRY _mesa_Enable(GLenum cap);
ST_EXPORT void ST_APIENTRY glEnable(GLenum cap)
{
    switch(cap) {
        case GL_CULL_FACE:
        case GL_SCISSOR_TEST:
        case GL_POLYGON_OFFSET_FILL:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_COVERAGE:
        case GL_STENCIL_TEST:
        case GL_DEPTH_TEST:
        case GL_DITHER:
        case GL_BLEND:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glEnable(cap=0x%x)", cap);
            return;
    } 

    _mesa_Enable(cap);
}

ST_IMPORT void ST_APIENTRY _mesa_EnableVertexAttribArrayARB(GLuint index);
ST_EXPORT void ST_APIENTRY glEnableVertexAttribArray(GLuint index)
{
    _mesa_EnableVertexAttribArrayARB(index);
}

ST_IMPORT void ST_APIENTRY _mesa_Finish();
ST_EXPORT void ST_APIENTRY glFinish(void)
{
    _mesa_Finish();
}

ST_IMPORT void ST_APIENTRY _mesa_Flush();
ST_EXPORT void ST_APIENTRY glFlush(void)
{
    _mesa_Flush();
}

ST_IMPORT void ST_APIENTRY _mesa_FramebufferRenderbufferEXT(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
ST_EXPORT void ST_APIENTRY glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
    switch(target) {
        case GL_FRAMEBUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferRenderbuffer(target=0x%x)", target);
            return;
    }
    switch(attachment) {
        case GL_COLOR_ATTACHMENT0:
        case GL_DEPTH_ATTACHMENT:
        case GL_STENCIL_ATTACHMENT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferRenderbuffer(attachment=0x%x)", attachment);
            return;
    }
    switch(renderbuffertarget) {
        case GL_RENDERBUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferRenderbuffer(renderbuffertarget=0x%x)", renderbuffertarget);
            return;
    } 

    _mesa_FramebufferRenderbufferEXT(target, attachment, renderbuffertarget, renderbuffer);
}

ST_IMPORT void ST_APIENTRY _mesa_FramebufferTexture2DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
ST_EXPORT void ST_APIENTRY glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    switch(target) {
        case GL_FRAMEBUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferTexture2D(target=0x%x)", target);
            return;
    }
    switch(attachment) {
        case GL_COLOR_ATTACHMENT0:
        case GL_DEPTH_ATTACHMENT:
        case GL_STENCIL_ATTACHMENT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFramebufferTexture2D(attachment=0x%x)", attachment);
            return;
    }
    switch(textarget) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glFramebufferTexture2D(textarget=0x%x)", textarget);
            return;
    } 

    _mesa_FramebufferTexture2DEXT(target, attachment, textarget, texture, level);
}

ST_IMPORT void ST_APIENTRY _mesa_FramebufferTexture3DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
/* Extension OES_texture_3D */
ST_EXPORT void ST_APIENTRY glFramebufferTexture3DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
    _mesa_FramebufferTexture3DEXT(target, attachment, textarget, texture, level, zoffset);
}

ST_IMPORT void ST_APIENTRY _mesa_FrontFace(GLenum mode);
ST_EXPORT void ST_APIENTRY glFrontFace(GLenum mode)
{
    switch(mode) {
        case GL_CW:
        case GL_CCW:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFrontFace(mode=0x%x)", mode);
            return;
    } 

    _mesa_FrontFace(mode);
}

ST_IMPORT void ST_APIENTRY _mesa_GenBuffersARB(GLsizei n, GLuint * buffer);
ST_EXPORT void ST_APIENTRY glGenBuffers(GLsizei n, GLuint * buffer)
{
    _mesa_GenBuffersARB(n, buffer);
}

ST_IMPORT void ST_APIENTRY _mesa_GenFramebuffersEXT(GLsizei n, GLuint * ids);
ST_EXPORT void ST_APIENTRY glGenFramebuffers(GLsizei n, GLuint * ids)
{
    _mesa_GenFramebuffersEXT(n, ids);
}

ST_IMPORT void ST_APIENTRY _mesa_GenRenderbuffersEXT(GLsizei n, GLuint * renderbuffers);
ST_EXPORT void ST_APIENTRY glGenRenderbuffers(GLsizei n, GLuint * renderbuffers)
{
    _mesa_GenRenderbuffersEXT(n, renderbuffers);
}

ST_IMPORT void ST_APIENTRY _mesa_GenTextures(GLsizei n, GLuint * textures);
ST_EXPORT void ST_APIENTRY glGenTextures(GLsizei n, GLuint * textures)
{
    _mesa_GenTextures(n, textures);
}

ST_IMPORT void ST_APIENTRY _mesa_GenerateMipmapEXT(GLenum target);
ST_EXPORT void ST_APIENTRY glGenerateMipmap(GLenum target)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGenerateMipmap(target=0x%x)", target);
            return;
    } 

    _mesa_GenerateMipmapEXT(target);
}

ST_IMPORT void ST_APIENTRY _mesa_GetActiveAttribARB(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
ST_EXPORT void ST_APIENTRY glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name)
{
    _mesa_GetActiveAttribARB(program, index, bufSize, length, size, type, name);
}

ST_IMPORT void ST_APIENTRY _mesa_GetActiveUniformARB(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
ST_EXPORT void ST_APIENTRY glGetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name)
{
    _mesa_GetActiveUniformARB(program, index, bufSize, length, size, type, name);
}

ST_IMPORT void ST_APIENTRY _mesa_GetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders);
ST_EXPORT void ST_APIENTRY glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders)
{
    _mesa_GetAttachedShaders(program, maxCount, count, shaders);
}

ST_IMPORT GLint ST_APIENTRY _mesa_GetAttribLocationARB(GLuint program, const char * name);
ST_EXPORT GLint ST_APIENTRY glGetAttribLocation(GLuint program, const char * name)
{
    return _mesa_GetAttribLocationARB(program, name);
}

ST_IMPORT void ST_APIENTRY _mesa_GetBooleanv(GLenum pname, GLboolean * params);
ST_EXPORT void ST_APIENTRY glGetBooleanv(GLenum pname, GLboolean * params)
{
    _mesa_GetBooleanv(pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetBufferParameterivARB(GLenum target, GLenum pname, GLint * params);
ST_EXPORT void ST_APIENTRY glGetBufferParameteriv(GLenum target, GLenum pname, GLint * params)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_BUFFER_SIZE:
        case GL_BUFFER_USAGE:
        case GL_BUFFER_ACCESS_OES:
        case GL_BUFFER_MAPPED_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetBufferParameterivARB(target, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetBufferPointervARB(GLenum target, GLenum pname, GLvoid ** params);
/* Extension OES_mapbuffer */
ST_EXPORT void ST_APIENTRY glGetBufferPointervOES(GLenum target, GLenum pname, GLvoid ** params)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferPointerv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_BUFFER_MAP_POINTER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferPointerv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetBufferPointervARB(target, pname, params);
}

ST_IMPORT GLenum ST_APIENTRY _mesa_GetError();
ST_EXPORT GLenum ST_APIENTRY glGetError(void)
{
    return _mesa_GetError();
}

ST_IMPORT void ST_APIENTRY _mesa_GetFloatv(GLenum pname, GLfloat * params);
ST_EXPORT void ST_APIENTRY glGetFloatv(GLenum pname, GLfloat * params)
{
    _mesa_GetFloatv(pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetFramebufferAttachmentParameterivEXT(GLenum target, GLenum attachment, GLenum pname, GLint * params);
ST_EXPORT void ST_APIENTRY glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint * params)
{
    switch(target) {
        case GL_FRAMEBUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetFramebufferAttachmentParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetFramebufferAttachmentParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetFramebufferAttachmentParameterivEXT(target, attachment, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetIntegerv(GLenum pname, GLint * params);
ST_EXPORT void ST_APIENTRY glGetIntegerv(GLenum pname, GLint * params)
{
    _mesa_GetIntegerv(pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
ST_EXPORT void ST_APIENTRY glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog)
{
    _mesa_GetProgramInfoLog(program, bufSize, length, infoLog);
}

ST_IMPORT void ST_APIENTRY _mesa_GetProgramiv(GLuint program, GLenum pname, GLint * params);
ST_EXPORT void ST_APIENTRY glGetProgramiv(GLuint program, GLenum pname, GLint * params)
{
    switch(pname) {
        case GL_DELETE_STATUS:
        case GL_LINK_STATUS:
        case GL_VALIDATE_STATUS:
        case GL_INFO_LOG_LENGTH:
        case GL_ATTACHED_SHADERS:
        case GL_ACTIVE_ATTRIBUTES:
        case GL_ACTIVE_ATTRIBUTE_MAX_LENGTH:
        case GL_ACTIVE_UNIFORMS:
        case GL_ACTIVE_UNIFORM_MAX_LENGTH:
        case GL_PROGRAM_BINARY_LENGTH_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetProgramiv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetProgramiv(program, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetRenderbufferParameterivEXT(GLenum target, GLenum pname, GLint * params);
ST_EXPORT void ST_APIENTRY glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint * params)
{
    switch(target) {
        case GL_RENDERBUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetRenderbufferParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_RENDERBUFFER_WIDTH: /* size 1 */
        case GL_RENDERBUFFER_HEIGHT: /* size 1 */
        case GL_RENDERBUFFER_INTERNAL_FORMAT: /* size 1 */
        case GL_RENDERBUFFER_RED_SIZE: /* size 1 */
        case GL_RENDERBUFFER_GREEN_SIZE: /* size 1 */
        case GL_RENDERBUFFER_BLUE_SIZE: /* size 1 */
        case GL_RENDERBUFFER_ALPHA_SIZE: /* size 1 */
        case GL_RENDERBUFFER_DEPTH_SIZE: /* size 1 */
        case GL_RENDERBUFFER_STENCIL_SIZE: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetRenderbufferParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetRenderbufferParameterivEXT(target, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
ST_EXPORT void ST_APIENTRY glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog)
{
    _mesa_GetShaderInfoLog(shader, bufSize, length, infoLog);
}

ST_IMPORT void ST_APIENTRY _mesa_GetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint * range, GLint * precision);
ST_EXPORT void ST_APIENTRY glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint * range, GLint * precision)
{
    switch(shadertype) {
        case GL_VERTEX_SHADER:
        case GL_FRAGMENT_SHADER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetShaderPrecisionFormat(shadertype=0x%x)", shadertype);
            return;
    }
    switch(precisiontype) {
        case GL_LOW_FLOAT:
        case GL_MEDIUM_FLOAT:
        case GL_HIGH_FLOAT:
        case GL_LOW_INT:
        case GL_MEDIUM_INT:
        case GL_HIGH_INT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetShaderPrecisionFormat(precisiontype=0x%x)", precisiontype);
            return;
    } 

    _mesa_GetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
}

ST_IMPORT void ST_APIENTRY _mesa_GetShaderSourceARB(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source);
ST_EXPORT void ST_APIENTRY glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source)
{
    _mesa_GetShaderSourceARB(shader, bufSize, length, source);
}

ST_IMPORT void ST_APIENTRY _mesa_GetShaderiv(GLuint shader, GLenum pname, GLint * params);
ST_EXPORT void ST_APIENTRY glGetShaderiv(GLuint shader, GLenum pname, GLint * params)
{
    switch(pname) {
        case GL_SHADER_TYPE:
        case GL_COMPILE_STATUS:
        case GL_DELETE_STATUS:
        case GL_INFO_LOG_LENGTH:
        case GL_SHADER_SOURCE_LENGTH:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetShaderiv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetShaderiv(shader, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetTexParameterfv(GLenum target, GLenum pname, GLfloat * params);
ST_EXPORT void ST_APIENTRY glGetTexParameterfv(GLenum target, GLenum pname, GLfloat * params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterfv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexParameterfv(target, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetTexParameteriv(GLenum target, GLenum pname, GLint * params);
ST_EXPORT void ST_APIENTRY glGetTexParameteriv(GLenum target, GLenum pname, GLint * params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetTexParameteriv(target, pname, params);
}

ST_IMPORT GLint ST_APIENTRY _mesa_GetUniformLocationARB(GLuint program, const char * name);
ST_EXPORT GLint ST_APIENTRY glGetUniformLocation(GLuint program, const char * name)
{
    return _mesa_GetUniformLocationARB(program, name);
}

ST_IMPORT void ST_APIENTRY _mesa_GetUniformfvARB(GLuint program, GLint location, GLfloat * params);
ST_EXPORT void ST_APIENTRY glGetUniformfv(GLuint program, GLint location, GLfloat * params)
{
    _mesa_GetUniformfvARB(program, location, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetUniformivARB(GLuint program, GLint location, GLint * params);
ST_EXPORT void ST_APIENTRY glGetUniformiv(GLuint program, GLint location, GLint * params)
{
    _mesa_GetUniformivARB(program, location, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetVertexAttribPointervARB(GLuint index, GLenum pname, GLvoid ** pointer);
ST_EXPORT void ST_APIENTRY glGetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid ** pointer)
{
    switch(pname) {
        case GL_VERTEX_ATTRIB_ARRAY_POINTER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetVertexAttribPointerv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetVertexAttribPointervARB(index, pname, pointer);
}

ST_IMPORT void ST_APIENTRY _mesa_GetVertexAttribfvARB(GLuint index, GLenum pname, GLfloat * params);
ST_EXPORT void ST_APIENTRY glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat * params)
{
    switch(pname) {
        case GL_VERTEX_ATTRIB_ARRAY_ENABLED: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_SIZE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_STRIDE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_TYPE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_NORMALIZED: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: /* size 1 */
        case GL_CURRENT_VERTEX_ATTRIB: /* size 16? */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetVertexAttribfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetVertexAttribfvARB(index, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_GetVertexAttribivARB(GLuint index, GLenum pname, GLint * params);
ST_EXPORT void ST_APIENTRY glGetVertexAttribiv(GLuint index, GLenum pname, GLint * params)
{
    switch(pname) {
        case GL_VERTEX_ATTRIB_ARRAY_ENABLED: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_SIZE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_STRIDE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_TYPE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_NORMALIZED: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: /* size 1 */
        case GL_CURRENT_VERTEX_ATTRIB: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetVertexAttribiv(pname=0x%x)", pname);
            return;
    } 

    _mesa_GetVertexAttribivARB(index, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_Hint(GLenum target, GLenum mode);
ST_EXPORT void ST_APIENTRY glHint(GLenum target, GLenum mode)
{
    switch(target) {
        case GL_GENERATE_MIPMAP_HINT:
        case GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glHint(target=0x%x)", target);
            return;
    }
    switch(mode) {
        case GL_FASTEST:
        case GL_NICEST:
        case GL_DONT_CARE:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glHint(mode=0x%x)", mode);
            return;
    } 

    _mesa_Hint(target, mode);
}

ST_IMPORT GLboolean ST_APIENTRY _mesa_IsBufferARB(GLuint buffer);
ST_EXPORT GLboolean ST_APIENTRY glIsBuffer(GLuint buffer)
{
    return _mesa_IsBufferARB(buffer);
}

ST_IMPORT GLboolean ST_APIENTRY _mesa_IsEnabled(GLenum cap);
ST_EXPORT GLboolean ST_APIENTRY glIsEnabled(GLenum cap)
{
    switch(cap) {
        case GL_CULL_FACE:
        case GL_SCISSOR_TEST:
        case GL_POLYGON_OFFSET_FILL:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_COVERAGE:
        case GL_STENCIL_TEST:
        case GL_DEPTH_TEST:
        case GL_DITHER:
        case GL_BLEND:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glIsEnabled(cap=0x%x)", cap);
            return GL_FALSE;
    } 

    return _mesa_IsEnabled(cap);
}

ST_IMPORT GLboolean ST_APIENTRY _mesa_IsFramebufferEXT(GLuint framebuffer);
ST_EXPORT GLboolean ST_APIENTRY glIsFramebuffer(GLuint framebuffer)
{
    return _mesa_IsFramebufferEXT(framebuffer);
}

ST_IMPORT GLboolean ST_APIENTRY _mesa_IsProgram(GLuint program);
ST_EXPORT GLboolean ST_APIENTRY glIsProgram(GLuint program)
{
    return _mesa_IsProgram(program);
}

ST_IMPORT GLboolean ST_APIENTRY _mesa_IsRenderbufferEXT(GLuint renderbuffer);
ST_EXPORT GLboolean ST_APIENTRY glIsRenderbuffer(GLuint renderbuffer)
{
    return _mesa_IsRenderbufferEXT(renderbuffer);
}

ST_IMPORT GLboolean ST_APIENTRY _mesa_IsShader(GLuint shader);
ST_EXPORT GLboolean ST_APIENTRY glIsShader(GLuint shader)
{
    return _mesa_IsShader(shader);
}

ST_IMPORT GLboolean ST_APIENTRY _mesa_IsTexture(GLuint texture);
ST_EXPORT GLboolean ST_APIENTRY glIsTexture(GLuint texture)
{
    return _mesa_IsTexture(texture);
}

ST_IMPORT void ST_APIENTRY _mesa_LineWidth(GLfloat width);
ST_EXPORT void ST_APIENTRY glLineWidth(GLfloat width)
{
    _mesa_LineWidth(width);
}

ST_IMPORT void ST_APIENTRY _mesa_LinkProgramARB(GLuint program);
ST_EXPORT void ST_APIENTRY glLinkProgram(GLuint program)
{
    _mesa_LinkProgramARB(program);
}

ST_IMPORT void * ST_APIENTRY _mesa_MapBufferARB(GLenum target, GLenum access);
/* Extension OES_mapbuffer */
ST_EXPORT void * ST_APIENTRY glMapBufferOES(GLenum target, GLenum access)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMapBuffer(target=0x%x)", target);
            return (void *) 0;
    }
    switch(access) {
        case GL_WRITE_ONLY_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMapBuffer(access=0x%x)", access);
            return (void *) 0;
    } 

    return _mesa_MapBufferARB(target, access);
}

ST_IMPORT void ST_APIENTRY _mesa_PixelStorei(GLenum pname, GLint param);
ST_EXPORT void ST_APIENTRY glPixelStorei(GLenum pname, GLint param)
{
    switch(pname) {
        case GL_PACK_ALIGNMENT:
        case GL_UNPACK_ALIGNMENT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPixelStorei(pname=0x%x)", pname);
            return;
    }
    switch(param) {
        case 1:
        case 2:
        case 4:
        case 8:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glPixelStorei(param=%d)", param);
            return;
    } 

    _mesa_PixelStorei(pname, param);
}

ST_IMPORT void ST_APIENTRY _mesa_PolygonOffset(GLfloat factor, GLfloat units);
ST_EXPORT void ST_APIENTRY glPolygonOffset(GLfloat factor, GLfloat units)
{
    _mesa_PolygonOffset(factor, units);
}

ST_IMPORT void ST_APIENTRY _mesa_ReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels);
ST_EXPORT void ST_APIENTRY glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels)
{
    switch(format) {
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        case GL_LUMINANCE_ALPHA:
        case GL_LUMINANCE:
        case GL_ALPHA:
            if (format != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glReadPixels(format=0x%x)", format);
            return;
    } 

    _mesa_ReadPixels(x, y, width, height, format, type, pixels);
}

ST_IMPORT void ST_APIENTRY _mesa_ReleaseShaderCompiler();
ST_EXPORT void ST_APIENTRY glReleaseShaderCompiler(void)
{
    _mesa_ReleaseShaderCompiler();
}

ST_IMPORT void ST_APIENTRY _mesa_SampleCoverageARB(GLclampf value, GLboolean invert);
ST_EXPORT void ST_APIENTRY glSampleCoverage(GLclampf value, GLboolean invert)
{
    _mesa_SampleCoverageARB(value, invert);
}

ST_IMPORT void ST_APIENTRY _mesa_Scissor(GLint x, GLint y, GLsizei width, GLsizei height);
ST_EXPORT void ST_APIENTRY glScissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    _mesa_Scissor(x, y, width, height);
}

ST_IMPORT void ST_APIENTRY _mesa_ShaderBinary(GLint n, const GLuint * shaders, GLenum binaryformat, const GLvoid * binary, GLint length);
ST_EXPORT void ST_APIENTRY glShaderBinary(GLint n, const GLuint * shaders, GLenum binaryformat, const GLvoid * binary, GLint length)
{
    _mesa_ShaderBinary(n, shaders, binaryformat, binary, length);
}

ST_IMPORT void ST_APIENTRY _mesa_ShaderSourceARB(GLuint shader, GLsizei count, const GLchar ** string, const int * length);
ST_EXPORT void ST_APIENTRY glShaderSource(GLuint shader, GLsizei count, const GLchar ** string, const int * length)
{
    _mesa_ShaderSourceARB(shader, count, string, length);
}

ST_IMPORT void ST_APIENTRY _mesa_StencilFunc(GLenum func, GLint ref, GLuint mask);
ST_EXPORT void ST_APIENTRY glStencilFunc(GLenum func, GLint ref, GLuint mask)
{
    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_GEQUAL:
        case GL_EQUAL:
        case GL_NOTEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilFunc(func=0x%x)", func);
            return;
    } 

    _mesa_StencilFunc(func, ref, mask);
}

ST_IMPORT void ST_APIENTRY _mesa_StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask);
ST_EXPORT void ST_APIENTRY glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    switch(face) {
        case GL_FRONT:
        case GL_BACK:
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilFuncSeparate(face=0x%x)", face);
            return;
    }
    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_GEQUAL:
        case GL_EQUAL:
        case GL_NOTEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilFuncSeparate(func=0x%x)", func);
            return;
    } 

    _mesa_StencilFuncSeparate(face, func, ref, mask);
}

ST_IMPORT void ST_APIENTRY _mesa_StencilMask(GLuint mask);
ST_EXPORT void ST_APIENTRY glStencilMask(GLuint mask)
{
    _mesa_StencilMask(mask);
}

ST_IMPORT void ST_APIENTRY _mesa_StencilMaskSeparate(GLenum face, GLuint mask);
ST_EXPORT void ST_APIENTRY glStencilMaskSeparate(GLenum face, GLuint mask)
{
    switch(face) {
        case GL_FRONT:
        case GL_BACK:
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilMaskSeparate(face=0x%x)", face);
            return;
    } 

    _mesa_StencilMaskSeparate(face, mask);
}

ST_IMPORT void ST_APIENTRY _mesa_StencilOp(GLenum fail, GLenum zfail, GLenum zpass);
ST_EXPORT void ST_APIENTRY glStencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    switch(fail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOp(fail=0x%x)", fail);
            return;
    }
    switch(zfail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOp(zfail=0x%x)", zfail);
            return;
    }
    switch(zpass) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOp(zpass=0x%x)", zpass);
            return;
    } 

    _mesa_StencilOp(fail, zfail, zpass);
}

ST_IMPORT void ST_APIENTRY _mesa_StencilOpSeparate(GLenum face, GLenum fail, GLenum zfail, GLenum zpass);
ST_EXPORT void ST_APIENTRY glStencilOpSeparate(GLenum face, GLenum fail, GLenum zfail, GLenum zpass)
{
    switch(face) {
        case GL_FRONT:
        case GL_BACK:
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOpSeparate(face=0x%x)", face);
            return;
    }
    switch(fail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOpSeparate(fail=0x%x)", fail);
            return;
    }
    switch(zfail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOpSeparate(zfail=0x%x)", zfail);
            return;
    }
    switch(zpass) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOpSeparate(zpass=0x%x)", zpass);
            return;
    } 

    _mesa_StencilOpSeparate(face, fail, zfail, zpass);
}

ST_IMPORT void ST_APIENTRY _mesa_TexImage2D(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
ST_EXPORT void ST_APIENTRY glTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ALPHA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
        case GL_RGB:
        case GL_RGBA:
            break;
        case GL_DEPTH_COMPONENT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(internalFormat=0x%x)", internalFormat);
            return;
    }
    switch(border) {
        case 0:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(border=%d)", border);
            return;
    }
    switch(format) {
        case GL_ALPHA:
            if (type != GL_UNSIGNED_BYTE && type != GL_FLOAT && type != GL_HALF_FLOAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5 && type != GL_FLOAT && type != GL_HALF_FLOAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1 && type != GL_FLOAT && type != GL_HALF_FLOAT_OES && type != GL_UNSIGNED_INT_2_10_10_10_REV_EXT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            if (type != GL_UNSIGNED_BYTE && type != GL_FLOAT && type != GL_HALF_FLOAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_DEPTH_COMPONENT:
            if (type != GL_UNSIGNED_SHORT && type != GL_UNSIGNED_INT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(format=0x%x)", format);
            return;
    } 

    _mesa_TexImage2D(target, level, internalFormat, width, height, border, format, type, pixels);
}

ST_IMPORT void ST_APIENTRY _mesa_TexImage3D(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
/* Extension OES_texture_3D */
ST_EXPORT void ST_APIENTRY glTexImage3DOES(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels)
{
    switch(target) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage3D(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ALPHA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
        case GL_RGB:
        case GL_RGBA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage3D(internalFormat=0x%x)", internalFormat);
            return;
    }
    switch(type) {
        case GL_FLOAT:
        case GL_HALF_FLOAT_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage3D(type=0x%x)", type);
            return;
    } 

    _mesa_TexImage3D(target, level, internalFormat, width, height, depth, border, format, type, pixels);
}

ST_IMPORT void ST_APIENTRY _mesa_TexParameterf(GLenum target, GLenum pname, GLfloat param);
ST_EXPORT void ST_APIENTRY glTexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR && param != GL_NEAREST_MIPMAP_NEAREST && param != GL_NEAREST_MIPMAP_LINEAR && param != GL_LINEAR_MIPMAP_NEAREST && param != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            break;
        case GL_TEXTURE_WRAP_R_OES:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexParameterf(target, pname, param);
}

ST_IMPORT void ST_APIENTRY _mesa_TexParameterfv(GLenum target, GLenum pname, const GLfloat * params);
ST_EXPORT void ST_APIENTRY glTexParameterfv(GLenum target, GLenum pname, const GLfloat * params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR && params[0] != GL_NEAREST_MIPMAP_NEAREST && params[0] != GL_NEAREST_MIPMAP_LINEAR && params[0] != GL_LINEAR_MIPMAP_NEAREST && params[0] != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT: /* size 1 */
            break;
        case GL_TEXTURE_WRAP_R_OES:
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexParameterfv(target, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_TexParameteri(GLenum target, GLenum pname, GLint param);
ST_EXPORT void ST_APIENTRY glTexParameteri(GLenum target, GLenum pname, GLint param)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR && param != GL_NEAREST_MIPMAP_NEAREST && param != GL_NEAREST_MIPMAP_LINEAR && param != GL_LINEAR_MIPMAP_NEAREST && param != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            break;
        case GL_TEXTURE_WRAP_R_OES:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexParameteri(target, pname, param);
}

ST_IMPORT void ST_APIENTRY _mesa_TexParameteriv(GLenum target, GLenum pname, const GLint * params);
ST_EXPORT void ST_APIENTRY glTexParameteriv(GLenum target, GLenum pname, const GLint * params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR && params[0] != GL_NEAREST_MIPMAP_NEAREST && params[0] != GL_NEAREST_MIPMAP_LINEAR && params[0] != GL_LINEAR_MIPMAP_NEAREST && params[0] != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT: /* size 1 */
            break;
        case GL_TEXTURE_WRAP_R_OES:
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
            return;
    } 

    _mesa_TexParameteriv(target, pname, params);
}

ST_IMPORT void ST_APIENTRY _mesa_TexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels);
ST_EXPORT void ST_APIENTRY glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
        case GL_TEXTURE_CUBE_MAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexSubImage2D(target=0x%x)", target);
            return;
    }
    switch(format) {
        case GL_ALPHA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            if (type != GL_UNSIGNED_BYTE && type != GL_FLOAT && type != GL_HALF_FLOAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5 && type != GL_FLOAT && type != GL_HALF_FLOAT_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1 && type != GL_FLOAT && type != GL_HALF_FLOAT_OES && type != GL_UNSIGNED_INT_2_10_10_10_REV_EXT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_DEPTH_COMPONENT:
            if (type != GL_UNSIGNED_SHORT && type != GL_UNSIGNED_INT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexSubImage2D(format=0x%x)", format);
            return;
    } 

    _mesa_TexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

ST_IMPORT void ST_APIENTRY _mesa_TexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels);
/* Extension OES_texture_3D */
ST_EXPORT void ST_APIENTRY glTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels)
{
    switch(type) {
        case GL_FLOAT:
        case GL_HALF_FLOAT_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexSubImage3D(type=0x%x)", type);
            return;
    } 

    _mesa_TexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform1fARB(GLint location, GLfloat v0);
ST_EXPORT void ST_APIENTRY glUniform1f(GLint location, GLfloat v0)
{
    _mesa_Uniform1fARB(location, v0);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform1fvARB(GLint location, GLsizei count, const GLfloat * values);
ST_EXPORT void ST_APIENTRY glUniform1fv(GLint location, GLsizei count, const GLfloat * values)
{
    _mesa_Uniform1fvARB(location, count, values);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform1iARB(GLint location, GLint v0);
ST_EXPORT void ST_APIENTRY glUniform1i(GLint location, GLint v0)
{
    _mesa_Uniform1iARB(location, v0);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform1ivARB(GLint location, GLsizei count, const GLint * values);
ST_EXPORT void ST_APIENTRY glUniform1iv(GLint location, GLsizei count, const GLint * values)
{
    _mesa_Uniform1ivARB(location, count, values);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform2fARB(GLint location, GLfloat v0, GLfloat v1);
ST_EXPORT void ST_APIENTRY glUniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    _mesa_Uniform2fARB(location, v0, v1);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform2fvARB(GLint location, GLsizei count, const GLfloat * values);
ST_EXPORT void ST_APIENTRY glUniform2fv(GLint location, GLsizei count, const GLfloat * values)
{
    _mesa_Uniform2fvARB(location, count, values);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform2iARB(GLint location, GLint v0, GLint v1);
ST_EXPORT void ST_APIENTRY glUniform2i(GLint location, GLint v0, GLint v1)
{
    _mesa_Uniform2iARB(location, v0, v1);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform2ivARB(GLint location, GLsizei count, const GLint * values);
ST_EXPORT void ST_APIENTRY glUniform2iv(GLint location, GLsizei count, const GLint * values)
{
    _mesa_Uniform2ivARB(location, count, values);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform3fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
ST_EXPORT void ST_APIENTRY glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    _mesa_Uniform3fARB(location, v0, v1, v2);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform3fvARB(GLint location, GLsizei count, const GLfloat * values);
ST_EXPORT void ST_APIENTRY glUniform3fv(GLint location, GLsizei count, const GLfloat * values)
{
    _mesa_Uniform3fvARB(location, count, values);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform3iARB(GLint location, GLint v0, GLint v1, GLint v2);
ST_EXPORT void ST_APIENTRY glUniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    _mesa_Uniform3iARB(location, v0, v1, v2);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform3ivARB(GLint location, GLsizei count, const GLint * values);
ST_EXPORT void ST_APIENTRY glUniform3iv(GLint location, GLsizei count, const GLint * values)
{
    _mesa_Uniform3ivARB(location, count, values);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform4fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
ST_EXPORT void ST_APIENTRY glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    _mesa_Uniform4fARB(location, v0, v1, v2, v3);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform4fvARB(GLint location, GLsizei count, const GLfloat * values);
ST_EXPORT void ST_APIENTRY glUniform4fv(GLint location, GLsizei count, const GLfloat * values)
{
    _mesa_Uniform4fvARB(location, count, values);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform4iARB(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
ST_EXPORT void ST_APIENTRY glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    _mesa_Uniform4iARB(location, v0, v1, v2, v3);
}

ST_IMPORT void ST_APIENTRY _mesa_Uniform4ivARB(GLint location, GLsizei count, const GLint * values);
ST_EXPORT void ST_APIENTRY glUniform4iv(GLint location, GLsizei count, const GLint * values)
{
    _mesa_Uniform4ivARB(location, count, values);
}

ST_IMPORT void ST_APIENTRY _mesa_UniformMatrix2fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
ST_EXPORT void ST_APIENTRY glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    _mesa_UniformMatrix2fvARB(location, count, transpose, value);
}

ST_IMPORT void ST_APIENTRY _mesa_UniformMatrix3fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
ST_EXPORT void ST_APIENTRY glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    _mesa_UniformMatrix3fvARB(location, count, transpose, value);
}

ST_IMPORT void ST_APIENTRY _mesa_UniformMatrix4fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
ST_EXPORT void ST_APIENTRY glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    _mesa_UniformMatrix4fvARB(location, count, transpose, value);
}

ST_IMPORT GLboolean ST_APIENTRY _mesa_UnmapBufferARB(GLenum target);
/* Extension OES_mapbuffer */
ST_EXPORT GLboolean ST_APIENTRY glUnmapBufferOES(GLenum target)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glUnmapBuffer(target=0x%x)", target);
            return GL_FALSE;
    } 

    return _mesa_UnmapBufferARB(target);
}

ST_IMPORT void ST_APIENTRY _mesa_UseProgramObjectARB(GLuint program);
ST_EXPORT void ST_APIENTRY glUseProgram(GLuint program)
{
    _mesa_UseProgramObjectARB(program);
}

ST_IMPORT void ST_APIENTRY _mesa_ValidateProgramARB(GLuint program);
ST_EXPORT void ST_APIENTRY glValidateProgram(GLuint program)
{
    _mesa_ValidateProgramARB(program);
}

ST_IMPORT void ST_APIENTRY _mesa_VertexAttrib1f(GLuint index, GLfloat x);
ST_EXPORT void ST_APIENTRY glVertexAttrib1f(GLuint index, GLfloat x)
{
    _mesa_VertexAttrib1f(index, x);
}

ST_IMPORT void ST_APIENTRY _mesa_VertexAttrib1fv(GLuint index, const GLfloat * v);
ST_EXPORT void ST_APIENTRY glVertexAttrib1fv(GLuint index, const GLfloat * v)
{
    _mesa_VertexAttrib1fv(index, v);
}

ST_IMPORT void ST_APIENTRY _mesa_VertexAttrib2f(GLuint index, GLfloat x, GLfloat y);
ST_EXPORT void ST_APIENTRY glVertexAttrib2f(GLuint index, GLfloat x, GLfloat y)
{
    _mesa_VertexAttrib2f(index, x, y);
}

ST_IMPORT void ST_APIENTRY _mesa_VertexAttrib2fv(GLuint index, const GLfloat * v);
ST_EXPORT void ST_APIENTRY glVertexAttrib2fv(GLuint index, const GLfloat * v)
{
    _mesa_VertexAttrib2fv(index, v);
}

ST_IMPORT void ST_APIENTRY _mesa_VertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z);
ST_EXPORT void ST_APIENTRY glVertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    _mesa_VertexAttrib3f(index, x, y, z);
}

ST_IMPORT void ST_APIENTRY _mesa_VertexAttrib3fv(GLuint index, const GLfloat * v);
ST_EXPORT void ST_APIENTRY glVertexAttrib3fv(GLuint index, const GLfloat * v)
{
    _mesa_VertexAttrib3fv(index, v);
}

ST_IMPORT void ST_APIENTRY _mesa_VertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
ST_EXPORT void ST_APIENTRY glVertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    _mesa_VertexAttrib4f(index, x, y, z, w);
}

ST_IMPORT void ST_APIENTRY _mesa_VertexAttrib4fv(GLuint index, const GLfloat * v);
ST_EXPORT void ST_APIENTRY glVertexAttrib4fv(GLuint index, const GLfloat * v)
{
    _mesa_VertexAttrib4fv(index, v);
}

ST_IMPORT void ST_APIENTRY _mesa_VertexAttribPointerARB(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer);
ST_EXPORT void ST_APIENTRY glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer)
{
    switch(size) {
        case 1:
        case 2:
        case 3:
        case 4:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glVertexAttribPointer(size=%d)", size);
            return;
    }
    switch(type) {
        case GL_BYTE:
        case GL_UNSIGNED_BYTE:
        case GL_SHORT:
        case GL_UNSIGNED_SHORT:
        case GL_FIXED:
        case GL_FLOAT:
            break;
        case GL_HALF_FLOAT_OES:
            break;
        case GL_UNSIGNED_INT_10_10_10_2_OES:
        case GL_INT_10_10_10_2_OES:
            if (size != 3 && size != 4) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glVertexAttribPointer(type=0x%x)", type);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glVertexAttribPointer(type=0x%x)", type);
            return;
    } 

    _mesa_VertexAttribPointerARB(index, size, type, normalized, stride, pointer);
}

ST_IMPORT void ST_APIENTRY _mesa_Viewport(GLint x, GLint y, GLsizei width, GLsizei height);
ST_EXPORT void ST_APIENTRY glViewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    _mesa_Viewport(x, y, width, height);
}

