/* DO NOT MODIFY - automatically generated by generate_builtins.py */
/*
 * Copyright © 2010 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include "main/core.h" /* for struct gl_shader */
#include "glsl_parser_extras.h"
#include "ir_reader.h"
#include "program.h"
#include "ast.h"

extern "C" struct gl_shader *
_mesa_new_shader(GLcontext *ctx, GLuint name, GLenum type);

gl_shader *
read_builtins(GLenum target, const char *protos, const char **functions, unsigned count)
{
   GLcontext fakeCtx;
   fakeCtx.API = API_OPENGL;
   gl_shader *sh = _mesa_new_shader(NULL, 0, target);
   struct _mesa_glsl_parse_state *st =
      new(sh) _mesa_glsl_parse_state(&fakeCtx, target, sh);

   st->language_version = 130;
   st->symbols->language_version = 130;
   st->ARB_texture_rectangle_enable = true;
   st->EXT_texture_array_enable = true;
   _mesa_glsl_initialize_types(st);

   sh->ir = new(sh) exec_list;
   sh->symbols = st->symbols;

   /* Read the IR containing the prototypes */
   _mesa_glsl_read_ir(st, sh->ir, protos, true);

   /* Read ALL the function bodies, telling the IR reader not to scan for
    * prototypes (we've already created them).  The IR reader will skip any
    * signature that does not already exist as a prototype.
    */
   for (unsigned i = 0; i < count; i++) {
      _mesa_glsl_read_ir(st, sh->ir, functions[i], false);

      if (st->error) {
         printf("error reading builtin: %.35s ...\n", functions[i]);
         printf("Info log:\n%s\n", st->info_log);
         talloc_free(sh);
         return NULL;
      }
   }

   reparent_ir(sh->ir, sh);
   delete st;

   return sh;
}

static const char *builtin_abs =
   "((function abs\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float abs (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 abs (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 abs (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 abs (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_acos =
   "((function acos\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float - (constant float (1.5707963))\n"
   "                                  (call asin ((var_ref x)))))))\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 - (constant float (1.5707963))\n"
   "                                 (call asin ((var_ref x)))))))\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 - (constant float (1.5707963))\n"
   "                                 (call asin ((var_ref x)))))))\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 - (constant float (1.5707963))\n"
   "                                 (call asin ((var_ref x)))))))\n"
   "))\n"
   ""
;
static const char *builtin_all =
   "((function all\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0))\n"
   "     ((return (expression bool && (swiz x (var_ref arg0))(swiz y (var_ref arg0))))))\n"
   "\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0))\n"
   "     ((return (expression bool && (expression bool && (swiz x (var_ref arg0))(swiz y (var_ref arg0))) (swiz z (var_ref arg0))))))\n"
   "\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0))\n"
   "     ((return (expression bool && (expression bool && (expression bool && (swiz x (var_ref arg0))(swiz y (var_ref arg0))) (swiz z (var_ref arg0))) (swiz w (var_ref arg0))))))\n"
   "))\n"
   ""
;
static const char *builtin_any =
   "((function any\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0))\n"
   "     ((return (expression bool any (var_ref arg0)))))\n"
   "\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0))\n"
   "     ((return (expression bool any (var_ref arg0)))))\n"
   "\n"
   "   (signature bool\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0))\n"
   "     ((return (expression bool any (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_asin =
   "((function asin\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float *\n"
   "	       (expression float sign (var_ref x))\n"
   "	       (expression float -\n"
   "		(expression float *\n"
   "		 (constant float (3.1415926))\n"
   "		 (constant float (0.5)))\n"
   "		(expression float *\n"
   "		 (expression float sqrt\n"
   "		  (expression float -\n"
   "		   (constant float (1.0))\n"
   "		   (expression float abs (var_ref x))))\n"
   "		 (expression float +\n"
   "		  (constant float (1.5707288))\n"
   "		  (expression float *\n"
   "		   (expression float abs (var_ref x))\n"
   "		   (expression float +\n"
   "		    (constant float (-0.2121144))\n"
   "		    (expression float *\n"
   "		     (constant float (0.0742610))\n"
   "		     (expression float abs (var_ref x))))))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 *\n"
   "	       (expression vec2 sign (var_ref x))\n"
   "	       (expression vec2 -\n"
   "		(expression float *\n"
   "		 (constant float (3.1415926))\n"
   "		 (constant float (0.5)))\n"
   "		(expression vec2 *\n"
   "		 (expression vec2 sqrt\n"
   "		  (expression vec2 -\n"
   "		   (constant float (1.0))\n"
   "		   (expression vec2 abs (var_ref x))))\n"
   "		 (expression vec2 +\n"
   "		  (constant float (1.5707288))\n"
   "		  (expression vec2 *\n"
   "		   (expression vec2 abs (var_ref x))\n"
   "		   (expression vec2 +\n"
   "		    (constant float (-0.2121144))\n"
   "		    (expression vec2 *\n"
   "		     (constant float (0.0742610))\n"
   "		     (expression vec2 abs (var_ref x))))))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 *\n"
   "	       (expression vec3 sign (var_ref x))\n"
   "	       (expression vec3 -\n"
   "		(expression float *\n"
   "		 (constant float (3.1415926))\n"
   "		 (constant float (0.5)))\n"
   "		(expression vec3 *\n"
   "		 (expression vec3 sqrt\n"
   "		  (expression vec3 -\n"
   "		   (constant float (1.0))\n"
   "		   (expression vec3 abs (var_ref x))))\n"
   "		 (expression vec3 +\n"
   "		  (constant float (1.5707288))\n"
   "		  (expression vec3 *\n"
   "		   (expression vec3 abs (var_ref x))\n"
   "		   (expression vec3 +\n"
   "		    (constant float (-0.2121144))\n"
   "		    (expression vec3 *\n"
   "		     (constant float (0.0742610))\n"
   "		     (expression vec3 abs (var_ref x))))))))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 *\n"
   "	       (expression vec4 sign (var_ref x))\n"
   "	       (expression vec4 -\n"
   "		(expression float *\n"
   "		 (constant float (3.1415926))\n"
   "		 (constant float (0.5)))\n"
   "		(expression vec4 *\n"
   "		 (expression vec4 sqrt\n"
   "		  (expression vec4 -\n"
   "		   (constant float (1.0))\n"
   "		   (expression vec4 abs (var_ref x))))\n"
   "		 (expression vec4 +\n"
   "		  (constant float (1.5707288))\n"
   "		  (expression vec4 *\n"
   "		   (expression vec4 abs (var_ref x))\n"
   "		   (expression vec4 +\n"
   "		    (constant float (-0.2121144))\n"
   "		    (expression vec4 *\n"
   "		     (constant float (0.0742610))\n"
   "		     (expression vec4 abs (var_ref x))))))))))))\n"
   "))\n"
   ""
;
static const char *builtin_atan =
   "((function atan\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (call asin ((expression float *\n"
   "			   (var_ref x)\n"
   "			   (expression float rsq\n"
   "			    (expression float +\n"
   "			     (expression float *\n"
   "			      (var_ref x)\n"
   "			      (var_ref x))\n"
   "			     (constant float (1.0))))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 y_over_x))\n"
   "     ((return (call asin ((expression vec2 *\n"
   "			   (var_ref y_over_x)\n"
   "			   (expression vec2 rsq\n"
   "			    (expression vec2 +\n"
   "			     (expression vec2 *\n"
   "			      (var_ref y_over_x)\n"
   "			      (var_ref y_over_x))\n"
   "			     (constant float (1.0))))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 y_over_x))\n"
   "     ((return (call asin ((expression vec3 *\n"
   "			   (var_ref y_over_x)\n"
   "			   (expression vec3 rsq\n"
   "			    (expression vec3 +\n"
   "			     (expression vec3 *\n"
   "			      (var_ref y_over_x)\n"
   "			      (var_ref y_over_x))\n"
   "			     (constant float (1.0))))))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 y_over_x))\n"
   "     ((return (call asin ((expression vec4 *\n"
   "			   (var_ref y_over_x)\n"
   "			   (expression vec4 rsq\n"
   "			    (expression vec4 +\n"
   "			     (expression vec4 *\n"
   "			      (var_ref y_over_x)\n"
   "			      (var_ref y_over_x))\n"
   "			     (constant float (1.0))))))))))\n"
   "\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in ) float y)\n"
   "      (declare (in ) float x)\n"
   "    )\n"
   "    (\n"
   "      (declare () float r)\n"
   "      (declare ( ) float abs_retval)\n"
   "      (assign (constant bool (1)) (x) (var_ref abs_retval)  (call abs ((var_ref x) ))\n"
   ")\n"
   "      (if (expression bool > (var_ref abs_retval) (constant float (0.000100)) ) (\n"
   "        (declare ( ) float atan_retval)\n"
   "        (assign (constant bool (1)) (x) (var_ref atan_retval)  (call atan ((expression float / (var_ref y) (var_ref x) ) ))\n"
   ")\n"
   "        (assign (constant bool (1)) (x) (var_ref r)  (var_ref atan_retval) )\n"
   "        (if (expression bool < (var_ref x) (constant float (0.000000)) ) (\n"
   "          (if (expression bool >= (var_ref y) (constant float (0.000000)) ) (\n"
   "            (declare ( ) float assignment_tmp)\n"
   "            (assign (constant bool (1)) (x) (var_ref assignment_tmp)  (expression float + (var_ref r) (constant float (3.141593)) ) )\n"
   "            (assign (constant bool (1)) (x) (var_ref r)  (var_ref assignment_tmp) )\n"
   "          )\n"
   "          (\n"
   "            (declare ( ) float assignment_tmp)\n"
   "            (assign (constant bool (1)) (x) (var_ref assignment_tmp)  (expression float - (var_ref r) (constant float (3.141593)) ) )\n"
   "            (assign (constant bool (1)) (x) (var_ref r)  (var_ref assignment_tmp) )\n"
   "          ))\n"
   "\n"
   "        )\n"
   "        (\n"
   "        ))\n"
   "\n"
   "      )\n"
   "      (\n"
   "        (declare () float sgn)\n"
   "        (assign (constant bool (1)) (x) (var_ref sgn) (expression float sign (var_ref y)))\n"
   "        (assign (constant bool (1)) (x) (var_ref r) (expression float * (var_ref sgn) (constant float (1.5707965))))\n"
   "      ))\n"
   "\n"
   "      (return (var_ref r) )\n"
   "    ))\n"
   "\n"
   "\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 y)\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 r)\n"
   "      (assign (constant bool (1)) (x) (var_ref r)\n"
   "	      (call atan ((swiz x (var_ref y))\n"
   "			  (swiz x (var_ref x)))))\n"
   "      (assign (constant bool (1)) (y) (var_ref r)\n"
   "	      (call atan ((swiz y (var_ref y))\n"
   "			  (swiz y (var_ref x)))))\n"
   "      (return (var_ref r))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 y)\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 r)\n"
   "      (assign (constant bool (1)) (x) (var_ref r)\n"
   "	      (call atan ((swiz x (var_ref y))\n"
   "			  (swiz x (var_ref x)))))\n"
   "      (assign (constant bool (1)) (y) (var_ref r)\n"
   "	      (call atan ((swiz y (var_ref y))\n"
   "			  (swiz y (var_ref x)))))\n"
   "      (assign (constant bool (1)) (z) (var_ref r)\n"
   "	      (call atan ((swiz z (var_ref y))\n"
   "			  (swiz z (var_ref x)))))\n"
   "      (return (var_ref r))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 y)\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 r)\n"
   "      (assign (constant bool (1)) (x) (var_ref r)\n"
   "	      (call atan ((swiz x (var_ref y))\n"
   "			  (swiz x (var_ref x)))))\n"
   "      (assign (constant bool (1)) (y) (var_ref r)\n"
   "	      (call atan ((swiz y (var_ref y))\n"
   "			  (swiz y (var_ref x)))))\n"
   "      (assign (constant bool (1)) (z) (var_ref r)\n"
   "	      (call atan ((swiz z (var_ref y))\n"
   "			  (swiz z (var_ref x)))))\n"
   "      (assign (constant bool (1)) (w) (var_ref r)\n"
   "	      (call atan ((swiz w (var_ref y))\n"
   "			  (swiz w (var_ref x)))))\n"
   "      (return (var_ref r)))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_ceil =
   "((function ceil\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float ceil (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 ceil (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 ceil (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 ceil (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_clamp =
   "((function clamp\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression float max (expression float min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1)\n"
   "       (declare (in) vec2 arg2))\n"
   "     ((return (expression vec2 max (expression vec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1)\n"
   "       (declare (in) vec3 arg2))\n"
   "     ((return (expression vec3 max (expression vec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1)\n"
   "       (declare (in) vec4 arg2))\n"
   "     ((return (expression vec4 max (expression vec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2  arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec2 max (expression vec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3  arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec3 max (expression vec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4  arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec4 max (expression vec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) int arg0)\n"
   "       (declare (in) int arg1)\n"
   "       (declare (in) int arg2))\n"
   "     ((return (expression int max (expression int min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1)\n"
   "       (declare (in) ivec2 arg2))\n"
   "     ((return (expression ivec2 max (expression ivec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1)\n"
   "       (declare (in) ivec3 arg2))\n"
   "     ((return (expression ivec3 max (expression ivec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1)\n"
   "       (declare (in) ivec4 arg2))\n"
   "     ((return (expression ivec4 max (expression ivec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) int arg1)\n"
   "       (declare (in) int arg2))\n"
   "     ((return (expression ivec2 max (expression ivec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) int arg1)\n"
   "       (declare (in) int arg2))\n"
   "     ((return (expression ivec3 max (expression ivec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) int arg1)\n"
   "       (declare (in) int arg2))\n"
   "     ((return (expression ivec4 max (expression ivec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uint\n"
   "     (parameters\n"
   "       (declare (in) uint arg0)\n"
   "       (declare (in) uint arg1)\n"
   "       (declare (in) uint arg2))\n"
   "     ((return (expression uint max (expression uint min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1)\n"
   "       (declare (in) uvec2 arg2))\n"
   "     ((return (expression uvec2 max (expression uvec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1)\n"
   "       (declare (in) uvec3 arg2))\n"
   "     ((return (expression uvec3 max (expression uvec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1)\n"
   "       (declare (in) uvec4 arg2))\n"
   "     ((return (expression uvec4 max (expression uvec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uint arg1)\n"
   "       (declare (in) uint arg2))\n"
   "     ((return (expression uvec2 max (expression uvec2 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uint arg1)\n"
   "       (declare (in) uint arg2))\n"
   "     ((return (expression uvec3 max (expression uvec3 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uint arg1)\n"
   "       (declare (in) uint arg2))\n"
   "     ((return (expression uvec4 max (expression uvec4 min (var_ref arg0) (var_ref arg2)) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_cos =
   "((function cos\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float angle))\n"
   "     ((return (expression float cos (var_ref angle)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 angle))\n"
   "     ((return (expression vec2 cos (var_ref angle)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 angle))\n"
   "     ((return (expression vec3 cos (var_ref angle)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 angle))\n"
   "     ((return (expression vec4 cos (var_ref angle)))))\n"
   "))\n"
   ""
;
static const char *builtin_cosh =
   "((function cosh\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float * (constant float (0.5))\n"
   "                (expression float +\n"
   "		  (expression float exp (var_ref x))\n"
   "		  (expression float exp (expression float neg (var_ref x))))))))\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 * (constant vec2 (0.5))\n"
   "                (expression vec2 +\n"
   "		  (expression vec2 exp (var_ref x))\n"
   "		  (expression vec2 exp (expression vec2 neg (var_ref x))))))))\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 * (constant vec3 (0.5))\n"
   "                (expression vec3 +\n"
   "		  (expression vec3 exp (var_ref x))\n"
   "		  (expression vec3 exp (expression vec3 neg (var_ref x))))))))\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 * (constant vec4 (0.5))\n"
   "                (expression vec4 +\n"
   "		  (expression vec4 exp (var_ref x))\n"
   "		  (expression vec4 exp (expression vec4 neg (var_ref x))))))))\n"
   "))\n"
   ""
;
static const char *builtin_cross =
   "((function cross\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression vec3 cross (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_dFdx =
   "((function dFdx\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float p))\n"
   "     ((return (expression float dFdx (var_ref p)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 p))\n"
   "     ((return (expression vec2 dFdx (var_ref p)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 p))\n"
   "     ((return (expression vec3 dFdx (var_ref p)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 p))\n"
   "     ((return (expression vec4 dFdx (var_ref p)))))\n"
   "))\n"
   ""
;
static const char *builtin_dFdy =
   "((function dFdy\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float p))\n"
   "     ((return (expression float dFdy (var_ref p)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 p))\n"
   "     ((return (expression vec2 dFdy (var_ref p)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 p))\n"
   "     ((return (expression vec3 dFdy (var_ref p)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 p))\n"
   "     ((return (expression vec4 dFdy (var_ref p)))))\n"
   "))\n"
   ""
;
static const char *builtin_degrees =
   "((function degrees\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float * (var_ref arg0) (constant float (57.295780))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 * (var_ref arg0) (constant float (57.295780))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 * (var_ref arg0) (constant float (57.295780))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 * (var_ref arg0) (constant float (57.295780))))))\n"
   "))\n"
   ""
;
static const char *builtin_distance =
   "((function distance\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float p0)\n"
   "       (declare (in) float p1))\n"
   "     ((return (expression float abs (expression float - (var_ref p0) (var_ref p1))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec2 p0)\n"
   "       (declare (in) vec2 p1))\n"
   "     ((declare () vec2 p)\n"
   "      (assign (constant bool (1)) (xy) (var_ref p) (expression vec2 - (var_ref p0) (var_ref p1)))\n"
   "      (return (expression float sqrt (expression float dot (var_ref p) (var_ref p))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec3 p0)\n"
   "       (declare (in) vec3 p1))\n"
   "     ((declare () vec3 p)\n"
   "      (assign (constant bool (1)) (xyz) (var_ref p) (expression vec3 - (var_ref p0) (var_ref p1)))\n"
   "      (return (expression float sqrt (expression float dot (var_ref p) (var_ref p))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec4 p0)\n"
   "       (declare (in) vec4 p1))\n"
   "     ((declare () vec4 p)\n"
   "      (assign (constant bool (1)) (xyzw) (var_ref p) (expression vec4 - (var_ref p0) (var_ref p1)))\n"
   "      (return (expression float sqrt (expression float dot (var_ref p) (var_ref p))))))\n"
   "))\n"
   ""
;
static const char *builtin_dot =
   "((function dot\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float * (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression float dot (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression float dot (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression float dot (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_equal =
   "((function equal\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0)\n"
   "       (declare (in) bvec2 arg1))\n"
   "     ((return (expression bvec2 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0)\n"
   "       (declare (in) bvec3 arg1))\n"
   "     ((return (expression bvec3 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0)\n"
   "       (declare (in) bvec4 arg1))\n"
   "     ((return (expression bvec4 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 == (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 == (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_exp =
   "((function exp\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float exp (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 exp (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 exp (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 exp (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_exp2 =
   "((function exp2\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float exp2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 exp2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 exp2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 exp2 (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_faceforward =
   "((function faceforward\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float N)\n"
   "       (declare (in) float I)\n"
   "       (declare (in) float Nref))\n"
   "     ((if (expression bool < (expression float * (var_ref Nref) (var_ref I)) (constant float (0)))\n"
   "          ((return (var_ref N)))\n"
   "	  ((return (expression float neg (var_ref N)))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 N)\n"
   "       (declare (in) vec2 I)\n"
   "       (declare (in) vec2 Nref))\n"
   "     ((if (expression bool < (expression float dot (var_ref Nref) (var_ref I)) (constant float (0)))\n"
   "          ((return (var_ref N)))\n"
   "	  ((return (expression vec2 neg (var_ref N)))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 N)\n"
   "       (declare (in) vec3 I)\n"
   "       (declare (in) vec3 Nref))\n"
   "     ((if (expression bool < (expression float dot (var_ref Nref) (var_ref I)) (constant float (0)))\n"
   "          ((return (var_ref N)))\n"
   "	  ((return (expression vec3 neg (var_ref N)))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 N)\n"
   "       (declare (in) vec4 I)\n"
   "       (declare (in) vec4 Nref))\n"
   "     ((if (expression bool < (expression float dot (var_ref Nref) (var_ref I)) (constant float (0)))\n"
   "          ((return (var_ref N)))\n"
   "	  ((return (expression vec4 neg (var_ref N)))))))\n"
   "))\n"
   ""
;
static const char *builtin_floor =
   "((function floor\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float floor (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 floor (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 floor (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 floor (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_fract =
   "((function fract\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float fract (var_ref x)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 fract (var_ref x)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 fract (var_ref x)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 fract (var_ref x)))))\n"
   "))\n"
   "\n"
   ""
;
static const char *builtin_ftransform =
   "((declare (uniform) mat4 gl_ModelViewProjectionMatrix)\n"
   " (declare (in) vec4 gl_Vertex)\n"
   " (function ftransform\n"
   "   (signature vec4\n"
   "     (parameters)\n"
   "    ((return (expression vec4 *\n"
   "	      (var_ref gl_ModelViewProjectionMatrix)\n"
   "	      (var_ref gl_Vertex)))))\n"
   "))\n"
   ""
;
static const char *builtin_fwidth =
   "((function fwidth\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float p))\n"
   "     ((return (expression float +\n"
   "                (expression float abs (expression float dFdx (var_ref p)))\n"
   "                (expression float abs (expression float dFdy (var_ref p)))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 p))\n"
   "     ((return (expression vec2 +\n"
   "                (expression vec2 abs (expression vec2 dFdx (var_ref p)))\n"
   "                (expression vec2 abs (expression vec2 dFdy (var_ref p)))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 p))\n"
   "     ((return (expression vec3 +\n"
   "                (expression vec3 abs (expression vec3 dFdx (var_ref p)))\n"
   "                (expression vec3 abs (expression vec3 dFdy (var_ref p)))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 p))\n"
   "     ((return (expression vec4 +\n"
   "                (expression vec4 abs (expression vec4 dFdx (var_ref p)))\n"
   "                (expression vec4 abs (expression vec4 dFdy (var_ref p)))))))\n"
   "))\n"
   ""
;
static const char *builtin_greaterThan =
   "((function greaterThan\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 > (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 > (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_greaterThanEqual =
   "((function greaterThanEqual\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 >= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 >= (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_inversesqrt =
   "((function inversesqrt\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float rsq (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 rsq (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 rsq (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 rsq (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_length =
   "((function length\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float abs (var_ref arg0)))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression float sqrt (expression float dot (var_ref arg0) (var_ref arg0))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression float sqrt (expression float dot (var_ref arg0) (var_ref arg0))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression float sqrt (expression float dot (var_ref arg0) (var_ref arg0))))))\n"
   "))\n"
   ""
;
static const char *builtin_lessThan =
   "((function lessThan\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 < (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 < (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_lessThanEqual =
   "((function lessThanEqual\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 <= (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 <= (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_log =
   "((function log\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float log (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 log (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 log (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 log (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_log2 =
   "((function log2\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float log2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 log2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 log2 (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 log2 (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_matrixCompMult =
   "((function matrixCompMult\n"
   "   (signature mat2\n"
   "     (parameters\n"
   "       (declare (in) mat2 x)\n"
   "       (declare (in) mat2 y))\n"
   "     ((declare () mat2 z)\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref z) (constant int (0)))  (expression vec2 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref z) (constant int (1)))  (expression vec2 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat3\n"
   "     (parameters\n"
   "       (declare (in) mat3 x)\n"
   "       (declare (in) mat3 y))\n"
   "     ((declare () mat3 z)\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref z) (constant int (0)))  (expression vec3 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref z) (constant int (1)))  (expression vec3 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref z) (constant int (2)))  (expression vec3 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat4\n"
   "     (parameters\n"
   "       (declare (in) mat4 x)\n"
   "       (declare (in) mat4 y))\n"
   "     ((declare () mat4 z)\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref z) (constant int (0)))  (expression vec4 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref z) (constant int (1)))  (expression vec4 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref z) (constant int (2)))  (expression vec4 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref z) (constant int (3)))  (expression vec4 * (array_ref (var_ref x) (constant int (3))) (array_ref (var_ref y) (constant int (3)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat2x3\n"
   "     (parameters\n"
   "       (declare (in) mat2x3 x)\n"
   "       (declare (in) mat2x3 y))\n"
   "     ((declare () mat2x3 z)\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref z) (constant int (0)))  (expression vec3 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref z) (constant int (1)))  (expression vec3 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat3x2\n"
   "     (parameters\n"
   "       (declare (in) mat3x2 x)\n"
   "       (declare (in) mat3x2 y))\n"
   "     ((declare () mat3x2 z)\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref z) (constant int (0)))  (expression vec2 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref z) (constant int (1)))  (expression vec2 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref z) (constant int (2)))  (expression vec2 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat2x4\n"
   "     (parameters\n"
   "       (declare (in) mat2x4 x)\n"
   "       (declare (in) mat2x4 y))\n"
   "     ((declare () mat2x4 z)\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref z) (constant int (0)))  (expression vec4 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref z) (constant int (1)))  (expression vec4 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat4x2\n"
   "     (parameters\n"
   "       (declare (in) mat4x2 x)\n"
   "       (declare (in) mat4x2 y))\n"
   "     ((declare () mat4x2 z)\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref z) (constant int (0)))  (expression vec2 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref z) (constant int (1)))  (expression vec2 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref z) (constant int (2)))  (expression vec2 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref z) (constant int (3)))  (expression vec2 * (array_ref (var_ref x) (constant int (3))) (array_ref (var_ref y) (constant int (3)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat3x4\n"
   "     (parameters\n"
   "       (declare (in) mat3x4 x)\n"
   "       (declare (in) mat3x4 y))\n"
   "     ((declare () mat3x4 z)\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref z) (constant int (0)))  (expression vec4 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref z) (constant int (1)))  (expression vec4 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref z) (constant int (2)))  (expression vec4 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "(return (var_ref z))))\n"
   "\n"
   "   (signature mat4x3\n"
   "     (parameters\n"
   "       (declare (in) mat4x3 x)\n"
   "       (declare (in) mat4x3 y))\n"
   "     ((declare () mat4x3 z)\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref z) (constant int (0)))  (expression vec3 * (array_ref (var_ref x) (constant int (0))) (array_ref (var_ref y) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref z) (constant int (1)))  (expression vec3 * (array_ref (var_ref x) (constant int (1))) (array_ref (var_ref y) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref z) (constant int (2)))  (expression vec3 * (array_ref (var_ref x) (constant int (2))) (array_ref (var_ref y) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref z) (constant int (3)))  (expression vec3 * (array_ref (var_ref x) (constant int (3))) (array_ref (var_ref y) (constant int (3)))))\n"
   "(return (var_ref z))))\n"
   "))\n"
   ""
;
static const char *builtin_max =
   "((function max\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression vec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression vec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression vec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) int arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression int max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression ivec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression ivec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression ivec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uint\n"
   "     (parameters\n"
   "       (declare (in) uint arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uint max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression uvec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression uvec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression uvec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec2 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec3 max (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec4 max (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_min =
   "((function min\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression vec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression vec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression vec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) int arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression int min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression ivec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression ivec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression ivec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4  arg0)\n"
   "       (declare (in) int arg1))\n"
   "     ((return (expression ivec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uint\n"
   "     (parameters\n"
   "       (declare (in) uint arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uint min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression uvec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression uvec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression uvec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec2 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec3 min (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4  arg0)\n"
   "       (declare (in) uint arg1))\n"
   "     ((return (expression uvec4 min (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_mix =
   "((function mix\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression float + (expression float * (var_ref arg0) (expression float - (constant float (1.000000)) (var_ref arg2))) (expression float * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1)\n"
   "       (declare (in) vec2 arg2))\n"
   "     ((return (expression vec2 + (expression vec2 * (var_ref arg0) (expression vec2 - (constant float (1.000000)) (var_ref arg2))) (expression vec2 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1)\n"
   "       (declare (in) vec3 arg2))\n"
   "     ((return (expression vec3 + (expression vec3 * (var_ref arg0) (expression vec3 - (constant float (1.000000)) (var_ref arg2))) (expression vec3 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1)\n"
   "       (declare (in) vec4 arg2))\n"
   "     ((return (expression vec4 + (expression vec4 * (var_ref arg0) (expression vec4 - (constant float (1.000000)) (var_ref arg2))) (expression vec4 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec2 + (expression vec2 * (var_ref arg0) (expression float - (constant float (1.000000)) (var_ref arg2))) (expression vec2 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec3 + (expression vec3 * (var_ref arg0) (expression float - (constant float (1.000000)) (var_ref arg2))) (expression vec3 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1)\n"
   "       (declare (in) float arg2))\n"
   "     ((return (expression vec4 + (expression vec4 * (var_ref arg0) (expression float - (constant float (1.000000)) (var_ref arg2))) (expression vec4 * (var_ref arg1) (var_ref arg2))))))\n"
   "\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float v1)\n"
   "       (declare (in) float v2)\n"
   "       (declare (in) bool  a))\n"
   "     ((assign (var_ref a) (var_ref v1) (var_ref v2))\n"
   "      (return (var_ref v1))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 v1)\n"
   "       (declare (in) vec2 v2)\n"
   "       (declare (in) bvec2 a))\n"
   "     ((assign (swiz x (var_ref a)) (x) (var_ref v1) (swiz x (var_ref v2)))\n"
   "      (assign (swiz y (var_ref a)) (y) (var_ref v1) (swiz y (var_ref v2)))\n"
   "      (return (var_ref v1))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 v1)\n"
   "       (declare (in) vec3 v2)\n"
   "       (declare (in) bvec3 a))\n"
   "     ((assign (swiz x (var_ref a)) (x) (var_ref v1) (swiz x (var_ref v2)))\n"
   "      (assign (swiz y (var_ref a)) (y) (var_ref v1) (swiz y (var_ref v2)))\n"
   "      (assign (swiz z (var_ref a)) (z) (var_ref v1) (swiz z (var_ref v2)))\n"
   "      (return (var_ref v1))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 v1)\n"
   "       (declare (in) vec4 v2)\n"
   "       (declare (in) bvec4 a))\n"
   "     ((assign (swiz x (var_ref a)) (x) (var_ref v1) (swiz x (var_ref v2)))\n"
   "      (assign (swiz y (var_ref a)) (y) (var_ref v1) (swiz y (var_ref v2)))\n"
   "      (assign (swiz z (var_ref a)) (z) (var_ref v1) (swiz z (var_ref v2)))\n"
   "      (assign (swiz w (var_ref a)) (w) (var_ref v1) (swiz w (var_ref v2)))\n"
   "      (return (var_ref v1))))\n"
   "))\n"
   ""
;
static const char *builtin_mod =
   "((function mod\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression vec2 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression vec3 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression vec4 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec2 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec3 % (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4  arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression vec4 % (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_noise1 =
   "((function noise1\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float noise (var_ref x)))))\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression float noise (var_ref x)))))\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression float noise (var_ref x)))))\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression float noise (var_ref x)))))\n"
   "))\n"
   ""
;
static const char *builtin_noise2 =
   "((function noise2\n"
   "  (signature vec2\n"
   "    (parameters (declare (in) vec4 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () vec2 t)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref b) (expression float noise (expression vec4 + (var_ref p) (constant vec4 (601.0 313.0 29.0 277.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (swiz xx (var_ref a)))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (swiz xx (var_ref b)))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec2\n"
   "    (parameters (declare (in) vec3 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () vec2 t)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref b) (expression float noise (expression vec3 + (var_ref p) (constant vec3 (601.0 313.0 29.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (swiz xx (var_ref a)))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (swiz xx (var_ref b)))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in ) vec2 p)\n"
   "    )\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () vec2 t)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref b) (expression float noise (expression vec2 + (var_ref p) (constant vec2 (601.0 313.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (swiz xx (var_ref a)))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (swiz xx (var_ref b)))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in ) float p)\n"
   "    )\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () vec2 t)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref b) (expression float noise (expression float + (var_ref p) (constant float (601.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (swiz xx (var_ref a)))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (swiz xx (var_ref b)))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "))\n"
   ""
;
static const char *builtin_noise3 =
   "((function noise3\n"
   "  (signature vec3\n"
   "    (parameters (declare (in) vec4 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () float c)\n"
   "      (declare () vec3 t)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref b) (expression float noise (expression vec4 + (var_ref p) (constant vec4 (601.0 313.0 29.0 277.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref c) (expression float noise (expression vec4 + (var_ref p) (constant vec4 (1559.0 113.0 1861.0 797.0)))))\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (swiz xxx (var_ref a)))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (swiz xxx (var_ref b)))\n"
   "      (assign (constant bool (1)) (z) (var_ref t) (swiz xxx (var_ref c)))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec3\n"
   "    (parameters (declare (in) vec3 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () float c)\n"
   "      (declare () vec3 t)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref b) (expression float noise (expression vec3 + (var_ref p) (constant vec3 (601.0 313.0 29.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref c) (expression float noise (expression vec3 + (var_ref p) (constant vec3 (1559.0 113.0 1861.0)))))\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (swiz xxx (var_ref a)))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (swiz xxx (var_ref b)))\n"
   "      (assign (constant bool (1)) (z) (var_ref t) (swiz xxx (var_ref c)))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec3\n"
   "    (parameters (declare (in) vec2 p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () float c)\n"
   "      (declare () vec3 t)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref b) (expression float noise (expression vec2 + (var_ref p) (constant vec2 (601.0 313.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref c) (expression float noise (expression vec2 + (var_ref p) (constant vec2 (1559.0 113.0)))))\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (swiz xxx (var_ref a)))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (swiz xxx (var_ref b)))\n"
   "      (assign (constant bool (1)) (z) (var_ref t) (swiz xxx (var_ref c)))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "\n"
   "  (signature vec3\n"
   "    (parameters (declare (in) float p))\n"
   "    (\n"
   "      (declare () float a)\n"
   "      (declare () float b)\n"
   "      (declare () float c)\n"
   "      (declare () vec3 t)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref a) (expression float noise (var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref b) (expression float noise (expression float + (var_ref p) (constant float (601.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref c) (expression float noise (expression float + (var_ref p) (constant float (1559.0)))))\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (swiz xxx (var_ref a)))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (swiz xxx (var_ref b)))\n"
   "      (assign (constant bool (1)) (z) (var_ref t) (swiz xxx (var_ref c)))\n"
   "      (return (var_ref t))\n"
   "    ))\n"
   "))\n"
   ""
;
static const char *builtin_noise4 =
   "((function noise4\n"
   "  (signature vec4\n"
   "    (parameters (declare (in) vec4 p))\n"
   "    (\n"
   "      (declare () float _x)\n"
   "      (declare () float _y)\n"
   "      (declare () float _z)\n"
   "      (declare () float _w)\n"
   "      (declare () vec4 _r)\n"
   "\n"
   "      (declare () vec4 _p)\n"
   "      (assign (constant bool (1)) (xyzw) (var_ref _p) (expression vec4 + (var_ref p) (constant vec4 (1559.0 113.0 1861.0 797.0))) )\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref _x) (expression float noise(var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref _y) (expression float noise(expression vec4 + (var_ref p) (constant vec4 (601.0 313.0 29.0 277.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref _z) (expression float noise(var_ref _p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref _w) (expression float noise(expression vec4 + (var_ref _p) (constant vec4 (601.0 313.0 29.0 277.0)))))\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref _r) (swiz xxxx (var_ref _x)))\n"
   "      (assign (constant bool (1)) (y) (var_ref _r) (swiz xxxx (var_ref _y)))\n"
   "      (assign (constant bool (1)) (z) (var_ref _r) (swiz xxxx (var_ref _z)))\n"
   "      (assign (constant bool (1)) (w) (var_ref _r) (swiz xxxx (var_ref _w)))\n"
   "      (return (var_ref _r))\n"
   "    ))\n"
   "\n"
   "  (signature vec4\n"
   "    (parameters (declare (in) vec3 p))\n"
   "    (\n"
   "      (declare () float _x)\n"
   "      (declare () float _y)\n"
   "      (declare () float _z)\n"
   "      (declare () float _w)\n"
   "      (declare () vec4 _r)\n"
   "\n"
   "      (declare () vec3 _p)\n"
   "      (assign (constant bool (1)) (xyz) (var_ref _p) (expression vec3 + (var_ref p) (constant vec3 (1559.0 113.0 1861.0))) )\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref _x) (expression float noise(var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref _y) (expression float noise(expression vec3 + (var_ref p) (constant vec3 (601.0 313.0 29.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref _z) (expression float noise(var_ref _p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref _w) (expression float noise(expression vec3 + (var_ref _p) (constant vec3 (601.0 313.0 29.0)))))\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref _r) (swiz xxxx (var_ref _x)))\n"
   "      (assign (constant bool (1)) (y) (var_ref _r) (swiz xxxx (var_ref _y)))\n"
   "      (assign (constant bool (1)) (z) (var_ref _r) (swiz xxxx (var_ref _z)))\n"
   "      (assign (constant bool (1)) (w) (var_ref _r) (swiz xxxx (var_ref _w)))\n"
   "      (return (var_ref _r))\n"
   "    ))\n"
   "\n"
   "  (signature vec4\n"
   "    (parameters (declare (in) vec2 p))\n"
   "    (\n"
   "      (declare () float _x)\n"
   "      (declare () float _y)\n"
   "      (declare () float _z)\n"
   "      (declare () float _w)\n"
   "      (declare () vec4 _r)\n"
   "\n"
   "      (declare () vec2 _p)\n"
   "      (assign (constant bool (1)) (xy) (var_ref _p) (expression vec2 + (var_ref p) (constant vec2 (1559.0 113.0))) )\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref _x) (expression float noise(var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref _y) (expression float noise(expression vec2 + (var_ref p) (constant vec2 (601.0 313.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref _z) (expression float noise(var_ref _p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref _w) (expression float noise(expression vec2 + (var_ref _p) (constant vec2 (601.0 313.0)))))\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref _r) (swiz xxxx (var_ref _x)))\n"
   "      (assign (constant bool (1)) (y) (var_ref _r) (swiz xxxx (var_ref _y)))\n"
   "      (assign (constant bool (1)) (z) (var_ref _r) (swiz xxxx (var_ref _z)))\n"
   "      (assign (constant bool (1)) (w) (var_ref _r) (swiz xxxx (var_ref _w)))\n"
   "      (return (var_ref _r))\n"
   "    ))\n"
   "\n"
   "  (signature vec4\n"
   "    (parameters (declare (in) float p))\n"
   "    (\n"
   "      (declare () float _x)\n"
   "      (declare () float _y)\n"
   "      (declare () float _z)\n"
   "      (declare () float _w)\n"
   "      (declare () vec4 _r)\n"
   "\n"
   "      (declare () float _p)\n"
   "      (assign (constant bool (1)) (xy) (var_ref _p) (expression float + (var_ref p) (constant float (1559.0))) )\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref _x) (expression float noise(var_ref p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref _y) (expression float noise(expression float + (var_ref p) (constant float (601.0 313.0 29.0 277.0)))))\n"
   "      (assign (constant bool (1)) (x) (var_ref _z) (expression float noise(var_ref _p)))\n"
   "      (assign (constant bool (1)) (x) (var_ref _w) (expression float noise(expression float + (var_ref _p) (constant float (601.0 313.0 29.0 277.0)))))\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref _r) (swiz xxxx (var_ref _x)))\n"
   "      (assign (constant bool (1)) (y) (var_ref _r) (swiz xxxx (var_ref _y)))\n"
   "      (assign (constant bool (1)) (z) (var_ref _r) (swiz xxxx (var_ref _z)))\n"
   "      (assign (constant bool (1)) (w) (var_ref _r) (swiz xxxx (var_ref _w)))\n"
   "      (return (var_ref _r))\n"
   "    ))\n"
   "))\n"
   ""
;
static const char *builtin_normalize =
   "((function normalize\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float sign (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 * (var_ref arg0) (expression float rsq (expression float dot (var_ref arg0) (var_ref arg0)))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 * (var_ref arg0) (expression float rsq (expression float dot (var_ref arg0) (var_ref arg0)))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 * (var_ref arg0) (expression float rsq (expression float dot (var_ref arg0) (var_ref arg0)))))))\n"
   "))\n"
   ""
;
static const char *builtin_not =
   "((function not\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0))\n"
   "     ((return (expression bvec2 ! (var_ref arg0)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0))\n"
   "     ((return (expression bvec3 ! (var_ref arg0)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0))\n"
   "     ((return (expression bvec4 ! (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_notEqual =
   "((function notEqual\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression bvec2 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression bvec3 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression bvec4 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) bvec2 arg0)\n"
   "       (declare (in) bvec2 arg1))\n"
   "     ((return (expression bvec2 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) bvec3 arg0)\n"
   "       (declare (in) bvec3 arg1))\n"
   "     ((return (expression bvec3 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) bvec4 arg0)\n"
   "       (declare (in) bvec4 arg1))\n"
   "     ((return (expression bvec4 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 arg0)\n"
   "       (declare (in) ivec2 arg1))\n"
   "     ((return (expression bvec2 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 arg0)\n"
   "       (declare (in) ivec3 arg1))\n"
   "     ((return (expression bvec3 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 arg0)\n"
   "       (declare (in) ivec4 arg1))\n"
   "     ((return (expression bvec4 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec2\n"
   "     (parameters\n"
   "       (declare (in) uvec2 arg0)\n"
   "       (declare (in) uvec2 arg1))\n"
   "     ((return (expression bvec2 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec3\n"
   "     (parameters\n"
   "       (declare (in) uvec3 arg0)\n"
   "       (declare (in) uvec3 arg1))\n"
   "     ((return (expression bvec3 != (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature bvec4\n"
   "     (parameters\n"
   "       (declare (in) uvec4 arg0)\n"
   "       (declare (in) uvec4 arg1))\n"
   "     ((return (expression bvec4 != (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_outerProduct =
   "((function outerProduct\n"
   "   (signature mat2\n"
   "     (parameters\n"
   "       (declare (in) vec2 u)\n"
   "       (declare (in) vec2 v))\n"
   "     ((declare () mat2 m)\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref m) (constant int (0))) (expression vec2 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref m) (constant int (1))) (expression vec2 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat2x3\n"
   "     (parameters\n"
   "       (declare (in) vec3 u)\n"
   "       (declare (in) vec2 v))\n"
   "     ((declare () mat2x3 m)\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref m) (constant int (0))) (expression vec3 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref m) (constant int (1))) (expression vec3 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat2x4\n"
   "     (parameters\n"
   "       (declare (in) vec4 u)\n"
   "       (declare (in) vec2 v))\n"
   "     ((declare () mat2x4 m)\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref m) (constant int (0))) (expression vec4 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref m) (constant int (1))) (expression vec4 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat3x2\n"
   "     (parameters\n"
   "       (declare (in) vec2 u)\n"
   "       (declare (in) vec3 v))\n"
   "     ((declare () mat3x2 m)\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref m) (constant int (0))) (expression vec2 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref m) (constant int (1))) (expression vec2 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref m) (constant int (2))) (expression vec2 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (return (var_ref m))\n"
   " ))\n"
   "\n"
   "   (signature mat3\n"
   "     (parameters\n"
   "       (declare (in) vec3 u)\n"
   "       (declare (in) vec3 v))\n"
   "     ((declare () mat3 m)\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref m) (constant int (0))) (expression vec3 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref m) (constant int (1))) (expression vec3 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref m) (constant int (2))) (expression vec3 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat3x4\n"
   "     (parameters\n"
   "       (declare (in) vec4 u)\n"
   "       (declare (in) vec3 v))\n"
   "     ((declare () mat3x4 m)\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref m) (constant int (0))) (expression vec4 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref m) (constant int (1))) (expression vec4 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref m) (constant int (2))) (expression vec4 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat4x2\n"
   "     (parameters\n"
   "       (declare (in) vec2 u)\n"
   "       (declare (in) vec4 v))\n"
   "     ((declare () mat4x2 m)\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref m) (constant int (0))) (expression vec2 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref m) (constant int (1))) (expression vec2 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref m) (constant int (2))) (expression vec2 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (assign (constant bool (1)) (xy) (array_ref (var_ref m) (constant int (3))) (expression vec2 * (var_ref u) (swiz w (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat4x3\n"
   "     (parameters\n"
   "       (declare (in) vec3 u)\n"
   "       (declare (in) vec4 v))\n"
   "     ((declare () mat4x3 m)\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref m) (constant int (0))) (expression vec3 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref m) (constant int (1))) (expression vec3 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref m) (constant int (2))) (expression vec3 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyz) (array_ref (var_ref m) (constant int (3))) (expression vec3 * (var_ref u) (swiz w (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "\n"
   "   (signature mat4\n"
   "     (parameters\n"
   "       (declare (in) vec4 u)\n"
   "       (declare (in) vec4 v))\n"
   "     ((declare () mat4 m)\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref m) (constant int (0))) (expression vec4 * (var_ref u) (swiz x (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref m) (constant int (1))) (expression vec4 * (var_ref u) (swiz y (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref m) (constant int (2))) (expression vec4 * (var_ref u) (swiz z (var_ref v))))\n"
   "      (assign (constant bool (1)) (xyzw) (array_ref (var_ref m) (constant int (3))) (expression vec4 * (var_ref u) (swiz w (var_ref v))))\n"
   "      (return (var_ref m))))\n"
   "))\n"
   ""
;
static const char *builtin_pow =
   "((function pow\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0)\n"
   "       (declare (in) float arg1))\n"
   "     ((return (expression float pow (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0)\n"
   "       (declare (in) vec2 arg1))\n"
   "     ((return (expression vec2 pow (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0)\n"
   "       (declare (in) vec3 arg1))\n"
   "     ((return (expression vec3 pow (var_ref arg0) (var_ref arg1)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0)\n"
   "       (declare (in) vec4 arg1))\n"
   "     ((return (expression vec4 pow (var_ref arg0) (var_ref arg1)))))\n"
   "))\n"
   ""
;
static const char *builtin_radians =
   "((function radians\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float * (var_ref arg0) (constant float (0.017453))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 * (var_ref arg0) (constant float (0.017453))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 * (var_ref arg0) (constant float (0.017453))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 * (var_ref arg0) (constant float (0.017453))))))\n"
   "))\n"
   ""
;
static const char *builtin_reflect =
   "((function reflect\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float i)\n"
   "       (declare (in) float n))\n"
   "     ((return (expression float -\n"
   "	       (var_ref i)\n"
   "	       (expression float *\n"
   "		(constant float (2.0))\n"
   "		(expression float *\n"
   "		 (expression float *\n"
   "		  (var_ref n)\n"
   "		  (var_ref i))\n"
   "		 (var_ref n)))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 i)\n"
   "       (declare (in) vec2 n))\n"
   "     ((return (expression vec2 -\n"
   "	       (var_ref i)\n"
   "	       (expression vec2 *\n"
   "		(constant float (2.0))\n"
   "		(expression vec2 *\n"
   "		 (expression float dot\n"
   "		  (var_ref n)\n"
   "		  (var_ref i))\n"
   "		 (var_ref n)))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 i)\n"
   "       (declare (in) vec3 n))\n"
   "     ((return (expression vec3 -\n"
   "	       (var_ref i)\n"
   "	       (expression vec3 *\n"
   "		(constant float (2.0))\n"
   "		(expression vec3 *\n"
   "		 (expression float dot\n"
   "		  (var_ref n)\n"
   "		  (var_ref i))\n"
   "		 (var_ref n)))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 i)\n"
   "       (declare (in) vec4 n))\n"
   "     ((return (expression vec4 -\n"
   "	       (var_ref i)\n"
   "	       (expression vec4 *\n"
   "		(constant float (2.0))\n"
   "		(expression vec4 *\n"
   "		 (expression float dot\n"
   "		  (var_ref n)\n"
   "		  (var_ref i))\n"
   "		 (var_ref n)))))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_refract =
   "((function refract\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float i)\n"
   "       (declare (in) float n)\n"
   "       (declare (in) float eta))\n"
   "     ((declare () float k)\n"
   "      (assign (constant bool (1)) (x) (var_ref k)\n"
   "              (expression float - (constant float (1.0))\n"
   "	        (expression float * (var_ref eta)\n"
   "	          (expression float * (var_ref eta)\n"
   "		    (expression float - (constant float (1.0))\n"
   "		      (expression float * \n"
   "		        (expression float * (var_ref n) (var_ref i))\n"
   "		        (expression float * (var_ref n) (var_ref i))))))))\n"
   "      (if (expression bool < (var_ref k) (constant float (0.0)))\n"
   "          ((return (constant float (0.0))))\n"
   "	  ((return (expression float -\n"
   "	             (expression float * (var_ref eta) (var_ref i))\n"
   "		     (expression float *\n"
   "		       (expression float +\n"
   "		         (expression float * (var_ref eta)\n"
   "			   (expression float * (var_ref n) (var_ref i)))\n"
   "		         (expression float sqrt (var_ref k)))\n"
   "		       (var_ref n))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 i)\n"
   "       (declare (in) vec2 n)\n"
   "       (declare (in) float eta))\n"
   "     ((declare () float k)\n"
   "      (assign (constant bool (1)) (x) (var_ref k)\n"
   "              (expression float - (constant float (1.0))\n"
   "	        (expression float * (var_ref eta)\n"
   "	          (expression float * (var_ref eta)\n"
   "		    (expression float - (constant float (1.0))\n"
   "		      (expression float * \n"
   "		        (expression float dot (var_ref n) (var_ref i))\n"
   "		        (expression float dot (var_ref n) (var_ref i))))))))\n"
   "      (if (expression bool < (var_ref k) (constant float (0.0)))\n"
   "          ((return (constant vec2 (0.0 0.0))))\n"
   "	  ((return (expression vec2 -\n"
   "	             (expression vec2 * (var_ref eta) (var_ref i))\n"
   "		     (expression vec2 *\n"
   "		       (expression float +\n"
   "		         (expression float * (var_ref eta)\n"
   "			   (expression float dot (var_ref n) (var_ref i)))\n"
   "		         (expression float sqrt (var_ref k)))\n"
   "		       (var_ref n))))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 i)\n"
   "       (declare (in) vec3 n)\n"
   "       (declare (in) float eta))\n"
   "     ((declare () float k)\n"
   "      (assign (constant bool (1)) (x) (var_ref k)\n"
   "              (expression float - (constant float (1.0))\n"
   "	        (expression float * (var_ref eta)\n"
   "	          (expression float * (var_ref eta)\n"
   "		    (expression float - (constant float (1.0))\n"
   "		      (expression float * \n"
   "		        (expression float dot (var_ref n) (var_ref i))\n"
   "		        (expression float dot (var_ref n) (var_ref i))))))))\n"
   "      (if (expression bool < (var_ref k) (constant float (0.0)))\n"
   "          ((return (constant vec3 (0.0 0.0 0.0))))\n"
   "	  ((return (expression vec3 -\n"
   "	             (expression vec3 * (var_ref eta) (var_ref i))\n"
   "		     (expression vec3 *\n"
   "		       (expression float +\n"
   "		         (expression float * (var_ref eta)\n"
   "			   (expression float dot (var_ref n) (var_ref i)))\n"
   "		         (expression float sqrt (var_ref k)))\n"
   "		       (var_ref n))))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 i)\n"
   "       (declare (in) vec4 n)\n"
   "       (declare (in) float eta))\n"
   "     ((declare () float k)\n"
   "      (assign (constant bool (1)) (x) (var_ref k)\n"
   "              (expression float - (constant float (1.0))\n"
   "	        (expression float * (var_ref eta)\n"
   "	          (expression float * (var_ref eta)\n"
   "		    (expression float - (constant float (1.0))\n"
   "		      (expression float * \n"
   "		        (expression float dot (var_ref n) (var_ref i))\n"
   "		        (expression float dot (var_ref n) (var_ref i))))))))\n"
   "      (if (expression bool < (var_ref k) (constant float (0.0)))\n"
   "          ((return (constant vec4 (0.0 0.0 0.0 0.0))))\n"
   "	  ((return (expression vec4 -\n"
   "	             (expression vec4 * (var_ref eta) (var_ref i))\n"
   "		     (expression vec4 *\n"
   "		       (expression float +\n"
   "		         (expression float * (var_ref eta)\n"
   "			   (expression float dot (var_ref n) (var_ref i)))\n"
   "		         (expression float sqrt (var_ref k)))\n"
   "		       (var_ref n))))))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow1D =
   "((function shadow1D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow1DArray =
   "((function shadow1DArray\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow1DArrayLod =
   "((function shadow1DArrayLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArrayShadow sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow1DLod =
   "((function shadow1DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow1DProj =
   "((function shadow1DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow1DProjLod =
   "((function shadow1DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DShadow sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow2D =
   "((function shadow2D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow2DArray =
   "((function shadow2DArray\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArrayShadow sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) 1 (swiz w (var_ref P)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow2DLod =
   "((function shadow2DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow2DProj =
   "((function shadow2DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow2DProjLod =
   "((function shadow2DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DShadow sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) (swiz z (var_ref P)) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow2DRect =
   "((function shadow2DRect\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) 1 (swiz z (var_ref P)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_shadow2DRectProj =
   "((function shadow2DRectProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRectShadow sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) (swiz z (var_ref P)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_sign =
   "((function sign\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float sign (var_ref x)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 sign (var_ref x)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 sign (var_ref x)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 sign (var_ref x)))))\n"
   "\n"
   "   (signature int\n"
   "     (parameters\n"
   "       (declare (in) int x))\n"
   "     ((return (expression int sign (var_ref x)))))\n"
   "\n"
   "   (signature ivec2\n"
   "     (parameters\n"
   "       (declare (in) ivec2 x))\n"
   "     ((return (expression ivec2 sign (var_ref x)))))\n"
   "\n"
   "   (signature ivec3\n"
   "     (parameters\n"
   "       (declare (in) ivec3 x))\n"
   "     ((return (expression ivec3 sign (var_ref x)))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) ivec4 x))\n"
   "     ((return (expression ivec4 sign (var_ref x)))))\n"
   "))\n"
   "\n"
   ""
;
static const char *builtin_sin =
   "((function sin\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float angle))\n"
   "     ((return (expression float sin (var_ref angle)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 angle))\n"
   "     ((return (expression vec2 sin (var_ref angle)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 angle))\n"
   "     ((return (expression vec3 sin (var_ref angle)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 angle))\n"
   "     ((return (expression vec4 sin (var_ref angle)))))\n"
   "))\n"
   ""
;
static const char *builtin_sinh =
   "((function sinh\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float * (constant float (0.5))\n"
   "                (expression float -\n"
   "		  (expression float exp (var_ref x))\n"
   "		  (expression float exp (expression float neg (var_ref x))))))))\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 * (constant vec2 (0.5))\n"
   "                (expression vec2 -\n"
   "		  (expression vec2 exp (var_ref x))\n"
   "		  (expression vec2 exp (expression vec2 neg (var_ref x))))))))\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 * (constant vec3 (0.5))\n"
   "                (expression vec3 -\n"
   "		  (expression vec3 exp (var_ref x))\n"
   "		  (expression vec3 exp (expression vec3 neg (var_ref x))))))))\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 * (constant vec4 (0.5))\n"
   "                (expression vec4 -\n"
   "		  (expression vec4 exp (var_ref x))\n"
   "		  (expression vec4 exp (expression vec4 neg (var_ref x))))))))\n"
   "))\n"
   ""
;
static const char *builtin_smoothstep =
   "((function smoothstep\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float edge0)\n"
   "       (declare (in) float edge1)\n"
   "       (declare (in) float x))\n"
   "     ((declare () float t)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (var_ref x) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (return (expression float * (var_ref t) (expression float * (var_ref t) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (var_ref t))))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) float edge0)\n"
   "       (declare (in) float edge1)\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 t)\n"
   "      (declare () vec2 retval)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (swiz x (var_ref x)) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (assign (constant bool (1)) (x) (var_ref retval) (expression float * (swiz x (var_ref t)) (expression float * (swiz x (var_ref t)) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (swiz x (var_ref t)))))))\n"
   "\n"
   "      (assign (constant bool (1)) (y) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (swiz y (var_ref x)) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (assign (constant bool (1)) (y) (var_ref retval) (expression float * (swiz y (var_ref t)) (expression float * (swiz y (var_ref t)) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (swiz y (var_ref t)))))))\n"
   "      (return (var_ref retval))\n"
   "      ))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) float edge0)\n"
   "       (declare (in) float edge1)\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 t)\n"
   "      (declare () vec3 retval)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (swiz x (var_ref x)) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (assign (constant bool (1)) (x) (var_ref retval) (expression float * (swiz x (var_ref t)) (expression float * (swiz x (var_ref t)) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (swiz x (var_ref t)))))))\n"
   "\n"
   "      (assign (constant bool (1)) (y) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (swiz y (var_ref x)) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (assign (constant bool (1)) (y) (var_ref retval) (expression float * (swiz y (var_ref t)) (expression float * (swiz y (var_ref t)) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (swiz y (var_ref t)))))))\n"
   "\n"
   "      (assign (constant bool (1)) (z) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (swiz z (var_ref x)) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (assign (constant bool (1)) (z) (var_ref retval) (expression float * (swiz z (var_ref t)) (expression float * (swiz z (var_ref t)) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (swiz z (var_ref t)))))))\n"
   "      (return (var_ref retval))\n"
   "      ))\n"
   "\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) float edge0)\n"
   "       (declare (in) float edge1)\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 t)\n"
   "      (declare () vec4 retval)\n"
   "\n"
   "      (assign (constant bool (1)) (x) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (swiz x (var_ref x)) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (assign (constant bool (1)) (x) (var_ref retval) (expression float * (swiz x (var_ref t)) (expression float * (swiz x (var_ref t)) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (swiz x (var_ref t)))))))\n"
   "\n"
   "      (assign (constant bool (1)) (y) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (swiz y (var_ref x)) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (assign (constant bool (1)) (y) (var_ref retval) (expression float * (swiz y (var_ref t)) (expression float * (swiz y (var_ref t)) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (swiz y (var_ref t)))))))\n"
   "\n"
   "      (assign (constant bool (1)) (z) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (swiz z (var_ref x)) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (assign (constant bool (1)) (z) (var_ref retval) (expression float * (swiz z (var_ref t)) (expression float * (swiz z (var_ref t)) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (swiz z (var_ref t)))))))\n"
   "\n"
   "      (assign (constant bool (1)) (w) (var_ref t)\n"
   "              (expression float max\n"
   "	                  (expression float min\n"
   "	                              (expression float / (expression float - (swiz w (var_ref x)) (var_ref edge0)) (expression float - (var_ref edge1) (var_ref edge0)))\n"
   "	                              (constant float (1.0)))\n"
   "	                  (constant float (0.0))))\n"
   "      (assign (constant bool (1)) (w) (var_ref retval) (expression float * (swiz w (var_ref t)) (expression float * (swiz w (var_ref t)) (expression float - (constant float (3.000000)) (expression float * (constant float (2.000000)) (swiz w (var_ref t)))))))\n"
   "      (return (var_ref retval))\n"
   "      ))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 edge0)\n"
   "       (declare (in) vec2 edge1)\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 max\n"
   "                          (expression vec2 min\n"
   "                                      (expression vec2 / (expression vec2 - (var_ref x) (var_ref edge0)) (expression vec2 - (var_ref edge1) (var_ref edge0)))\n"
   "                                      (constant vec2 (1.0 1.0)))\n"
   "                          (constant vec2 (0.0 0.0))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 edge0)\n"
   "       (declare (in) vec3 edge1)\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 max\n"
   "                          (expression vec3 min\n"
   "                                      (expression vec3 / (expression vec3 - (var_ref x) (var_ref edge0)) (expression vec3 - (var_ref edge1) (var_ref edge0)))\n"
   "                                      (constant vec3 (1.0 1.0 1.0)))\n"
   "                          (constant vec3 (0.0 0.0 0.0))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 edge0)\n"
   "       (declare (in) vec4 edge1)\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 max\n"
   "                          (expression vec4 min\n"
   "                                      (expression vec4 / (expression vec4 - (var_ref x) (var_ref edge0)) (expression vec4 - (var_ref edge1) (var_ref edge0)))\n"
   "                                      (constant vec4 (1.0 1.0 1.0 1.0)))\n"
   "                          (constant vec4 (0.0 0.0 0.0 0.0))))))\n"
   "))\n"
   "\n"
   ""
;
static const char *builtin_sqrt =
   "((function sqrt\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float arg0))\n"
   "     ((return (expression float sqrt (var_ref arg0)))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 arg0))\n"
   "     ((return (expression vec2 sqrt (var_ref arg0)))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 arg0))\n"
   "     ((return (expression vec3 sqrt (var_ref arg0)))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 arg0))\n"
   "     ((return (expression vec4 sqrt (var_ref arg0)))))\n"
   "))\n"
   ""
;
static const char *builtin_step =
   "((function step\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float edge)\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float b2f (expression bool >= (var_ref x) (var_ref edge))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) float edge)\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 t)\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(var_ref edge))))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(var_ref edge))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) float edge)\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 t)\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(var_ref edge))))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(var_ref edge))))\n"
   "      (assign (constant bool (1)) (z) (var_ref t) (expression float b2f (expression bool >= (swiz z (var_ref x))(var_ref edge))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) float edge)\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 t)\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(var_ref edge))))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(var_ref edge))))\n"
   "      (assign (constant bool (1)) (z) (var_ref t) (expression float b2f (expression bool >= (swiz z (var_ref x))(var_ref edge))))\n"
   "      (assign (constant bool (1)) (w) (var_ref t) (expression float b2f (expression bool >= (swiz w (var_ref x))(var_ref edge))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 edge)\n"
   "       (declare (in) vec2 x))\n"
   "     ((declare () vec2 t)\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(swiz x (var_ref edge)))))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(swiz y (var_ref edge)))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 edge)\n"
   "       (declare (in) vec3 x))\n"
   "     ((declare () vec3 t)\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(swiz x (var_ref edge)))))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(swiz y (var_ref edge)))))\n"
   "      (assign (constant bool (1)) (z) (var_ref t) (expression float b2f (expression bool >= (swiz z (var_ref x))(swiz z (var_ref edge)))))\n"
   "      (return (var_ref t))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 edge)\n"
   "       (declare (in) vec4 x))\n"
   "     ((declare () vec4 t)\n"
   "      (assign (constant bool (1)) (x) (var_ref t) (expression float b2f (expression bool >= (swiz x (var_ref x))(swiz x (var_ref edge)))))\n"
   "      (assign (constant bool (1)) (y) (var_ref t) (expression float b2f (expression bool >= (swiz y (var_ref x))(swiz y (var_ref edge)))))\n"
   "      (assign (constant bool (1)) (z) (var_ref t) (expression float b2f (expression bool >= (swiz z (var_ref x))(swiz z (var_ref edge)))))\n"
   "      (assign (constant bool (1)) (w) (var_ref t) (expression float b2f (expression bool >= (swiz w (var_ref x))(swiz w (var_ref edge)))))\n"
   "      (return (var_ref t))))\n"
   "))\n"
   "\n"
   ""
;
static const char *builtin_tan =
   "((function tan\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float angle))\n"
   "     ((return (expression float / (expression float sin (var_ref angle)) (expression float cos (var_ref angle))))))\n"
   "\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 angle))\n"
   "     ((return (expression vec2 / (expression vec2 sin (var_ref angle)) (expression vec2 cos (var_ref angle))))))\n"
   "\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 angle))\n"
   "     ((return (expression vec3 / (expression vec3 sin (var_ref angle)) (expression vec3 cos (var_ref angle))))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 angle))\n"
   "     ((return (expression vec4 / (expression vec4 sin (var_ref angle)) (expression vec4 cos (var_ref angle))))))\n"
   "))\n"
   ""
;
static const char *builtin_tanh =
   "((function tanh\n"
   "   (signature float\n"
   "     (parameters\n"
   "       (declare (in) float x))\n"
   "     ((return (expression float /\n"
   "                (expression float -\n"
   "		  (expression float exp (var_ref x))\n"
   "		  (expression float exp (expression float neg (var_ref x))))\n"
   "                (expression float +\n"
   "		  (expression float exp (var_ref x))\n"
   "		  (expression float exp (expression float neg (var_ref x))))))))\n"
   "   (signature vec2\n"
   "     (parameters\n"
   "       (declare (in) vec2 x))\n"
   "     ((return (expression vec2 /\n"
   "                (expression vec2 -\n"
   "		  (expression vec2 exp (var_ref x))\n"
   "		  (expression vec2 exp (expression vec2 neg (var_ref x))))\n"
   "                (expression vec2 +\n"
   "		  (expression vec2 exp (var_ref x))\n"
   "		  (expression vec2 exp (expression vec2 neg (var_ref x))))))))\n"
   "   (signature vec3\n"
   "     (parameters\n"
   "       (declare (in) vec3 x))\n"
   "     ((return (expression vec3 /\n"
   "                (expression vec3 -\n"
   "		  (expression vec3 exp (var_ref x))\n"
   "		  (expression vec3 exp (expression vec3 neg (var_ref x))))\n"
   "                (expression vec3 +\n"
   "		  (expression vec3 exp (var_ref x))\n"
   "		  (expression vec3 exp (expression vec3 neg (var_ref x))))))))\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) vec4 x))\n"
   "     ((return (expression vec4 /\n"
   "                (expression vec4 -\n"
   "		  (expression vec4 exp (var_ref x))\n"
   "		  (expression vec4 exp (expression vec4 neg (var_ref x))))\n"
   "                (expression vec4 +\n"
   "		  (expression vec4 exp (var_ref x))\n"
   "		  (expression vec4 exp (expression vec4 neg (var_ref x))))))))\n"
   "))\n"
   ""
;
static const char *builtin_texelFetch =
   "((function texelFetch\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) int P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) int P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) int P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler)\n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler)\n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler)\n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler)\n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler)\n"
   "       (declare (in) ivec2 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler)\n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler)\n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler)\n"
   "       (declare (in) ivec3 P) \n"
   "       (declare (in) int lod) )\n"
   "     ((return (txf (var_ref sampler) (var_ref P) (0 0 0) (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture =
   "((function texture\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) float P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) float P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) float P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture1D =
   "((function texture1D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) float P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture1DArray =
   "((function texture1DArray\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture1DArrayLod =
   "((function texture1DArrayLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture1DLod =
   "((function texture1DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture1DProj =
   "((function texture1DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture1DProjLod =
   "((function texture1DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture2D =
   "((function texture2D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture2DArray =
   "((function texture2DArray\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture2DArrayLod =
   "((function texture2DArrayLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture2DLod =
   "((function texture2DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture2DProj =
   "((function texture2DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture2DProjLod =
   "((function texture2DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture2DRect =
   "((function texture2DRect\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture2DRectProj =
   "((function texture2DRectProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DRect sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture3D =
   "((function texture3D\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture3DLod =
   "((function texture3DLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture3DProj =
   "((function texture3DProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_texture3DProjLod =
   "((function texture3DProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_textureCube =
   "((function textureCube\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (var_ref P) (0 0 0) 1 () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_textureCubeLod =
   "((function textureCubeLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_textureGrad =
   "((function textureGrad\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (var_ref P) (0 0 0) 1 () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_textureLod =
   "((function textureLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) float P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) samplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isamplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usamplerCube sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1DArray sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2DArray sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (var_ref P) (0 0 0) 1 () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_textureProj =
   "((function textureProj\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) vec2 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec3 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler)\n"
   "       (declare (in) vec4 P) )\n"
   "     ((return (tex (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float bias) )\n"
   "     ((return (txb (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref bias) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_textureProjGrad =
   "((function textureProjGrad\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float dPdx) \n"
   "       (declare (in) float dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec2 dPdx) \n"
   "       (declare (in) vec2 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) vec3 dPdx) \n"
   "       (declare (in) vec3 dPdy) )\n"
   "     ((return (txd (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () ((var_ref dPdx) (var_ref dPdy)) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_textureProjLod =
   "((function textureProjLod\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) vec2 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz y (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler1D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz x (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec3 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz z (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler2D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xy (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature vec4\n"
   "     (parameters\n"
   "       (declare (in) sampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature ivec4\n"
   "     (parameters\n"
   "       (declare (in) isampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "   (signature uvec4\n"
   "     (parameters\n"
   "       (declare (in) usampler3D sampler)\n"
   "       (declare (in) vec4 P) \n"
   "       (declare (in) float lod) )\n"
   "     ((return (txl (var_ref sampler) (swiz xyz (var_ref P)) (0 0 0) (swiz w (var_ref P)) () (var_ref lod) ))))\n"
   "\n"
   "))\n"
   ""
;
static const char *builtin_transpose =
   "((function transpose\n"
   "   (signature mat2\n"
   "     (parameters\n"
   "       (declare (in) mat2 m))\n"
   "     ((declare () mat2 t)\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat3x2\n"
   "     (parameters\n"
   "       (declare (in) mat2x3 m))\n"
   "     ((declare () mat3x2 t)\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat4x2\n"
   "     (parameters\n"
   "       (declare (in) mat2x4 m))\n"
   "     ((declare () mat4x2 t)\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (1)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat2x3\n"
   "     (parameters\n"
   "       (declare (in) mat3x2 m))\n"
   "     ((declare () mat2x3 t)\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat3\n"
   "     (parameters\n"
   "       (declare (in) mat3 m))\n"
   "     ((declare () mat3 t)\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (2)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat4x3\n"
   "     (parameters\n"
   "       (declare (in) mat3x4 m))\n"
   "     ((declare () mat4x3 t)\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (2)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat2x4\n"
   "     (parameters\n"
   "       (declare (in) mat4x2 m))\n"
   "     ((declare () mat2x4 t)\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (w) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (constant bool (1)) (w) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (3)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat3x4\n"
   "     (parameters\n"
   "       (declare (in) mat4x3 m))\n"
   "     ((declare () mat3x4 t)\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (w) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (constant bool (1)) (w) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (constant bool (1)) (w) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (3)))))\n"
   "(return (var_ref t))))\n"
   "\n"
   "   (signature mat4\n"
   "     (parameters\n"
   "       (declare (in) mat4 m))\n"
   "     ((declare () mat4 t)\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (x) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (0)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (y) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (1)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (z) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (2)))))\n"
   "      (assign (constant bool (1)) (w) (array_ref (var_ref t) (constant int (0))) (swiz x (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (constant bool (1)) (w) (array_ref (var_ref t) (constant int (1))) (swiz y (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (constant bool (1)) (w) (array_ref (var_ref t) (constant int (2))) (swiz z (array_ref (var_ref m) (constant int (3)))))\n"
   "      (assign (constant bool (1)) (w) (array_ref (var_ref t) (constant int (3))) (swiz w (array_ref (var_ref m) (constant int (3)))))\n"
   "(return (var_ref t))))\n"
   ")\n"
   "\n"
   ")\n"
   "\n"
   ""
;
static const char *prototypes_for_100_frag =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())))"
;
static const char *functions_for_100_frag [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cross,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_sign,
   builtin_sin,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_textureCube,
};
static const char *prototypes_for_100_vert =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function textureCubeLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())))"
;
static const char *functions_for_100_vert [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cross,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_sign,
   builtin_sin,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_texture2D,
   builtin_texture2DLod,
   builtin_texture2DProj,
   builtin_texture2DProjLod,
   builtin_textureCube,
   builtin_textureCubeLod,
};
static const char *prototypes_for_110_frag =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function dFdx\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function dFdy\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function fwidth\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function noise1\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise2\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise3\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise4\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())))"
;
static const char *functions_for_110_frag [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cross,
   builtin_dFdx,
   builtin_dFdy,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_fwidth,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_noise1,
   builtin_noise2,
   builtin_noise3,
   builtin_noise4,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_shadow1D,
   builtin_shadow1DProj,
   builtin_shadow2D,
   builtin_shadow2DProj,
   builtin_sign,
   builtin_sin,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_texture1D,
   builtin_texture1DProj,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_texture3D,
   builtin_texture3DProj,
   builtin_textureCube,
};
static const char *prototypes_for_110_vert =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ftransform\n"
   "  (signature vec4\n"
   "    (parameters)\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture3DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function textureCubeLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function shadow1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function noise1\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise2\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise3\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise4\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())))"
;
static const char *functions_for_110_vert [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cross,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_ftransform,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_noise1,
   builtin_noise2,
   builtin_noise3,
   builtin_noise4,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_shadow1D,
   builtin_shadow1DLod,
   builtin_shadow1DProj,
   builtin_shadow1DProjLod,
   builtin_shadow2D,
   builtin_shadow2DLod,
   builtin_shadow2DProj,
   builtin_shadow2DProjLod,
   builtin_sign,
   builtin_sin,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_texture1D,
   builtin_texture1DLod,
   builtin_texture1DProj,
   builtin_texture1DProjLod,
   builtin_texture2D,
   builtin_texture2DLod,
   builtin_texture2DProj,
   builtin_texture2DProjLod,
   builtin_texture3D,
   builtin_texture3DLod,
   builtin_texture3DProj,
   builtin_texture3DProjLod,
   builtin_textureCube,
   builtin_textureCubeLod,
};
static const char *prototypes_for_120_frag =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 x)\n"
   "      (declare (in) mat2x3 y))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 x)\n"
   "      (declare (in) mat2x4 y))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 x)\n"
   "      (declare (in) mat3x2 y))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 x)\n"
   "      (declare (in) mat3x4 y))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 x)\n"
   "      (declare (in) mat4x2 y))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 x)\n"
   "      (declare (in) mat4x3 y))\n"
   "    ()))\n"
   "(function outerProduct\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ()))\n"
   "(function transpose\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 m))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 m))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 m))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 m))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 m))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 m))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 m))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 m))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 m))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function dFdx\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function dFdy\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function fwidth\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function noise1\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise2\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise3\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise4\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())))"
;
static const char *functions_for_120_frag [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cross,
   builtin_dFdx,
   builtin_dFdy,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_fwidth,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_noise1,
   builtin_noise2,
   builtin_noise3,
   builtin_noise4,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_outerProduct,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_shadow1D,
   builtin_shadow1DProj,
   builtin_shadow2D,
   builtin_shadow2DProj,
   builtin_sign,
   builtin_sin,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_texture1D,
   builtin_texture1DProj,
   builtin_texture2D,
   builtin_texture2DProj,
   builtin_texture3D,
   builtin_texture3DProj,
   builtin_textureCube,
   builtin_transpose,
};
static const char *prototypes_for_120_vert =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ftransform\n"
   "  (signature vec4\n"
   "    (parameters)\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 x)\n"
   "      (declare (in) mat2x3 y))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 x)\n"
   "      (declare (in) mat2x4 y))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 x)\n"
   "      (declare (in) mat3x2 y))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 x)\n"
   "      (declare (in) mat3x4 y))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 x)\n"
   "      (declare (in) mat4x2 y))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 x)\n"
   "      (declare (in) mat4x3 y))\n"
   "    ()))\n"
   "(function outerProduct\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ()))\n"
   "(function transpose\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 m))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 m))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 m))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 m))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 m))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 m))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 m))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 m))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 m))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function texture3DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function textureCubeLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function shadow1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function noise1\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise2\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise3\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise4\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())))"
;
static const char *functions_for_120_vert [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cross,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_ftransform,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_noise1,
   builtin_noise2,
   builtin_noise3,
   builtin_noise4,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_outerProduct,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_shadow1D,
   builtin_shadow1DLod,
   builtin_shadow1DProj,
   builtin_shadow1DProjLod,
   builtin_shadow2D,
   builtin_shadow2DLod,
   builtin_shadow2DProj,
   builtin_shadow2DProjLod,
   builtin_sign,
   builtin_sin,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_texture1D,
   builtin_texture1DLod,
   builtin_texture1DProj,
   builtin_texture1DProjLod,
   builtin_texture2D,
   builtin_texture2DLod,
   builtin_texture2DProj,
   builtin_texture2DProjLod,
   builtin_texture3D,
   builtin_texture3DLod,
   builtin_texture3DProj,
   builtin_texture3DProjLod,
   builtin_textureCube,
   builtin_textureCubeLod,
   builtin_transpose,
};
static const char *prototypes_for_130_frag =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function sinh\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function cosh\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function tanh\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature uint\n"
   "    (parameters\n"
   "      (declare (in) uint x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uint y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature uint\n"
   "    (parameters\n"
   "      (declare (in) uint x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uint y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x)\n"
   "      (declare (in) int minVal)\n"
   "      (declare (in) int maxVal))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 minVal)\n"
   "      (declare (in) ivec2 maxVal))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 minVal)\n"
   "      (declare (in) ivec3 maxVal))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 minVal)\n"
   "      (declare (in) ivec4 maxVal))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) int minVal)\n"
   "      (declare (in) int maxVal))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) int minVal)\n"
   "      (declare (in) int maxVal))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) int minVal)\n"
   "      (declare (in) int maxVal))\n"
   "    ())\n"
   "  (signature uint\n"
   "    (parameters\n"
   "      (declare (in) uint x)\n"
   "      (declare (in) uint minVal)\n"
   "      (declare (in) uint maxVal))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 minVal)\n"
   "      (declare (in) uvec2 maxVal))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 minVal)\n"
   "      (declare (in) uvec3 maxVal))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 minVal)\n"
   "      (declare (in) uvec4 maxVal))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uint minVal)\n"
   "      (declare (in) uint maxVal))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uint minVal)\n"
   "      (declare (in) uint maxVal))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uint minVal)\n"
   "      (declare (in) uint maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 x)\n"
   "      (declare (in) mat2x3 y))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 x)\n"
   "      (declare (in) mat2x4 y))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 x)\n"
   "      (declare (in) mat3x2 y))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 x)\n"
   "      (declare (in) mat3x4 y))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 x)\n"
   "      (declare (in) mat4x2 y))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 x)\n"
   "      (declare (in) mat4x3 y))\n"
   "    ()))\n"
   "(function outerProduct\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ()))\n"
   "(function transpose\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 m))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 m))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 m))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 m))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 m))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 m))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 m))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 m))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 m))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) samplerCubeShadow sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArrayShadow sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) samplerCubeShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texelFetch\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) int P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) int P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) int P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ()))\n"
   "(function textureProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureGrad\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) samplerCubeShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArrayShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ()))\n"
   "(function textureProjGrad\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCubeLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function dFdx\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function dFdy\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function fwidth\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 p))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 p))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 p))\n"
   "    ()))\n"
   "(function noise1\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise2\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise3\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise4\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())))"
;
static const char *functions_for_130_frag [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cosh,
   builtin_cross,
   builtin_dFdx,
   builtin_dFdy,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_fwidth,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_noise1,
   builtin_noise2,
   builtin_noise3,
   builtin_noise4,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_outerProduct,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_shadow1D,
   builtin_shadow1DLod,
   builtin_shadow1DProj,
   builtin_shadow1DProjLod,
   builtin_shadow2D,
   builtin_shadow2DLod,
   builtin_shadow2DProj,
   builtin_shadow2DProjLod,
   builtin_sign,
   builtin_sin,
   builtin_sinh,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_tanh,
   builtin_texelFetch,
   builtin_texture,
   builtin_texture1D,
   builtin_texture1DLod,
   builtin_texture1DProj,
   builtin_texture1DProjLod,
   builtin_texture2D,
   builtin_texture2DLod,
   builtin_texture2DProj,
   builtin_texture2DProjLod,
   builtin_texture3D,
   builtin_texture3DLod,
   builtin_texture3DProj,
   builtin_texture3DProjLod,
   builtin_textureCube,
   builtin_textureCubeLod,
   builtin_textureGrad,
   builtin_textureLod,
   builtin_textureProj,
   builtin_textureProjGrad,
   builtin_textureProjLod,
   builtin_transpose,
};
static const char *prototypes_for_130_vert =
   "(\n"
   "(function radians\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float degrees))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 degrees))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 degrees))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 degrees))\n"
   "    ()))\n"
   "(function degrees\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float radians))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 radians))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 radians))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 radians))\n"
   "    ()))\n"
   "(function sin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function cos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function tan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function asin\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function acos\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float angle))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 angle))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 angle))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 angle))\n"
   "    ()))\n"
   "(function atan\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float y_over_x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 y_over_x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 y_over_x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 y_over_x))\n"
   "    ()))\n"
   "(function sinh\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function cosh\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function tanh\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function pow\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function exp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function exp2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function log2\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function sqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function inversesqrt\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function abs\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x))\n"
   "    ()))\n"
   "(function sign\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x))\n"
   "    ()))\n"
   "(function floor\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ceil\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function fract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function mod\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function min\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature uint\n"
   "    (parameters\n"
   "      (declare (in) uint x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uint y))\n"
   "    ()))\n"
   "(function max\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) int y))\n"
   "    ())\n"
   "  (signature uint\n"
   "    (parameters\n"
   "      (declare (in) uint x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uint y))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uint y))\n"
   "    ()))\n"
   "(function clamp\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 minVal)\n"
   "      (declare (in) vec2 maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 minVal)\n"
   "      (declare (in) vec3 maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 minVal)\n"
   "      (declare (in) vec4 maxVal))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) float minVal)\n"
   "      (declare (in) float maxVal))\n"
   "    ())\n"
   "  (signature int\n"
   "    (parameters\n"
   "      (declare (in) int x)\n"
   "      (declare (in) int minVal)\n"
   "      (declare (in) int maxVal))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 minVal)\n"
   "      (declare (in) ivec2 maxVal))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 minVal)\n"
   "      (declare (in) ivec3 maxVal))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 minVal)\n"
   "      (declare (in) ivec4 maxVal))\n"
   "    ())\n"
   "  (signature ivec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) int minVal)\n"
   "      (declare (in) int maxVal))\n"
   "    ())\n"
   "  (signature ivec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) int minVal)\n"
   "      (declare (in) int maxVal))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) int minVal)\n"
   "      (declare (in) int maxVal))\n"
   "    ())\n"
   "  (signature uint\n"
   "    (parameters\n"
   "      (declare (in) uint x)\n"
   "      (declare (in) uint minVal)\n"
   "      (declare (in) uint maxVal))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 minVal)\n"
   "      (declare (in) uvec2 maxVal))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 minVal)\n"
   "      (declare (in) uvec3 maxVal))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 minVal)\n"
   "      (declare (in) uvec4 maxVal))\n"
   "    ())\n"
   "  (signature uvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uint minVal)\n"
   "      (declare (in) uint maxVal))\n"
   "    ())\n"
   "  (signature uvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uint minVal)\n"
   "      (declare (in) uint maxVal))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uint minVal)\n"
   "      (declare (in) uint maxVal))\n"
   "    ()))\n"
   "(function mix\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) vec2 a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) vec3 a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) vec4 a))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y)\n"
   "      (declare (in) float a))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y)\n"
   "      (declare (in) float a))\n"
   "    ()))\n"
   "(function step\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function smoothstep\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 edge0)\n"
   "      (declare (in) vec2 edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 edge0)\n"
   "      (declare (in) vec3 edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 edge0)\n"
   "      (declare (in) vec4 edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float edge0)\n"
   "      (declare (in) float edge1)\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function length\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function distance\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float p0)\n"
   "      (declare (in) float p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 p0)\n"
   "      (declare (in) vec2 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 p0)\n"
   "      (declare (in) vec3 p1))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 p0)\n"
   "      (declare (in) vec4 p1))\n"
   "    ()))\n"
   "(function dot\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x)\n"
   "      (declare (in) float y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ()))\n"
   "(function cross\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ()))\n"
   "(function normalize\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function ftransform\n"
   "  (signature vec4\n"
   "    (parameters)\n"
   "    ()))\n"
   "(function faceforward\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float Nref))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 Nref))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 Nref))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 Nref))\n"
   "    ()))\n"
   "(function reflect\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N))\n"
   "    ()))\n"
   "(function refract\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float I)\n"
   "      (declare (in) float N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 I)\n"
   "      (declare (in) vec2 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 I)\n"
   "      (declare (in) vec3 N)\n"
   "      (declare (in) float eta))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 I)\n"
   "      (declare (in) vec4 N)\n"
   "      (declare (in) float eta))\n"
   "    ()))\n"
   "(function matrixCompMult\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 x)\n"
   "      (declare (in) mat2 y))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 x)\n"
   "      (declare (in) mat3 y))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 x)\n"
   "      (declare (in) mat4 y))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 x)\n"
   "      (declare (in) mat2x3 y))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 x)\n"
   "      (declare (in) mat2x4 y))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 x)\n"
   "      (declare (in) mat3x2 y))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 x)\n"
   "      (declare (in) mat3x4 y))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 x)\n"
   "      (declare (in) mat4x2 y))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 x)\n"
   "      (declare (in) mat4x3 y))\n"
   "    ()))\n"
   "(function outerProduct\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec2 r))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) vec2 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) vec4 c)\n"
   "      (declare (in) vec3 r))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) vec3 c)\n"
   "      (declare (in) vec4 r))\n"
   "    ()))\n"
   "(function transpose\n"
   "  (signature mat2\n"
   "    (parameters\n"
   "      (declare (in) mat2 m))\n"
   "    ())\n"
   "  (signature mat3\n"
   "    (parameters\n"
   "      (declare (in) mat3 m))\n"
   "    ())\n"
   "  (signature mat4\n"
   "    (parameters\n"
   "      (declare (in) mat4 m))\n"
   "    ())\n"
   "  (signature mat2x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x2 m))\n"
   "    ())\n"
   "  (signature mat3x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x3 m))\n"
   "    ())\n"
   "  (signature mat2x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x2 m))\n"
   "    ())\n"
   "  (signature mat4x2\n"
   "    (parameters\n"
   "      (declare (in) mat2x4 m))\n"
   "    ())\n"
   "  (signature mat3x4\n"
   "    (parameters\n"
   "      (declare (in) mat4x3 m))\n"
   "    ())\n"
   "  (signature mat4x3\n"
   "    (parameters\n"
   "      (declare (in) mat3x4 m))\n"
   "    ()))\n"
   "(function lessThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ()))\n"
   "(function lessThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ()))\n"
   "(function greaterThan\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ()))\n"
   "(function greaterThanEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ()))\n"
   "(function equal\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function notEqual\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x)\n"
   "      (declare (in) vec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x)\n"
   "      (declare (in) vec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x)\n"
   "      (declare (in) vec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) ivec2 x)\n"
   "      (declare (in) ivec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) ivec3 x)\n"
   "      (declare (in) ivec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) ivec4 x)\n"
   "      (declare (in) ivec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) uvec2 x)\n"
   "      (declare (in) uvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) uvec3 x)\n"
   "      (declare (in) uvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) uvec4 x)\n"
   "      (declare (in) uvec4 y))\n"
   "    ())\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x)\n"
   "      (declare (in) bvec2 y))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x)\n"
   "      (declare (in) bvec3 y))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x)\n"
   "      (declare (in) bvec4 y))\n"
   "    ()))\n"
   "(function any\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function all\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bool\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function not\n"
   "  (signature bvec2\n"
   "    (parameters\n"
   "      (declare (in) bvec2 x))\n"
   "    ())\n"
   "  (signature bvec3\n"
   "    (parameters\n"
   "      (declare (in) bvec3 x))\n"
   "    ())\n"
   "  (signature bvec4\n"
   "    (parameters\n"
   "      (declare (in) bvec4 x))\n"
   "    ()))\n"
   "(function texture\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) samplerCubeShadow sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArrayShadow sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) samplerCubeShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texelFetch\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) int P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) int P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) int P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) ivec2 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) ivec3 P)\n"
   "      (declare (in) int lod))\n"
   "    ()))\n"
   "(function textureProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureGrad\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) float P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usamplerCube sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) samplerCubeShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1DArray sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2DArray sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArrayShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ()))\n"
   "(function textureProjGrad\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec2 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler1D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec3 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler2D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature ivec4\n"
   "    (parameters\n"
   "      (declare (in) isampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature uvec4\n"
   "    (parameters\n"
   "      (declare (in) usampler3D sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec3 dPdx)\n"
   "      (declare (in) vec3 dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) float dPdx)\n"
   "      (declare (in) float dPdy))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 P)\n"
   "      (declare (in) vec2 dPdx)\n"
   "      (declare (in) vec2 dPdy))\n"
   "    ()))\n"
   "(function texture1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) float coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture3DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture3DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler3D sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function textureCube\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function textureCubeLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) samplerCube sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2D\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2DProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DProjLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DShadow sampler)\n"
   "      (declare (in) vec4 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function noise1\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature float\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise2\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec2\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise3\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec3\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ()))\n"
   "(function noise4\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) float x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec2 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec3 x))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) vec4 x))\n"
   "    ())))"
;
static const char *functions_for_130_vert [] = {
   builtin_abs,
   builtin_acos,
   builtin_all,
   builtin_any,
   builtin_asin,
   builtin_atan,
   builtin_ceil,
   builtin_clamp,
   builtin_cos,
   builtin_cosh,
   builtin_cross,
   builtin_degrees,
   builtin_distance,
   builtin_dot,
   builtin_equal,
   builtin_exp,
   builtin_exp2,
   builtin_faceforward,
   builtin_floor,
   builtin_fract,
   builtin_ftransform,
   builtin_greaterThan,
   builtin_greaterThanEqual,
   builtin_inversesqrt,
   builtin_length,
   builtin_lessThan,
   builtin_lessThanEqual,
   builtin_log,
   builtin_log2,
   builtin_matrixCompMult,
   builtin_max,
   builtin_min,
   builtin_mix,
   builtin_mod,
   builtin_noise1,
   builtin_noise2,
   builtin_noise3,
   builtin_noise4,
   builtin_normalize,
   builtin_not,
   builtin_notEqual,
   builtin_outerProduct,
   builtin_pow,
   builtin_radians,
   builtin_reflect,
   builtin_refract,
   builtin_shadow1D,
   builtin_shadow1DLod,
   builtin_shadow1DProj,
   builtin_shadow1DProjLod,
   builtin_shadow2D,
   builtin_shadow2DLod,
   builtin_shadow2DProj,
   builtin_shadow2DProjLod,
   builtin_sign,
   builtin_sin,
   builtin_sinh,
   builtin_smoothstep,
   builtin_sqrt,
   builtin_step,
   builtin_tan,
   builtin_tanh,
   builtin_texelFetch,
   builtin_texture,
   builtin_texture1D,
   builtin_texture1DLod,
   builtin_texture1DProj,
   builtin_texture1DProjLod,
   builtin_texture2D,
   builtin_texture2DLod,
   builtin_texture2DProj,
   builtin_texture2DProjLod,
   builtin_texture3D,
   builtin_texture3DLod,
   builtin_texture3DProj,
   builtin_texture3DProjLod,
   builtin_textureCube,
   builtin_textureCubeLod,
   builtin_textureGrad,
   builtin_textureLod,
   builtin_textureProj,
   builtin_textureProjGrad,
   builtin_textureProjLod,
   builtin_transpose,
};
static const char *prototypes_for_ARB_texture_rectangle_frag =
   "(\n"
   "(function texture2DRect\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRect sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ()))\n"
   "(function texture2DRectProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRect sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRect sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function shadow2DRect\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRectShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow2DRectProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRectShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())))"
;
static const char *functions_for_ARB_texture_rectangle_frag [] = {
   builtin_shadow2DRect,
   builtin_shadow2DRectProj,
   builtin_texture2DRect,
   builtin_texture2DRectProj,
};
static const char *prototypes_for_ARB_texture_rectangle_vert =
   "(\n"
   "(function texture2DRect\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRect sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ()))\n"
   "(function texture2DRectProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRect sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRect sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ()))\n"
   "(function shadow2DRect\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRectShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow2DRectProj\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DRectShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())))"
;
static const char *functions_for_ARB_texture_rectangle_vert [] = {
   builtin_shadow2DRect,
   builtin_shadow2DRectProj,
   builtin_texture2DRect,
   builtin_texture2DRectProj,
};
static const char *prototypes_for_EXT_texture_array_frag =
   "(\n"
   "(function texture1DArray\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function texture2DArray\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow1DArray\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ())\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float bias))\n"
   "    ()))\n"
   "(function shadow2DArray\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArrayShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())))"
;
static const char *functions_for_EXT_texture_array_frag [] = {
   builtin_shadow1DArray,
   builtin_shadow2DArray,
   builtin_texture1DArray,
   builtin_texture2DArray,
};
static const char *prototypes_for_EXT_texture_array_vert =
   "(\n"
   "(function texture1DArray\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 coord))\n"
   "    ()))\n"
   "(function texture1DArrayLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArray sampler)\n"
   "      (declare (in) vec2 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function texture2DArray\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function texture2DArrayLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArray sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow1DArray\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 coord))\n"
   "    ()))\n"
   "(function shadow1DArrayLod\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler1DArrayShadow sampler)\n"
   "      (declare (in) vec3 coord)\n"
   "      (declare (in) float lod))\n"
   "    ()))\n"
   "(function shadow2DArray\n"
   "  (signature vec4\n"
   "    (parameters\n"
   "      (declare (in) sampler2DArrayShadow sampler)\n"
   "      (declare (in) vec4 coord))\n"
   "    ())))"
;
static const char *functions_for_EXT_texture_array_vert [] = {
   builtin_shadow1DArray,
   builtin_shadow1DArrayLod,
   builtin_shadow2DArray,
   builtin_texture1DArray,
   builtin_texture1DArrayLod,
   builtin_texture2DArray,
   builtin_texture2DArrayLod,
};
static gl_shader *builtin_profiles[12];

void *builtin_mem_ctx = NULL;

void
_mesa_glsl_release_functions(void)
{
   talloc_free(builtin_mem_ctx);
   builtin_mem_ctx = NULL;
   memset(builtin_profiles, 0, sizeof(builtin_profiles));
}

static void
_mesa_read_profile(struct _mesa_glsl_parse_state *state,
		   exec_list *instructions,
                   int profile_index,
		   const char *prototypes,
		   const char **functions,
                   int count)
{
   gl_shader *sh = builtin_profiles[profile_index];

   if (sh == NULL) {
      sh = read_builtins(GL_VERTEX_SHADER, prototypes, functions, count);
      talloc_steal(builtin_mem_ctx, sh);
      builtin_profiles[profile_index] = sh;
   }

   import_prototypes(sh->ir, instructions, state->symbols, state);
   state->builtins_to_link[state->num_builtins_to_link] = sh;
   state->num_builtins_to_link++;
}

void
_mesa_glsl_initialize_functions(exec_list *instructions,
                                struct _mesa_glsl_parse_state *state)
{
   if (builtin_mem_ctx == NULL) {
      builtin_mem_ctx = talloc_init("GLSL built-in functions");
      memset(&builtin_profiles, 0, sizeof(builtin_profiles));
   }

   state->num_builtins_to_link = 0;

   if (state->target == fragment_shader && state->language_version == 100) {
      _mesa_read_profile(state, instructions, 0,
                         prototypes_for_100_frag,
                         functions_for_100_frag,
                         Elements(functions_for_100_frag));
   }

   if (state->target == vertex_shader && state->language_version == 100) {
      _mesa_read_profile(state, instructions, 1,
                         prototypes_for_100_vert,
                         functions_for_100_vert,
                         Elements(functions_for_100_vert));
   }

   if (state->target == fragment_shader && state->language_version == 110) {
      _mesa_read_profile(state, instructions, 2,
                         prototypes_for_110_frag,
                         functions_for_110_frag,
                         Elements(functions_for_110_frag));
   }

   if (state->target == vertex_shader && state->language_version == 110) {
      _mesa_read_profile(state, instructions, 3,
                         prototypes_for_110_vert,
                         functions_for_110_vert,
                         Elements(functions_for_110_vert));
   }

   if (state->target == fragment_shader && state->language_version == 120) {
      _mesa_read_profile(state, instructions, 4,
                         prototypes_for_120_frag,
                         functions_for_120_frag,
                         Elements(functions_for_120_frag));
   }

   if (state->target == vertex_shader && state->language_version == 120) {
      _mesa_read_profile(state, instructions, 5,
                         prototypes_for_120_vert,
                         functions_for_120_vert,
                         Elements(functions_for_120_vert));
   }

   if (state->target == fragment_shader && state->language_version == 130) {
      _mesa_read_profile(state, instructions, 6,
                         prototypes_for_130_frag,
                         functions_for_130_frag,
                         Elements(functions_for_130_frag));
   }

   if (state->target == vertex_shader && state->language_version == 130) {
      _mesa_read_profile(state, instructions, 7,
                         prototypes_for_130_vert,
                         functions_for_130_vert,
                         Elements(functions_for_130_vert));
   }

   if (state->target == fragment_shader && state->ARB_texture_rectangle_enable) {
      _mesa_read_profile(state, instructions, 8,
                         prototypes_for_ARB_texture_rectangle_frag,
                         functions_for_ARB_texture_rectangle_frag,
                         Elements(functions_for_ARB_texture_rectangle_frag));
   }

   if (state->target == vertex_shader && state->ARB_texture_rectangle_enable) {
      _mesa_read_profile(state, instructions, 9,
                         prototypes_for_ARB_texture_rectangle_vert,
                         functions_for_ARB_texture_rectangle_vert,
                         Elements(functions_for_ARB_texture_rectangle_vert));
   }

   if (state->target == fragment_shader && state->EXT_texture_array_enable) {
      _mesa_read_profile(state, instructions, 10,
                         prototypes_for_EXT_texture_array_frag,
                         functions_for_EXT_texture_array_frag,
                         Elements(functions_for_EXT_texture_array_frag));
   }

   if (state->target == vertex_shader && state->EXT_texture_array_enable) {
      _mesa_read_profile(state, instructions, 11,
                         prototypes_for_EXT_texture_array_vert,
                         functions_for_EXT_texture_array_vert,
                         Elements(functions_for_EXT_texture_array_vert));
   }

}
