/**************************************************************************
 *
 * Copyright 2010 Luca Barbieri
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER(S) AND/OR ITS SUPPLIERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **************************************************************************/

#include <d3d1xstutil.h>

/* D3D has to keep binary compatibility, so these tables will always work
 * However, Gallium -> D3D conversion must use .[PIPE_xxx] = D3D11_xxx syntax */

pipe_format dxgi_to_pipe_format[DXGI_FORMAT_COUNT] =
{
	PIPE_FORMAT_NONE,
	PIPE_FORMAT_R32G32B32A32_UINT, /* TYPELESS */
	PIPE_FORMAT_R32G32B32A32_FLOAT,
	PIPE_FORMAT_R32G32B32A32_UINT,
	PIPE_FORMAT_R32G32B32A32_SINT,
	PIPE_FORMAT_R32G32B32_UINT, /* TYPELESS */
	PIPE_FORMAT_R32G32B32_FLOAT,
	PIPE_FORMAT_R32G32B32_UINT,
	PIPE_FORMAT_R32G32B32_SINT,
	PIPE_FORMAT_R16G16B16A16_UINT, /* TYPELESS */
	PIPE_FORMAT_R16G16B16A16_FLOAT,
	PIPE_FORMAT_R16G16B16A16_UNORM,
	PIPE_FORMAT_R16G16B16A16_UINT,
	PIPE_FORMAT_R16G16B16A16_SNORM,
	PIPE_FORMAT_R16G16B16A16_SINT,
	PIPE_FORMAT_R32G32_UINT, /* TYPELESS */
	PIPE_FORMAT_R32G32_FLOAT,
	PIPE_FORMAT_R32G32_UINT,
	PIPE_FORMAT_R32G32_SINT,
	PIPE_FORMAT_Z32_FLOAT_S8X24_UINT, /* PIPE_FORMAT_R32_G8X24_TYPELESS */
	PIPE_FORMAT_Z32_FLOAT_S8X24_UINT,
	PIPE_FORMAT_Z32_FLOAT_S8X24_UINT, /* PIPE_FORMAT_R32_X8X24_FLOAT */
	PIPE_FORMAT_Z32_FLOAT_S8X24_UINT, /* PIPE_FORMAT_X32_G8X24_UINT */
	PIPE_FORMAT_R10G10B10A2_UNORM, /* TYPELESS */
	PIPE_FORMAT_R10G10B10A2_UNORM,
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_R10G10B10A2_UINT */
	PIPE_FORMAT_R11G11B10_FLOAT,
	PIPE_FORMAT_R8G8B8A8_UINT, /* TYPELESS */
	PIPE_FORMAT_R8G8B8A8_UNORM,
	PIPE_FORMAT_R8G8B8A8_SRGB,
	PIPE_FORMAT_R8G8B8A8_UINT,
	PIPE_FORMAT_R8G8B8A8_SNORM,
	PIPE_FORMAT_R8G8B8A8_SINT,
	PIPE_FORMAT_R16G16_UINT, /* TYPELESS */
	PIPE_FORMAT_R16G16_FLOAT,
	PIPE_FORMAT_R16G16_UNORM,
	PIPE_FORMAT_R16G16_UINT,
	PIPE_FORMAT_R16G16_SNORM,
	PIPE_FORMAT_R16G16_SINT,
	PIPE_FORMAT_R32_UINT, /* TYPELESS */
	PIPE_FORMAT_Z32_FLOAT,
	PIPE_FORMAT_R32_FLOAT,
	PIPE_FORMAT_R32_UINT,
	PIPE_FORMAT_R32_SINT,
	PIPE_FORMAT_Z24_UNORM_S8_UINT, /* PIPE_FORMAT_R24G8_TYPELESS */
	PIPE_FORMAT_Z24_UNORM_S8_UINT,
	PIPE_FORMAT_Z24X8_UNORM, /* PIPE_FORMAT_R24X8_UNORM */
	PIPE_FORMAT_Z24_UNORM_S8_UINT, /* PIPE_FORMAT_X24G8_UINT */
	PIPE_FORMAT_R8G8_UINT, /* TYPELESS */
	PIPE_FORMAT_R8G8_UNORM,
	PIPE_FORMAT_R8G8_UINT,
	PIPE_FORMAT_R8G8_SNORM,
	PIPE_FORMAT_R8G8_SINT,
	PIPE_FORMAT_R16_UINT, /* TYPELESS */
	PIPE_FORMAT_R16_FLOAT,
	PIPE_FORMAT_Z16_UNORM,
	PIPE_FORMAT_R16_UNORM,
	PIPE_FORMAT_R16_UINT,
	PIPE_FORMAT_R16_SNORM,
	PIPE_FORMAT_R16_SINT,
	PIPE_FORMAT_R8_UINT, /* TYPELESS */
	PIPE_FORMAT_R8_UNORM,
	PIPE_FORMAT_R8_UINT,
	PIPE_FORMAT_R8_SNORM,
	PIPE_FORMAT_R8_SINT,
	PIPE_FORMAT_A8_UNORM,
	PIPE_FORMAT_R1_UNORM,
	PIPE_FORMAT_R9G9B9E5_FLOAT,
	PIPE_FORMAT_R8G8_B8G8_UNORM,
	PIPE_FORMAT_G8R8_G8B8_UNORM,
	PIPE_FORMAT_DXT1_RGBA, /* TYPELESS */
	PIPE_FORMAT_DXT1_RGBA,
	PIPE_FORMAT_DXT1_SRGBA,
	PIPE_FORMAT_DXT3_RGBA, /* TYPELESS */
	PIPE_FORMAT_DXT3_RGBA,
	PIPE_FORMAT_DXT3_SRGBA,
	PIPE_FORMAT_DXT5_RGBA, /* TYPELESS */
	PIPE_FORMAT_DXT5_RGBA,
	PIPE_FORMAT_DXT5_SRGBA,
	PIPE_FORMAT_RGTC1_UNORM, /* TYPELESS */
	PIPE_FORMAT_RGTC1_UNORM,
	PIPE_FORMAT_RGTC1_SNORM,
	PIPE_FORMAT_RGTC2_UNORM, /* TYPELESS */
	PIPE_FORMAT_RGTC2_UNORM,
	PIPE_FORMAT_RGTC2_SNORM,
	PIPE_FORMAT_B5G6R5_UNORM,
	PIPE_FORMAT_B5G5R5A1_UNORM,
	PIPE_FORMAT_B8G8R8A8_UNORM,
	PIPE_FORMAT_B8G8R8X8_UNORM,
	PIPE_FORMAT_R10SG10SB10SA2U_NORM,
	PIPE_FORMAT_B8G8R8A8_UNORM, /* TYPELESS */
	PIPE_FORMAT_B8G8R8A8_SRGB,
	PIPE_FORMAT_B8G8R8X8_UNORM, /* TYPELESS */
	PIPE_FORMAT_B8G8R8X8_SRGB,
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_BC6H_TYPELESS */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_BC6H_UF16 */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_BC6H_SF16 */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_BC7_TYPELESS */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_BC7_UNORM */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_BC7_UNORM_SRGB */
	PIPE_FORMAT_A8R8G8B8_UNORM, /* PIPE_FORMAT_AYUV */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_Y410 */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_Y416 */
	PIPE_FORMAT_NV12,
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_P010 */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_P016 */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_420_OPAQUE */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_YUV2 */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_Y210 */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_Y216 */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_NV11 */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_AI44 (palettized) */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_IA44 (palettized) */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_P8 (palettized) */
	PIPE_FORMAT_NONE, /* PIPE_FORMAT_A8P8 (palettized) */
	PIPE_FORMAT_B4G4R4A4_UNORM,
};

DXGI_FORMAT pipe_to_dxgi_format[PIPE_FORMAT_COUNT];
static int pipe_to_dxgi_format_initialized;
void init_pipe_to_dxgi_format()
{
	if(!pipe_to_dxgi_format_initialized)
	{
		for(unsigned i = 0; i < DXGI_FORMAT_COUNT; ++i)
			pipe_to_dxgi_format[dxgi_to_pipe_format[i]] = (DXGI_FORMAT)i;
		pipe_to_dxgi_format[PIPE_FORMAT_NONE] = DXGI_FORMAT_UNKNOWN;
		pipe_to_dxgi_format[PIPE_FORMAT_Z32_FLOAT_S8X24_UINT] = DXGI_FORMAT_D32_FLOAT_S8X24_UINT;
		pipe_to_dxgi_format[PIPE_FORMAT_Z24_UNORM_S8_UINT] = DXGI_FORMAT_D24_UNORM_S8_UINT;
		pipe_to_dxgi_format_initialized = 1;
	}
}
