/* $XConsortium: xkbcompat.c /main/5 1996/02/05 11:44:47 kaleb $ */
/************************************************************
Copyright (c) 1993 by Silicon Graphics Computer Systems, Inc.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of Silicon Graphics not be 
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
Silicon Graphics makes no representation about the suitability 
of this software for any purpose. It is provided "as is"
without any express or implied warranty.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/XKBlib.h>

#include <X11/extensions/XKBfile.h>

static	Display *	 dpy = NULL;
static	char		*dpyName = NULL;
static	int		 changes = 0;
static	int		 synch   = 0;
static	int		 verbose = 0;
static	unsigned	 debug   = 0;

static void
#if NeedFunctionPrototypes
PrintCompatMap(FILE *file,XkbDescPtr xkb)
#else
PrintCompatMap(file,xkb)
    FILE *file;
    XkbDescPtr xkb;
#endif
{
register int 		i,nOut;
XkbSymInterpretPtr	si;
XkbModsPtr		gcm;

    fprintf(file,"%d symbol interpretations\n",xkb->compat->num_si);
    si= xkb->compat->sym_interpret;
    for (i=0;i<xkb->compat->num_si;i++,si++) {
	register char *name= XKeysymToString(si->sym);
	if (name)	fprintf(file,"%s+",name);
	else if (si->sym==NoSymbol)
			fprintf(file,"Any+");
	else		fprintf(file,"0x%x+",si->sym);
	fprintf(file,"%s(%s) = {\n",XkbSIMatchText(si->match,XkbMessage),
				XkbModMaskText(si->mods,XkbMessage));
	fprintf(file,"    action = %s\n",
		XkbActionText(dpy,xkb,(XkbAction *)&si->act,XkbMessage));
	if (si->flags&XkbSI_AutoRepeat)
	    fprintf(file,"    repeats\n");
	if (si->virtual_mod!=XkbNoModifier)
	    fprintf(file,"    virtual modifier= %s\n",
			XkbVModIndexText(dpy,xkb,si->virtual_mod,XkbMessage));
	fprintf(file,"}\n");
    }
    for (i=nOut=0,gcm=&xkb->compat->groups[0];i<XkbNumKbdGroups;i++,gcm++) {
	if ((gcm->real_mods!=0)||(gcm->vmods!=0)) {
	    if (nOut==0)
		fprintf(file,"Group Compatibility Map:\n");
	    fprintf(file,"group %d:  %s",i+1,XkbVModMaskText(dpy,xkb,
						gcm->real_mods,gcm->vmods,
						XkbMessage));
	    if (gcm->vmods!=0) {
		fprintf(file," (%s)",XkbModMaskText(gcm->mask,XkbMessage));
	    }
	    fprintf(file,"\n");
	    nOut++;
	}
    }
    return;
}

int
#if NeedFunctionPrototypes
parseArgs(int argc,char *argv[])
#else
parseArgs(argc,argv)
    int argc;
    char *argv[];
#endif
{
int i;

    for (i=1;i<argc;i++) {
	if ( strcmp(argv[i],"-display")==0 ) {
	    if ( ++i<argc )	dpyName= argv[i];
	    else {
		fprintf(stderr,"Must specify a display with -display option\n");
		return 0;
	    }
	}
	if ( strcmp(argv[i],"-debug")==0 ) {
	    debug= 1;
	}
	else if ( strcmp(argv[i],"-synch")==0 ) {
	    synch= 1;
	}
	else if ((strcmp(argv[i],"-v")==0) || (strcmp(argv[i],"-verbose")==0)) {
	    verbose= 1;
	}
	else if (strcmp(argv[i],"-help")==0) {
	    return 0;
	}
	else {
	    fprintf(stderr,"Unknown option %s\n",argv[i]);
	    return 0;
	}
    }
    return 1;
}

#define	WANTED_NAMES	(XkbCompatNameMask|XkbVirtualModNamesMask)

int
#if NeedFunctionPrototypes
main(int argc,char *argv[])
#else
main(argc,argv)
    int argc;
    char *argv[];
#endif
{
int		major,minor,why;
XkbDescPtr	xkb;

  
    if (!parseArgs(argc,argv)) {
	fprintf(stderr,"Usage: %s [<options>] \n",argv[0]);
	fprintf(stderr,"Where legal options are:\n");
	fprintf(stderr,"-display  <dpy>     specifies display to use\n");
	fprintf(stderr,"-debug              enable debugging output\n");
	fprintf(stderr,"-synch              force synchronization\n");
	fprintf(stderr,"-verbose            display resulting compat map\n");
	fprintf(stderr,"If no changes are indicated, %s simply reports\n",
								argv[0]);
	fprintf(stderr,"the current state of all compatbility mappings.\n");
	return 1;
    }
    major= XkbMajorVersion;
    minor= XkbMinorVersion;
    dpy = XkbOpenDisplay(dpyName,NULL,NULL,&major,&minor,&why);
    if (dpy==NULL) {
	if (dpyName==NULL)
	    dpyName= "default display";
        switch (why) {
            case XkbOD_BadLibraryVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Xlib supports incompatible version %d.%02d\n",
                                major,minor);
                break;
            case XkbOD_ConnectionRefused:
                fprintf(stderr,"Cannot open display \"%s\"\n",dpyName);
                break;
            case XkbOD_NonXkbServer:
                fprintf(stderr,"XKB extension not present on %s\n",dpyName);
                break;
            case XkbOD_BadServerVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Server %s uses incompatible version %d.%02d\n",
                                dpyName,major,minor);
                break;
            default:
                fprintf(stderr,
		    "Internal Error! Unknown error %d from XkbOpenDisplay\n",
		    why);
        }
	return 1;
    }
    if (synch)
	XSynchronize(dpy,1);
    xkb= XkbGetMap(dpy,0,XkbUseCoreKbd);
    if (!xkb) {
	fprintf(stderr,"Couldn't get keyboard map.\n");
	goto BAIL;
    }
    if (XkbGetCompatMap(dpy,XkbAllCompatMask,xkb)!=Success) {
	fprintf(stderr,"Couldn't get compatibility map.\n");
	goto BAIL;
    }
    if (XkbGetNames(dpy,WANTED_NAMES,xkb)!=Success) {
	fprintf(stderr,"Warning!  Couldn't get names\n");
	fprintf(stderr,"Some things may print funny\n");
    }
    if (changes) {
	/* apply changes to compatibility map here */
    }
    if ((!changes)||verbose)
	PrintCompatMap(stdout,xkb);
    fflush(stdout);
    XCloseDisplay(dpy);
    return 0;
BAIL:
    XCloseDisplay(dpy);
    return 0;
}
