/* $XConsortium: xkbwrbynames.c /main/2 1996/02/05 11:44:59 kaleb $ */
/************************************************************
 Copyright (c) 1995 by Silicon Graphics Computer Systems, Inc.

 Permission to use, copy, modify, and distribute this
 software and its documentation for any purpose and without
 fee is hereby granted, provided that the above copyright
 notice appear in all copies and that both that copyright
 notice and this permission notice appear in supporting
 documentation, and that the name of Silicon Graphics not be 
 used in advertising or publicity pertaining to distribution 
 of the software without specific prior written permission.
 Silicon Graphics makes no representation about the suitability 
 of this software for any purpose. It is provided "as is"
 without any express or implied warranty.
 
 SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
 AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
 GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
 DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
 OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
 THE USE OR PERFORMANCE OF THIS SOFTWARE.

 ********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/XKBlib.h>
#include <X11/extensions/XKM.h>
#include <X11/extensions/XKBfile.h>
#include <X11/extensions/XKBconfig.h>
#include <X11/Xfuncs.h>

Display	*	dpy= NULL;
static	char *	dpyName = NULL;
static	char *	inFileName = NULL;
static  char *	outFileName= NULL;
static	FILE *	inFile= stdin;
static	FILE *	outFile= stdout;
static	int	synch = 0;
static	int	debug = 0;

int
#if NeedFunctionPrototypes
parseArgs(int argc,char *argv[])
#else
parseArgs(argc,argv)
    int 	argc;
    char *	argv[];
#endif
{
int 		i;

    for (i=1;i<argc;i++) {
	 if ((argv[i][0]!='-') || ((argv[i][0]=='-')&&(argv[i][1]=='-'))) {
	    if (inFileName==NULL)	inFileName= argv[i];
	    else if (outFileName==NULL)	outFileName= argv[i];
	    else {
		fprintf(stderr,"Too many files on command line, ignoring %s\n",
								      argv[i]);
	    }
	 }
	 else if ( strcmp(argv[i],"-display")==0 ) {
	    if ( ++i<argc )	dpyName= argv[i];
	    else {
		fprintf(stderr,"Must specify a display with -display option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-synch")==0 ) {
	    synch= 1;
	}
	else if ( strcmp(argv[i],"-debug")==0 ) {
	    debug= 1;
	}
	else {
	    fprintf(stderr,"Unknown option %s\n",argv[i]);
	    return 0;
	}
    }
    if ((inFileName!=NULL)&&(strcmp(inFileName,"--")!=0)) {
	inFile= fopen(inFileName,"r");
	if (!inFile) {
	    fprintf(stderr,"Couldn't open input file %s\n",inFileName);
	    fprintf(stderr,"Exiting\n");
	    exit(1);
	}
    }
    if ((outFileName!=NULL)&&(strcmp(outFileName,"--")!=0)) {
	outFile= fopen(outFileName,"w");
	if (!outFile) {
	    fprintf(stderr,"Couldn't open output file %s\n",outFileName);
	    fprintf(stderr,"Exiting\n");
	    exit(1);
	}
    }
    return 1;
}

Display *
#if NeedFunctionPrototypes
getDisplay(char *program,char *dpyName)
#else
getDisplay(program,dpyName)
    char *	program;
    char *	dpyName;
#endif
{
int		major,minor,error;
Display	*	dpy;

    major= XkbMajorVersion;
    minor= XkbMinorVersion;
    dpy= XkbOpenDisplay(dpyName,NULL,NULL,&major,&minor,&error);
    if (dpy==NULL) {
	if (dpyName==NULL)
	    dpyName= "default display";
	switch (error) {
	    case XkbOD_BadLibraryVersion:
		fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
				program,XkbMajorVersion,XkbMinorVersion);
		fprintf(stderr,"X library uses incompatible version %d.%02d\n",
				major,minor);
		break;
	    case XkbOD_ConnectionRefused:
		fprintf(stderr,"Error! Cannot open display \"%s\"\n",dpyName);
		break;
	    case XkbOD_NonXkbServer:
		fprintf(stderr,"Error! XKB not present on %s\n",dpyName);
		break;
	    case XkbOD_BadServerVersion:
		fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
				program,XkbMajorVersion,XkbMinorVersion);
		fprintf(stderr,"Server %s uses incompatible version %d.%02d\n",
				dpyName,major,minor);
		break;
	    default:
		fprintf(stderr,"Unknown error %d from XkbOpenDisplay\n",error);
	}
    }
    else if (synch)
	XSynchronize(dpy,True);
    return dpy;
}

char *
#if NeedFunctionPrototypes
DupLine(char *str)
#else
DupLine(str)
    char *	str;
#endif
{
char *	tmp;
int	len;
    if ((str==NULL)||(str[0]=='\0')||(str[0]=='\n'))
	return NULL;
    len= strlen(str);
    tmp= (char *)malloc(len+1);
    if (tmp) {
	strcpy(tmp,str);
	tmp[len-1]= '\0';
    }
    return tmp;
}

int
#if NeedFunctionPrototypes
main(int argc,char *argv[])
#else
main(argc,argv)
    int		argc;
    char *	argv[];
#endif
{
XkbDescPtr		xkb;
XkbComponentNamesRec	names;
char			buf[128];

    if (!parseArgs(argc,argv)) {
	fprintf(stderr,"Usage: %s [<options>] infile outfile\n",argv[0]); 
	fprintf(stderr,"Where legal options are:\n");
	fprintf(stderr,"-display  <dpy>     specifies display to use\n");
	fprintf(stderr,"-synch              force synchronization\n");
	return 1;
    }
    if (dpyName)  {
	dpy= getDisplay(argv[0],dpyName);
	if (!dpy) {
	    fprintf(outFile,"Couldn't open server \"%s\"\n",dpyName);
	    return 1;
	}
    }
    if (dpy) {
	XkbFileInfo 		rtrn;
	bzero((char *)&rtrn,sizeof(rtrn));
	XkbReadFromServer(dpy,XkmAllIndicesMask,0,&rtrn);
	xkb= rtrn.xkb;
    }
    else xkb= NULL;
    bzero((char *)&names,sizeof(names));
    printf("Key codes:  "); fgets(buf,127,stdin);
    names.keycodes= DupLine(buf);
    printf("Key types:  "); fgets(buf,127,stdin);
    names.types= DupLine(buf);
    printf("Compat Map: "); fgets(buf,127,stdin);
    names.compat= DupLine(buf);
    printf("Symbols:    "); fgets(buf,127,stdin);
    names.symbols= DupLine(buf);
    printf("Geometry:   "); fgets(buf,127,stdin);
    names.geometry= DupLine(buf);
    if (!XkbWriteXKBKeymapForNames(stdout,&names,dpy,xkb,XkmAllIndicesMask,0))
	printf("write XKB keymap reported failure\n");
    return 0;
}
