.TH Asgi 1 "Release 1"  "AF Version 3"
.SH NAME
\fIAsgi\fP - a network-transparent audio server for SGI Indigo workstations
.SH SYNOPSIS
The AF audio server
is a network transparent  system developed at Digital CRL.
The audio server described in this manual page supports
the SGI Indigo audio hardware and software.
.SH DESCRIPTION
\fIAsgi\fP is an AF server with device dependent support for
SGI Indigo and Indigo2 workstations.
.SH STARTING UP
Asgi [:\fIportOffset\fP] [\fIoptions\fP] &
.SH OPTIONS
.TP
.B \-help
Use the help switch to determine device independent arguments.
.TP
.BI "\-rate " sampling-rate
Specify the sampling rate.  Valid sampling rates are all rates
supported by the SGI Indigo audio hardware: 8000, 11025,
16000, 22050, 32000, 44100 and 48000 samples/sec.  The default is
8000.  The sampling rate is used both for recording and for playback,
and should not be changed using the apanel utility (in fact the server
resets it when it detects it is changed).
.SH "AUDIO DEVICES"
This server supports three devices, which provide different types of
acces to a single audio device: device 0 accepts mono U-LAW samples,
device 1 accepts mono 16-bit linear samples, device 1 accepts stereo
16-bit samples.  (Don't confuse these devices with the
\fIportOffset\fP in the connection name explained below.)
.PP
The hardware has a choice of three input sources: input 0 is the line
input jack, input 1 is the microphone, input 2 is the digital input.
Exactly one of these is selected at any time.
.SH "CONNECTION NAME"
From the user's prospective, every AF server has 
an \fIaudio connection\fP of the form:
.PP
.ce 1
\fIhostname:portOffset\fP
.PP
This information is used by the application to determine how it should
connect to the server.
.TP 8
.I hostname
The \fIhostname\fP specifies the name of the machine to which the 
audio device is physically connected.  If omitted, the local machine
is used and the fastest available protocol is chosen (e.g. UNIX
sockets or shared memory).
.TP 8
.I portOffset
The \fIportOffset\fP is used to identify
the audio server's port on \fIhostname\fP.
For example, to simultaneously run two audio servers on a given host,
you might select \fI0\fP or \fI1\fP for \fIportOffset\fP.
.PP
If the connection name to an audio server is not specified, 
then the environment variables \fIAUDIOFILE\fP or \fIDISPLAY\fP 
will be used.
.SH "ACCESS CONTROL"
The sample server provides two types of access control: an authorization
protocol which provides a list of ``magic cookies'' clients can send to
request access, and a list of hosts from which connections are always
accepted.  
.SH BUGS
At high sampling rates the server uses too much CPU when sounds are
recorded and played.
.PP
If you encounter a \fBrepeatable\fP bug in the SGI dependent code,
please submit a problem report to \fIguido@cwi.nl\fP and include the
source code if possible.
.SH "SEE ALSO"
AF(1)
.br
Aaxp(1), Amaxine(1), Alofi(1), Ajv(1), Asparc(1), Amsb(1), Aj300(1),
aplay(1), arecord(1), apass(1), aset(1), abrowse(1), afft(1),
ahost(1), aphone(1), aprop(1), ahs(1), axset(1), xpow(1), afxctl(1),
aname2num(1), alsatoms(1), aevents(1), abob(1)
.PP
See also apanel(1) and the Digital Audio and MIDI Programming Guide by
Silicon Graphics.
.SH COPYRIGHT
See the COPYRIGHTS file.
.PP
Copyright 1991-1993, Digital Equipment Corporation and
the Massachusetts Institute of Technology.
.PP
SGI device dependent code:
.PP
Copyright 1993 by Stichting Mathematisch Centrum, Amsterdam, The Netherlands.
.PP
.ce 1
All Rights Reserved
.PP
Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.
.PP
STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.SH AUTHORS
Digital Cambridge Research Lab (device-independent code)
.br
Guido van Rossum, CWI, Amsterdam (SGI device-dependent code)
