.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH intel  __drivermansuffix__ __vendorversion__
.SH NAME
intel \- Intel integrated graphics chipsets
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qintel\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B intel
is an __xservername__ driver for Intel integrated graphics chipsets.
The driver supports depths 8, 15, 16 and 24.  All visual types are
supported in depth 8.  For the i810/i815 other depths support the
TrueColor and DirectColor visuals.  For the i830M and later, only the
TrueColor visual is supported for depths greater than 8.  The driver
supports hardware accelerated 3D via the Direct Rendering Infrastructure
(DRI), but only in depth 16 for the i810/i815 and depths 16 and 24 for
the 830M and later.
.SH SUPPORTED HARDWARE
.B intel
supports the i810, i810-DC100, i810e, i815, i830M, 845G, 852GM, 855GM,
865G, 915G, 915GM, 945G, 945GM, 965G, 965Q, 946GZ, 965GM, 945GME,
G33, Q33, Q35, G35, GM45, G45, Q45, G43, G41 chipsets, and Pineview-M in
Atom N400 series, Pineview-D in Atom D400/D500 series.

.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The Intel 8xx and 9xx families of integrated graphics chipsets have a unified
memory architecture meaning that system memory is used as video RAM.  For the
i810 and i815 family of chipsets, operating system support for allocating system
memory is required in order to use this driver.  For the 830M
and later, this is required in order for the driver to use more video RAM
than has been pre-allocated at boot time by the BIOS.  This is usually
achieved with an "agpgart" or "agp" kernel driver.  Linux, FreeBSD, OpenBSD,
NetBSD, and Solaris have such kernel drivers available.
.PP
By default, the i810/i815 will use 8 MB of system memory for graphics if AGP
allocable memory is < 128 MB, 16 MB if < 192 MB or 24 MB if higher. Use the
.B VideoRam
option to change the default value.
.PP
For the 830M and later, the driver will automatically size its memory
allocation according to the features it will support.  Therefore, the
.B VideoRam
option, which in the past had been necessary to allow more than some small
amount of memory to be allocated, is now ignored.
.PP
The following driver
.B Options
are supported
.TP
.BI "Option \*qColorKey\*q \*q" integer \*q
This sets the default pixel value for the YUV video overlay key.
.IP
Default: undefined.
.TP
.BI "Option \*qDRI\*q \*q" boolean \*q
Disable or enable DRI support.
.IP
Default: DRI is enabled for configurations where it is supported.

.PP
The following driver
.B Options
are supported for the i810 and i815 chipsets:
.TP
.BI "Option \*qCacheLines\*q \*q" integer \*q
This allows the user to change the amount of graphics memory used for
2D acceleration and video when XAA acceleration is enabled.  Decreasing this
amount leaves more for 3D textures.  Increasing it can improve 2D performance
at the expense of 3D performance.
.IP
Default: depends on the resolution, depth, and available video memory.  The
driver attempts to allocate space for at 3 screenfuls of pixmaps plus an
HD-sized XV video.  The default used for a specific configuration can be found
by examining the __xservername__ log file.
.TP
.BI "Option \*qDDC\*q \*q" boolean \*q
Disable or enable DDC support.
.IP
Default: enabled.
.TP
.BI "Option \*qDac6Bit\*q \*q" boolean \*q
Enable or disable 6-bits per RGB for 8-bit modes.
.IP
Default: 8-bits per RGB for 8-bit modes.
.TP
.BI "Option \*qXvMCSurfaces\*q \*q" integer \*q
This option enables XvMC.  The integer parameter specifies the number of
surfaces to use.  Valid values are 6 and 7.
.IP
Default: XvMC is disabled.
.TP
.BI "VideoRam " integer
This option specifies the amount of system memory to use for graphics, in KB.
.IP
The default is 8192 if AGP allocable memory is < 128 MB, 16384 if < 192 MB,
24576 if higher. DRI require at least a value of 16384. Higher values may give
better 3D performance, at expense of available system memory.
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable acceleration.
.IP
Default: acceleration is enabled.

.PP
The following driver
.B Options
are supported for the 830M and later chipsets:
.TP
.BI "Option \*qVideoKey\*q \*q" integer \*q
This is the same as the
.B \*qColorKey\*q
option described above.  It is provided for compatibility with most
other drivers.
.TP
.BI "Option \*qXvPreferOverlay\*q \*q" boolean \*q
Make hardware overlay be the first XV adaptor.
The overlay behaves incorrectly in the presence of compositing, but some prefer
it due to it syncing to vblank in the absence of compositing.  While most
XV-using applications have options to select which XV adaptor to use, this
option can be used to place the overlay first for applications which don't
have options for selecting adaptors.
.IP
Default: Textured video adaptor is preferred.
.TP
.BI "Option \*Backlight\*q \*q" string \*q
Override the probed backlight control interface. Sometimes the automatically
selected backlight interface may not correspond to the correct, or simply
most useful, interface available on the system. This allows you to override
by specifying the entry under /sys/class/backlight to use.
server log.
.IP
Default: Automatic selection.
.TP
.BI "Option \*qFallbackDebug\*q \*q" boolean \*q
Enable printing of debugging information on acceleration fallbacks to the
server log.
.IP
Default: Disabled
.TP
.BI "Option \*qDebugFlushBatches\*q \*q" boolean \*q
Flush the batch buffer after every single operation.
.IP
Default: Disabled
.TP
.BI "Option \*qDebugFlushCaches\*q \*q" boolean \*q
Include an MI_FLUSH at the end of every batch buffer to force data to
be flushed out of cache and into memory before the completion of the
batch.
.IP
Default: Disabled
.TP
.BI "Option \*qDebugWait\*q \*q" boolean \*q
Wait for the completion of every batch buffer before continuing,
i.e. perform synchronous rendering.
.IP
Default: Disabled
.TP
.TP
.BI "Option \*qSwapbuffersWait\*q \*q" boolean \*q
This option controls the behavior of glXSwapBuffers and glXCopySubBufferMESA
calls by GL applications.  If enabled, the calls will avoid tearing by making
sure the display scanline is outside of the area to be copied before the copy
occurs.  If disabled, no scanline synchronization is performed, meaning tearing
will likely occur.  Note that when enabled, this option can adversely affect
the framerate of applications that render frames at less than refresh rate.
.IP
Default: enabled.
.TP
.BI "Option \*qTripleBuffer\*q \*q" boolean \*q
This option enables the use of a third buffer for page-flipping. The third
buffer allows applications to run at vrefresh rates even if they occasionally
fail to swapbuffers on time. The effect of such missed swaps is the output
jitters between 60fps and 30fps, and in the worst case appears frame-locked
to 30fps. The disadvantage of triple buffering is that there is an extra
frame of latency, due to the pre-rendered frame sitting in the swap queue,
between input and any display update.
.IP
Default: enabled.
.TP
.BI "Option \*qTiling\*q \*q" boolean \*q
This option controls whether memory buffers for Pixmaps are allocated in tiled mode.  In
most cases (especially for complex rendering), tiling dramatically improves
performance.
.IP
Default: enabled.
.TP
.BI "Option \*qLinearFramebuffer\*q \*q" boolean \*q
This option controls whether the memory for the scanout (also known as the
front or frame buffer) is allocated in linear memory. A tiled framebuffer is
required for power conservation features, but for certain system configurations
you may wish to override this and force a linear layout.
.IP
Default: disabled
.TP
.BI "Option \*qRelaxedFencing\*q \*q" boolean \*q
This option controls whether we attempt to allocate the minimal amount of
memory required for the buffers. The reduction in working set has a substantial
improvement on system performance. However, this has been demonstrate to be
buggy on older hardware (845-865 and 915-945, but ok on PineView and later)
so on those chipsets defaults to off.
.IP
Default: Enabled for G33 (includes PineView), and later, class machines.
.TP
.BI "Option \*qXvMC\*q \*q" boolean \*q
Enable XvMC driver. Current support MPEG2 MC on 915/945 and G33 series.
User should provide absolute path to libIntelXvMC.so in XvMCConfig file.
.IP
Default: Disabled.
.TP
.BI "Option \*qThrottle\*q \*q" boolean \*q
This option controls whether the driver periodically waits for pending
drawing operations to complete. Throttling ensures that the GPU does not
lag too far behind the CPU and thus noticeable delays in user responsible at
the cost of throughput performance.
.IP
Default: enabled.
.TP
.BI "Option \*qHotPlug\*q \*q" boolean \*q
This option controls whether the driver automatically notifies
applications when monitors are connected or disconnected.
.IP
Default: enabled.
.TP
.BI "Option \*qZaphodHeads\*q \*q" string \*q
.IP
Specify the randr output(s) to use with zaphod mode for a particular driver
instance.  If you this option you must use it with all instances of the
driver
.br
For example:
.B
Option \*qZaphodHeads\*q \*qLVDS1,VGA1\*q
will assign xrandr outputs LVDS1 and VGA0 to this instance of the driver.

.SH OUTPUT CONFIGURATION
On 830M and better chipsets, the driver supports runtime configuration of
detected outputs.  You can use the
.B xrandr
tool to control outputs on the command line as follows:

.RS
.B xrandr \-\-output
.I output
.B \-\-set
.I property value
.RE

Note that you may need to quote property and value arguments that contain spaces.
Each output listed below may have one or more properties associated
with it (like a binary EDID block if one is found).  Some outputs have
unique properties which are described below.  See the "MULTIHEAD
CONFIGURATIONS" section below for additional information.
.SS "VGA"
VGA output port (typically exposed via an HD15 connector).

.SS "LVDS"
Low Voltage Differential Signalling output (typically a laptop LCD panel).  Available properties:

.TP
\fBBACKLIGHT\fB - current backlight level (adjustable)
By adjusting the BACKLIGHT property, the brightness on the LVDS output
can be adjusted.  In some cases, this property may be unavailable (for
example if your platform uses an external microcontroller to control
the backlight).
.TP
\fBscaling mode\fP - control LCD panel scaling mode
When the currently selected display mode differs from the native panel
resolution, various scaling options are available. These include
.RS
.TP
.B Center
Simply center the image on-screen without scaling. This is the only
scaling mode that guarantees a one-to-one correspondence between
native and displayed pixels, but some portions of the panel may be
unused (so-called "letterboxing").
.TP
.B Full aspect
Scale the image as much as possible while preserving aspect
ratio. Pixels may not be displayed one-to-one (there may be some
blurriness). Some portions of the panel may be unused if the aspect
ratio of the selected mode does not match that of the panel.
.TP
.B Full
Scale the image to the panel size without regard to aspect ratio. This
is the only mode which guarantees that every pixel of the panel will
be used. But the displayed image may be distorted by stretching either
horizontally or vertically, and pixels may not be displayed one-to-one
(there may be some blurriness).
.RE

The precise names of these options may differ depending on the kernel
video driver, (but the functionality should be similar). See the
output of
.B xrandr \-\-prop
for a list of currently available scaling modes.
.SS "TV"
Integrated TV output.  Available properties include:
.TP
\fBBOTTOM, RIGHT, TOP, LEFT\fP - margins
Adjusting these properties allows you to control the placement of your
TV output buffer on the screen. The options with the same name can
also be set in xorg.conf with integer value.
.TP
\fBBRIGHTNESS\fP - TV brightness, range 0-255
Adjust TV brightness, default value is 128.
.TP
\fBCONTRAST\fP - TV contrast, range 0-255
Adjust TV contrast, default value is 1.0 in chipset specific format.
.TP
\fBSATURATION\fP - TV saturation, range 0-255
Adjust TV saturation, default value is 1.0 in chipset specific format.
.TP
\fBHUE\fP - TV hue, range 0-255
Adjust TV hue, default value is 0.
.TP
\fBTV_FORMAT\fP - output standard
This property allows you to control the output standard used on your
TV output port.  You can select between NTSC-M, NTSC-443, NTSC-J,
PAL-M, PAL-N, and PAL.
.TP
\fBTV_Connector\fP - connector type
This config option should be added to xorg.conf TV monitor's section,
it allows you to force the TV output connector type, which bypass load
detect and TV will always be taken as connected. You can select
between S-Video, Composite and Component.

.SS "TMDS-1"
First DVI SDVO output

.SS "TMDS-2"
Second DVI SDVO output

.SS "TMDS-1", "TMDS-2", "HDMI-1", "HDMI-2"
DVI/HDMI outputs. Avaliable common properties include:
.TP
\fBBROADCAST_RGB\fP - method used to set RGB color range
Adjusting this property allows you to set RGB color range on each
channel in order to match HDTV requirment(default 0 for full
range). Setting 1 means RGB color range is 16-235, 0 means RGB color
range is 0-255 on each channel.  (Full range is 0-255, not 16-235)

.PP
SDVO and DVO TV outputs are not supported by the driver at this time.
.PP
See __xconfigfile__(__filemansuffix__) for information on associating Monitor
sections with these outputs for configuration.  Associating Monitor sections
with each output can be helpful if you need to ignore a specific output, for
example, or statically configure an extended desktop monitor layout.

.SH MULTIHEAD CONFIGURATIONS

The number of independent outputs is dictated by the number of CRTCs
(in X parlance) a given chip supports.  Most recent Intel chips have
two CRTCs, meaning that two separate framebuffers can be displayed
simultaneously, in an extended desktop configuration.  If a chip
supports more outputs than it has CRTCs (say local flat panel, VGA and
TV in the case of many outputs), two of the outputs will have to be
"cloned", meaning that they display the same framebuffer contents (or
one displays a subset of another's framebuffer if the modes aren't
equal).

You can use the "xrandr" tool, or various desktop utilities, to change
your output configuration at runtime.  To statically configure your
outputs, you can use the "Monitor-<type>" options along with
additional monitor sections in your xorg.conf to create your screen
topology.  The example below puts the VGA output to the right of the
builtin laptop screen, both running at 1024x768.

.nf
.B "Section \*qMonitor\*q"
.BI "  Identifier \*qLaptop FooBar Internal Display\*q"
.BI "  Option \*qPosition\*q \*q0 0\*q"
.B "EndSection"

.B "Section \*qMonitor\*q"
.BI "  Identifier \*qSome Random CRT\*q"
.BI "  Option \*qPosition\*q \*q1024 0\*q"
.BI "  Option \*qRightOf\*q \*qLaptop FoodBar Internal Display\*q"
.B "EndSection"

.B "Section \*qDevice\*q"
.BI "  Driver \*qintel\*q"
.BI "  Option \*qmonitor-LVDS\*q \*qLaptop FooBar Internal Display\*q"
.BI "  Option \*qmonitor-VGA\*q \*qSome Random CRT\*q"
.B "EndSection"

.SH TEXTURED VIDEO ATTRIBUTES
The driver supports the following X11 Xv attributes for Textured Video.
You can use the "xvattr" tool to query/set those attributes at runtime.

.SS "XV_SYNC_TO_VBLANK"
XV_SYNC_TO_VBLANK is used to control whether textured adapter synchronizes 
the screen update to the vblank to eliminate tearing. It is a Boolean
attribute with values of 0 (never sync) or 1 (always sync). An historic
value of -1 (sync for large windows only) will now be interpreted as 1,
(since the current approach for sync is not costly even with small
video windows).

.SS "XV_BRIGHTNESS"
        
.SS "XV_CONTRAST"
        
.SH REPORTING BUGS

The xf86-video-intel driver is part of the X.Org and Freedesktop.org
umbrella projects.  Details on bug reporting can be found at
http://www.intellinuxgraphics.org/how_to_report_bug.html.  Mailing
lists are also commonly used to report experiences and ask questions
about configuration and other topics.  See lists.freedesktop.org for
more information (the xorg@lists.freedesktop.org mailing list is the
most appropriate place to ask X.Org and driver related questions).

.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.SH AUTHORS
Authors include: Keith Whitwell, and also Jonathan Bian, Matthew J Sottek,
Jeff Hartmann, Mark Vojkovich, Alan Hourihane, H. J. Lu.  830M and 845G
support reworked for XFree86 4.3 by David Dawes and Keith Whitwell.  852GM,
855GM, and 865G support added by David Dawes and Keith Whitwell.  915G,
915GM, 945G, 945GM, 965G, 965Q and 946GZ support added by Alan Hourihane and
Keith Whitwell. Lid status support added by Alan Hourihane. Textured video
support for 915G and later chips, RandR 1.2 and hardware modesetting added
by Eric Anholt and Keith Packard. EXA and Render acceleration added by Wang
Zhenyu. TV out support added by Zou Nan Hai and Keith Packard. 965GM, G33,
Q33, and Q35 support added by Wang Zhenyu.
