.\" radeonhd.man based on formatting used in the xf86-video-{ati,nv} radeon.man, nv.man
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.\"
.\"
.TH RADEONHD __drivermansuffix__ __vendorversion__
.\"
.\"
.SH NAME
radeonhd \- AMD GPG (ATI) R5xx/R6xx video driver
.\"
.\"
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qradeonhd\*q"
\ \ ...
.B EndSection
.fi
.\"
.\"
.SH DESCRIPTION
.B radeonhd
is an __xservername__ driver for AMD GPG (ATI) R5xx/R6xx based video cards.

.B "RADEONHD is still very much work in progress."

At the time of this writing,
.B radeonhd
has the following major limitations:
.\".TP "\w'\fB\(bu\fR'u+1n"
.TP 2
\(bu
.B NO
support for 2D & 3D acceleration, no support for Xvideo.
.TP
\(bu
No TV, Component, and HDMI connector support so far.
.TP
\(bu
Suspend & Resume is pretty much untested. Often it just works, but your
milage may vary.
.TP
\(bu
After using the
.I fglrx
driver, the display can get very jittery with
.BR radeonhd .
Also suspend & resume will probably fail.  A reboot fixes this problem in most
cases, sometimes a powercycle is necessary.  Unloading the kernel module is
typically not enough.
.PP
A more up-to-date list can be found on the wiki page.
.PP
.\"
.SH SUPPORTED HARDWARE
The
.B radeonhd
driver supports video cards based on the following ATI chips:
.\" The following list was generated from "X -logverbose 7" by the following command:
.\" sed -n '/^\t[RM][A-Z0-9]\+ * : /{ s/\.$//; s/^\t\([A-Z0-9]\+\) \+: \(.*\)/.TP 8\n.B \1\n\2/; p};' /var/log/Xorg.0.log
.\" The list replicates the output of RHDIdentify() in src/rhd_id.c.
.PP
.PD 0
.TP 8
.B RV505
Radeon X1550, X1550 64bit
.TP 8
.B RV515
Radeon X1300, X1550, X1600; FireGL V3300, V3350
.TP 8
.B RV516
Radeon X1300, X1550, X1550 64-bit, X1600; FireMV 2250
.TP 8
.B R520
Radeon X1800; FireGL V5300, V7200, V7300, V7350
.TP 8
.B RV530
Radeon X1300 XT, X1600, X1600 Pro, X1650; FireGL V3400, V5200
.TP 8
.B RV535
Radeon X1300, X1650
.TP 8
.B RV550
Radeon X2300 HD
.TP 8
.B RV560
Radeon X1650
.TP 8
.B RV570
Radeon X1950, X1950 GT; FireGL V7400
.TP 8
.B R580
Radeon X1900, X1950; AMD Stream Processor
.TP 8
.B R600
Radeon HD 2900 GT/Pro/XT; FireGL V7600/V8600/V8650
.TP 8
.B RV610
Radeon HD 2350, HD 2400 Pro/XT, HD 2400 Pro AGP; FireGL V4000
.TP 8
.B RV630
Radeon HD 2600 LE/Pro/XT, HD 2600 Pro/XT AGP; Gemini RV630; FireGL V3600/V5600
.TP 8
.B RV670
Radeon HD 3850, HD 3870, FireGL V7700
.TP 8
.B M52
Mobility Radeon X1300
.TP 8
.B M54
Mobility Radeon X1400; M54-GL
.TP 8
.B M56
Mobility Radeon X1600; Mobility FireGL V5200
.TP 8
.B M58
Mobility Radeon X1800, X1800 XT; Mobility FireGL V7100, V7200
.TP 8
.B M62
Mobility Radeon X1350
.TP 8
.B M64
Mobility Radeon X1450, X2300
.TP 8
.B M66
Mobility Radeon X1700, X1700 XT; FireGL V5250
.TP 8
.B M68
Mobility Radeon X1900
.TP 8
.B M71
Mobility Radeon HD 2300
.TP 8
.B M72
Mobility Radeon HD 2400; Radeon E2400
.TP 8
.B M74
Mobility Radeon HD 2400 XT
.TP 8
.B M76
Mobility Radeon HD 2600; (Gemini ATI) Mobility Radeon HD 2600 XT
.TP 8
.B RS600
Radeon Xpress 1200, Xpress 1250
.TP 8
.B RS690
Radeon X1200, X1250, X1270
.PD
.\"
.\"
.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general
configuration details.  This section only covers configuration options
specific to this driver. Some options may be deprecated and considered to be
removed or replaced by better implementations soon.
.\"
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Enable or disable the software cursor. The hardware cursor is inactive
when the software cursor is enabled. The default is
.BR off .
.TP
.BI "Option \*qNoAccel\*q
Disable all hardware accleration. The default is to
.B enable
hardware acceleration.
.br
.B Acceleration is not implemented yet, so this option is ignored
.B for the moment.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable shadow framebuffer support. This greatly improves the
speed of unaccelerated drivers. The default is
.B on
as long as acceleration is not supported.
.TP
.BI "Option \*qNoRandr\*q
Disable RandR 1.2 support. This turns the driver back to use standard
modesetting behavior. The default is to
.B enable
RandR 1.2 support.
.TP
.BI "Option \*qForceReduced\*q \*q" boolean \*q
Force the use of reduced blanking modes. Use this if your LCD monitor does not
provide correct EDID data and you need a reduced blanking mode to drive a high
resolution mode over a single link DVI connection. The default is
.BR off .
.TP
.BI "Option \*qHPD\*q \*q" "hpd-mode" \*q
Change the use of the hot plug detection (HPD) pins. On R5xx the according
connector tables are often broken and have to be worked around.
.RS
.TP 8
.PD 0
.B Auto
Select method depending on chipset and board
.TP
.B Off
Don't use HPD pins. Some connectors might not be able to detect connections
at all
.TP
.B Normal
Use connector table information as-is
.TP
.B Swap
Swap HPD pin 1 and 2 in connector table
.RE
.RS
.PD
.PP
.B NOTE:
Use of this option is discouraged. Whenever this option is needed to detect
connected monitors correctly, please report to the mailing list.
The default is
.BR Auto .
.RE
.TP
.BI "Option \*qRRUseXF86Edid\*q \*q" boolean \*q
.IR "RandR modesetting only" .
.br
Enable or disable the use of xf86OutputGetEDID() and xf86OutputGetEDIDModes()
instead of the default routines from
.BR radeonhd ,
which are better adapted to the chipset. Panels will often fail to work with
these calls. The default is
.BR off .
.PP
.RS
.B NOTE:
Use of this option is considered deprecated. Report to the mailing list
if this is needed for your configuration.
.RE
.TP
.BI "Option \*qRROutputOrder\*q \*q" "list-of-outputs" \*q
.IR "RandR modesetting only" .
.br
Several legacy application rely on the Xinerama extension to determine the
primary screen. RandR returns the viewport displayed on the first attached
output of the internal table as the first Xinerama screen.
If your outputs are ordered in the wrong way, you can reorder them by adding
their names (separated by spaces or commas) to the
.IR list-of-outputs .
Typically only the first (primary) output has to be listed, remaining
outputs are added automatically. The default is
.BR none .
.TP
.BI "Option \*qIgnoreConnector\*q \*q" string \*q
.IR "Standard (non-RandR) modesetting only" .
.br
Connector to be ignored during non-RandR modesetting. The default is
.BR none .
.TP
.BI "Option \*qUseConfiguredMonitor\*q \*q" boolean \*q
.IR "Standard (non-RandR) modesetting only" .
.br
Use or ignore the monitor section in
.IR xorg.conf .
In standard modesetting
.B radeonhd
ignores the EDID data if a monitor section is configured.  This is different
to what most drivers behave like and a common source of configuration problems.
Thus the default is
.B off
(i.e. ignore).
.\"
.\"
.SH RANDR OUTPUT PROPERTIES
The following properties can be queried with
.B xrandr --prop
and some of them can be set with
.BR "xrandr --output" " <output> " --set " <property> <value> ."
Those marked with RR13 are probably merged into a RandR 1.3 standard.
Properties marked Read-Only are provided by the driver for informational
purpose only, those marked Static won't change during runtime.
.TP
.BR RANDR_SIGNAL_FORMAT "   Read-Only RR13"
.RS
.TP 16
.PD 0
.IR Type :
string
.TP
.IR Range/List :
unknown VGA TMDS LVDS FBAS FBAS-PAL FBAS-NTSC FBAS-SECAM SVideo YPbPr
DisplayPort
.RE
.RS
.PD
.PP
Signal format / physical protocol format that is used for the specified
output.
.br
A driver MAY change this property of an output if the underlying hardware
indicates a protocol change (e.g. TV formats).  Values with dashes
.RI ( FBAS-PAL )
describe more specific versions of the base values
.RI ( FBAS )
and SHOULD be used if known to the driver.
.RE
.TP
.BR RANDR_CONNECTOR_TYPE "   Read-Only Static RR13"
.RS
.TP 16
.PD 0
.IR Type :
string
.TP
.IR Range/List :
unknown VGA DVI DVI-I DVI-A DVI-D HDMI PANEL TV TV-FBAS TV-SVideo TV-YPbPr
TV-SCART TV-C4 DisplayPort
.RE
.RS
.PD
.PP
Connector type, as far as known to the driver.
.br
Values with dashes
.RI ( TV-FBAS )
describe more specific versions of the base values
.RI ( TV ).
The former SHOULD be used if the connector is not capable of producing other
signal formats. The later SHOULD be used if the exact connector is unknown, or
the connector is a multi-format connector that is not described otherwise.
.IR DVI ,
for instance, SHOULD be handled like a
.I DVI-I
connector, unless additional information is available to the user agent.
.I PANEL
describes laptop-internal (normally LVDS) displays.
.IR TV ,
.IR TV-SCART ,
.IR TV-YPbPr ,
and
.I TV-C4
with signal format
.I VGA
are valid combinations and describe RGB TV signals.
.RE
.TP
.BR RANDR_CONNECTOR_NUMBER "   Read-Only Static RR13"
.RS
.TP 16
.PD 0
.IR Type :
int32
.TP
.IR Range/List :
0-
.RE
.RS
.PD
.PP
Outputs that route their signal to the same connector MUST have the same
connector number. Outputs with the same connector number MUST route their
signal to the same connector, except if it is 0, which indicates unknown
connectivity. 1 is called the primary connector, 2 the secondary. 3 is often a
TV connector, but that is completely driver / hardware dependent.
.br
Outputs with the same connector number SHOULD have the same connector type.
Meaning and client behavior for mismatching connector types is undefined at
the moment.
.RE
.TP
.BR RANDR_OUTPUT_NUMBER "   Read-Only Static RR13"
.RS
.TP 16
.PD 0
.IR Type :
int32
.TP
.IR Range/List :
0-
.RE
.RS
.PD
.PP
A card may route one internal output to several connectors.  Connectors that
are driven by the same output cannot be driven by different Crtcs and are thus
only allowed to be used in clone mode. The driver SHOULD emit an error message
and continue as gracefully as possible if using different Crtcs for the same
internal output is requested.
.br
Internal outputs are numbered from 1, 0 indicates that output routing is
unknown.
.RE
.TP
.B RANDR_PANING_AREA
.RS
.TP 16
.PD 0
.IR Type :
string
.TP
.IR Format :
.RB <width> x <height>[ + <xoffset> + <yoffset>]
.RE
.RS
.PD
.PP
Specifies the panning area in RandR mode per output.
.br
It actually is a Crtc-specific property, but RandR doesn't support that yet.
As the
.B xrandr
application typically always resets the framebuffer size with every action,
.BR --fb " <width>" x <height>
has to be added on every invocation, unless there is an additional output
configured that is using this size as its resolution.
.\"
.\"
.SH KNOWN BUGS
As the
.B radeonhd
driver is still in an early stage of development, many non-obvious things
do not work yet. A list of major known bugs is maintained on the wiki.
Other places to check for known bugs and solutions are the bugtracker at
.br
.nf
\%https://bugs.freedesktop.org/query.cgi?product=xorg&component=Driver/radeonhd
.br
.fi
and the mailing list archives at
\%http://lists.opensuse.org/radeonhd/
.PP
radeonhd development caused a few bugs in __xservername__ and a number
of bugs in xrandr(__appmansuffix__) to be discovered. If you are using
xrandr(__appmansuffix__) versions older than 2007-11-10, you should try
updating xrandr(__appmansuffix__).
.br
Alternatively, you can try to always specify different CRTCs for
all monitors by explicitly selecting them with
.I --crtc [0|1]
on the xrandr(__appmansuffix__) command line.
.\"
.\"
.SH SEE ALSO
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.IP " 1." 4
The official radeonhd wiki
.RS 4
\%http://wiki.x.org/wiki/radeonhd
.RE
.IP " 2." 4
The radeonhd mailing list
.RS 4
\%http://lists.opensuse.org/radeonhd/
.RE
.IP " 3." 4
Overview about radeonhd development code
.RS 4
\%http://gitweb.freedesktop.org/?p=xorg/driver/xf86-video-radeonhd
.RE
.IP " 4." 4
Query the bugtracker for radeonhd bugs
.RS 4
.nf
\%https://bugs.freedesktop.org/query.cgi?\:product=\:xorg&\:component=\:Driver/radeonhd
.fi
.RE
.\"
.\"
.SH AUTHORS
Driver written by Egbert Eich, Luc Verhaegen, Matthias Hopf, and others.
.PP
Man page written by Hans Ulrich Niedermann, Matthias Hopf, and others.
.\" vim: syntax=nroff
