'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbAllocControls __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAllocControls \- Allocates an XkbControlsRec structure in the XkbDescRec
.SH SYNOPSIS
.B Status XkbAllocControls
(
.I xkb,
.I which
)
.br
      XkbDescPtr \fIxkb\fP\^;
.br
      unsigned int \fIwhich\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
Xkb description in which to allocate ctrls rec
.TP
.I \- which
mask of components of ctrls to allocate
.SH DESCRIPTION
.LP
The need to allocate an XkbControlsRec structure seldom arises; Xkb creates one 
when an application calls 
.I XkbGetControls 
or a related function. For those situations where there is not an XkbControlsRec 
structure allocated in the XkbDescRec, allocate one by calling 
.I XkbAllocControls.

.I XkbAllocControls 
allocates the 
.I ctrls 
field of the 
.I xkb 
parameter, initializes all fields to zero, and returns Success. If the 
.I ctrls 
field is not NULL, 
.I XkbAllocControls 
simply returns Success. If 
.I xkb 
is NULL, 
.I XkbAllocControls 
reports a BadMatch error. If the 
.I ctrls 
field could not be allocated, it reports a BadAlloc error.

The 
.I which 
mask specifies the individual fields of the 
.I ctrls 
structure to be allocated and can contain any of the valid masks defined in 
Table 1. 
(SHOULD THIS COMMENT BE LEFT IN????)
Because none of the currently existing controls have any structures associated 
with them, which is currently of little practical value in this call.

Table 1 shows the actual values for the individual mask bits used to select 
controls for 
modification and to enable and disable the control. Note that the same mask bit 
is used to 
specify general modifications to the parameters used to configure the control 
(which), and to 
enable and disable the control (enabled_ctrls). The anomalies in the table (no 
"ok" in column) 
are for controls that have no configurable attributes; and for controls that are 
not boolean 
controls and therefore cannot be enabled or disabled.

.TS
c s s s
l l l l
l l l l
l l l l. 
Table 1 Controls Mask Bits
_
Mask Bit	which or	enabled	Value
	changed_ctrls	_ctrls
_
XkbRepeatKeysMask	ok	ok	(1L<<0)
XkbSlowKeysMask	ok	ok	(1L<<1)
XkbBounceKeysMask	ok	ok	(1L<<2)
XkbStickyKeysMask	ok	ok	(1L<<3)
XkbMouseKeysMask	ok	ok	(1L<<4)
XkbMouseKeysAccelMask	ok	ok	(1L<<5)
XkbAccessXKeysMask	ok	ok	(1L<<6)
XkbAccessXTimeoutMask	ok	ok	(1L<<7)
XkbAccessXFeedbackMask	ok	ok	(1L<<8)
XkbAudibleBellMask		ok	(1L<<9)
XkbOverlay1Mask		ok	(1L<<10)
XkbOverlay2Mask		ok	(1L<<11)
XkbIgnoreGroupLockMask		ok	(1L<<12)
XkbGroupsWrapMask	ok		(1L<<27)
XkbInternalModsMask	ok		(1L<<28)
XkbIgnoreLockModsMask	ok		(1L<<29)
XkbPerKeyRepeatMask	ok		(1L<<30)
XkbControlsEnabledMask	ok		(1L<<31)
XkbAccessXOptionsMask	ok	ok	(XkbStickyKeysMask | 
			XkbAccessXFeedbackMask)
XkbAllBooleanCtrlsMask		ok	(0x00001FFF) 
XkbAllControlsMask	ok		(0xF8001FFF)
.TE
.nh
.SH "RETURN VALUES"
.TP 15
SUCCESS
allocates the ctrls field of the xkb parameter, initializes all fields to zero
.sp
.in 20
the ctrls field is not NULL
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has 
correct type and range, but is otherwise invalid
.SH "SEE ALSO"
.BR XkbGetControls (__libmansuffix__)
