.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbChangeTypesOfKey __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbChangeTypesOfKey \- Obtain the behaviors (the behaviors array) for a subset of the keys in 
a keyboard description from the server
.SH SYNOPSIS
.HP
.B Status XkbChangeTypesOfKey
.BI "(\^Display *" "dpy" "\^,"
.BI "unsigned int " "first" "\^,"
.BI "unsigned int " "num" "\^,"
.BI "XkbDescPtr " "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to server
.TP
.I \- first
keycode of first key to get
.TP
.I \- num
number of keys for which behaviors are desired
.TP
.I \- xkb
Xkb description to contain the result
.SH DESCRIPTION
.LP
.I XkbGetKeyBehaviors 
sends a request to the server to obtain the behaviors for 
.I num 
keys on the keyboard starting with the key whose keycode is 
.I first. 
It waits for a reply and returns the behaviors in the 
.I server->behaviors 
field of 
.I xkb. 
If successful, 
.I XkbGetKeyBehaviors 
returns Success.

If the 
.I server 
map in the 
.I xkb 
parameter has not been allocated, 
.I XkbGetKeyBehaviors 
allocates and initializes it before obtaining the actions.

If the server does not have a compatible version of Xkb, or the Xkb extension has not been 
properly initialized, 
.I XkbGetKeyBehaviors 
returns BadAccess. If 
.I num 
is less than 1 or greater than XkbMaxKeyCount, 
.I XkbGetKeyBehaviors 
returns BadValue. If any allocation errors occur, 
.I XkbGetKeyBehaviors 
returns BadAlloc. 
.SH DIAGNOSTICS
.TP 15
.B BadAccess
The Xkb extension has not been properly initialized
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadValue
An argument is out of range
