.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\" Copyright \(co 2000  The XFree86 Project, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XmbDrawString __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XmbDrawString, XwcDrawString, Xutf8DrawString \- draw text using a single font set
.SH SYNTAX
.HP
void XmbDrawString\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, XFontSet
\fIfont_set\fP\^, GC \fIgc\fP\^, int \fIx\fP\^, int \fIy\fP\^,
_Xconst char *\fIstring\fP\^, int \fInum_bytes\fP\^);
.HP
void XwcDrawString\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, XFontSet
\fIfont_set\fP\^, GC \fIgc\fP\^, int \fIx\fP\^, int \fIy\fP\^,
_Xconst wchar_t *\fIstring\fP\^, int \fInum_wchars\fP\^);
.HP
void Xutf8DrawString\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^,
XFontSet \fIfont_set\fP\^, GC \fIgc\fP\^, int \fIx\fP\^, int \fIy\fP\^,
_Xconst char *\fIstring\fP\^, int \fInum_bytes\fP\^);
.SH ARGUMENTS
.IP \fId\fP 1i
Specifies the drawable.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIfont_set\fP 1i
Specifies the font set.
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fInum_bytes\fP 1i
Specifies the number of bytes in the string argument.
.IP \fInum_wchars\fP 1i
Specifies the number of characters in the string argument.
.IP \fIstring\fP 1i
Specifies the character string.
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates.
.SH DESCRIPTION
The
.BR XmbDrawString ,
.B XwcDrawString
and
.B Xutf8DrawString
functions draw the specified text with the foreground pixel.
When the
.B XFontSet
has missing charsets, each unavailable character is drawn
with the default string returned by
.BR XCreateFontSet .
The behavior for an invalid codepoint is undefined.
.LP
The function
.B Xutf8DrawString
is an extension introduced by The XFree86 Project, Inc., in their 4.0.2
release.
Its presence is
indicated by the macro
.BR X_HAVE_UTF8_STRING .
.SH "SEE ALSO"
XDrawImageString(__libmansuffix__),
XDrawString(__libmansuffix__),
XDrawText(__libmansuffix__),
XmbDrawImageString(__libmansuffix__),
XmbDrawText(__libmansuffix__)
.br
\fI\*(xL\fP
