/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtDisplayInitialize()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xatom.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

char *args11[] = {
	"-background", "green",
	"-bd", "green",
	"-bg", "green",
	"-borderwidth", "3",
	"-bordercolor", "red",
	"-bw", "3",
	"-fg", "green",
	"-font", XtDefaultFont,
	"-fn", XtDefaultFont,
	"-foreground", "blue",
	"-geometry", "100x100",
	"-iconic", 
	"-reverse",
	"-rv",
	"+rv",
	"-selectionTimeout", "50",
	"-synchronous",
	"+synchronous",
	"-title", "ApTest",
	"-xnlLanguage", "C",
	NULL};


typedef struct _instance_variables {
        long foreground;
        String label;
} instance_variable_rec;

static XtResource resources[] = {
        {
        XtNforeground,
        XtCForeground,
        XtRPixel, sizeof(Pixel),
        XtOffsetOf(instance_variable_rec, foreground),
        XtRString, "XtDefaultForeground"
        },
        {
        XtNlabel,
        XtCLabel,
        XtRString, sizeof(String),
        XtOffsetOf(instance_variable_rec, label),
        XtRString, "very bad idea"
        },
};


#define T_XtDisplayInitialize	1
char    *TestName = "XtDisplayInitialize";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
String name_good, class_good;
int argcount = 0;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtDisplayInitialize-1.(A)");
	report_assertion("A successful call to void XtDisplayInitialize(app_context,");
	report_assertion("display, application_name, application_class, options,");
	report_assertion("num_options, argc, argv) shall perform initialization for");
	report_assertion("the previously opened display connection specified by");
	report_assertion("display and add it to the application context app_context.");
	FORK(pid);
	initconfig();

	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("PREP: Open a display connection");
	sleep(config.reset_delay);
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Initialize display and add it to an application context.");
	XtDisplayInitialize(app_ctext, display_good, "tdsplyintl1",
	    "Tdsplyintl1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    (String *)NULL );
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("TEST: Get the application name and class");
	XtGetApplicationNameAndClass(display_good, &name_good,
		     &class_good );
	tet_infoline("TEST: Check the name and class are valid.");
	check_str("tdsplyintl1", name_good, "Name of Application");
	check_str("Tdsplyintl1", class_good, "Class of Application");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.10927 */
/* End of included file Mdefcode.tmc.10927 */

static void t002(){

Window window;
int scr;
static char *property_data = "Hello World";
XtAppContext app_ctext;
Display *display;
int queued_events, events;
int argc = 2;
    /*
    ** -synchronous on
    ** +synchronous off
    */
char *argv[] = { "tdsplyintl2", "-synchronous", NULL };
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtDisplayInitialize-2.(A)");
	report_assertion("When the synchronize resource is set to True in the");
	report_assertion("resource database created by a successful call to void");
	report_assertion("XtDisplayInitialize(app_context, display, application_name,");
	report_assertion("application_class, options, num_options, argc, argv) it");
	report_assertion("shall put Xlib into synchronous mode for this display");
	report_assertion("connection and any others currently open in the application");
	report_assertion("context app_context.");
	FORK(pid);
	initconfig();

	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("PREP: Open a display connection");
	sleep(config.reset_delay);
	display = XOpenDisplay(config.display);
	if (display == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Create a window for events");
	scr = DefaultScreen(display);
	window = XCreateWindow(display, RootWindow(display, scr),
	       0, 0, 5, 5, 0, /* x,y,wid,ht,brd width */
	       DefaultDepth(display, scr),
	       InputOutput,
	       DefaultVisual(display, scr),
	       (XtValueMask) 0,
	       (XSetWindowAttributes *) 0);
	tet_infoline("TEST: Initialize display and add it to an application context.");
	XtDisplayInitialize(app_ctext, display,
	    "tdsplyintl2",
	    "Tdsplyintl2",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0,
	&argc, &argv[0] );
	tet_infoline("TEST: Check Xlib is in synchronous mode");
	queued_events = XQLength(display);
	XSelectInput(display, window,
	     (unsigned long)PropertyChangeMask);
	for (events = 0; events < 3; events++)
		XChangeProperty(display, window, XA_RESOURCE_MANAGER,
			XA_STRING, 8,0, (unsigned char *)property_data, 16);
	check_dec(3+queued_events, XQLength(display), "queue length");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.10927 */
/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtDisplayInitialize-3.(B)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has been registered for the application context");
	report_assertion("app_context a successful call to void");
	report_assertion("XtDisplayInitialize(app_context, display, application_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("call the language procedure with a language string");
	report_assertion("determined by searching the following sources in the");
	report_assertion("specified order: - the -xnlLanguage resource or a -xrm");
	report_assertion("option containing the xnlLanguage/XnlLanguage resource");
	report_assertion("defined in the command line, - the resource");
	report_assertion("application_name.xnlLanguage, class");
	report_assertion("application_class.XnlLanguage in the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("if it exists, and in the user preference resource file");
	report_assertion("otherwise.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtDisplayInitialize-4.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has been registered for the application context");
	report_assertion("app_context a successful call to void");
	report_assertion("XtDisplayInitialize(app_context, display, application_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("call the procedure with the empty string if the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("exists and a language string is not found on the command");
	report_assertion("line or in this property.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtDisplayInitialize-5.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has been registered for the application context");
	report_assertion("app_context a successful call to void");
	report_assertion("XtDisplayInitialize(app_context, display, application_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("call the procedure with the empty string if the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("does not exist and a language string is not found on the");
	report_assertion("command line or in the user preference resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtDisplayInitialize-6.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has not been registered for the application");
	report_assertion("context app_context a successful call to void");
	report_assertion("XtDisplayInitialize(app_context, display, application_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("determine a language string for the display by searching the");
	report_assertion("following sources in the specified order: - the resource");
	report_assertion("database created from the command line. - the resource");
	report_assertion("application_name.xnlLanguage, class");
	report_assertion("application_class.XnlLanguage in the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("if it exists, or in the user preference resource file");
	report_assertion("otherwise. - the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtDisplayInitialize-7.(D)");
	report_assertion("If the implementation is X11R5 or later and is POSIX-based:");
	report_assertion("When a language procedure has not been registered for the");
	report_assertion("application context app_context a successful call to void");
	report_assertion("XtDisplayInitialize(app_context, display, application_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("use the LANG environment variable as the environment value");
	report_assertion("to search when determining the language string for the");
	report_assertion("display.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtDisplayInitialize-8.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has not been registered for the application");
	report_assertion("context app_context a successful call to void");
	report_assertion("XtDisplayInitialize(app_context, display, application_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("set the language string for the display to the empty string");
	report_assertion("if the server's RESOURCE_MANAGER property for the root");
	report_assertion("window of screen zero exists, and a language string is not");
	report_assertion("found on the command line, in this property, or in the");
	report_assertion("environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtDisplayInitialize-9.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has not been registered for the application");
	report_assertion("context app_context a successful call to void");
	report_assertion("XtDisplayInitialize(app_context, display, application_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("set the language string for the display to the empty string");
	report_assertion("if the server's RESOURCE_MANAGER property for the root");
	report_assertion("window of screen zero does not exist and a language string");
	report_assertion("is not found on the command line, in the user preference");
	report_assertion("resource file, or in the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtDisplayInitialize-10.(B)");
	report_assertion("A successful call to void XtDisplayInitialize(app_context,");
	report_assertion("display, application_name, application_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("associate with the default screen of the display a resource");
	report_assertion("database created by combining entries from the following");
	report_assertion("sources, in order, with the first named source having the");
	report_assertion("highest precedence: - the application command line - the");
	report_assertion("user's environment resource file - per-screen resource");
	report_assertion("specifications from the server, as returned by");
	report_assertion("XScreenResourceString() - per display resource");
	report_assertion("specifications from the server (the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen");
	report_assertion("zero) if they exist, otherwise the user preference file -");
	report_assertion("the application-specific user resource file. - the");
	report_assertion("application-specific class resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

static void t011(){

Display	*display_good;
String	name_good, class_good;
int	argcount = 20;
instance_variable_rec base;
pid_t pid2;
pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtDisplayInitialize-11.(A)");
	report_assertion("A successful call to void XtDisplayInitialize(app_context,");
	report_assertion("display, application_name, application_class, options,");
	report_assertion("num_options, argc, argv) shall recognize options specified");
	report_assertion("on the command line that are in the standard table of");
	report_assertion("options in section 4.4 of the specification or in the table");
	report_assertion("specific to the application specified by options and");
	report_assertion("num_options.");
	FORK(pid);
	initconfig();

        FORK(pid2);
	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("PREP: Open a display connection");
	sleep(config.reset_delay);
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Initialize display and add it to an application context.");
	XtDisplayInitialize(app_ctext, display_good, "tdsplyintl1",
	    "Tdsplyintl1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    args11);
	tet_infoline("TEST: Create top level widget");
	topLevel = XtAppCreateShell("Hello", "World",
		 applicationShellWidgetClass, display_good,
		 (ArgList)NULL, (Cardinal)0);
        tet_infoline("TEST: Retrieve resource values from resource database");
        XtGetApplicationResources(topLevel,
                        &base,
                        resources,
                        1,
                        (ArgList)NULL,
                        (Cardinal)0);
        tet_infoline("TEST: Retrieved resource value");
        if ((base.foreground != 0) && (base.foreground != 1)) {
                sprintf(ebuf, "ERROR: expected 0 or 1, received %d", base.foreground);
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
        LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.10927 */
/* End of included file Mdefcode.tmc.10927 */

static void t012(){

Window window;
int scr;
static char *property_data = "Hello World";
XtAppContext app_ctext;
Display *display;
int queued_events, events;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
int argc = 2;
char *argv[] = { "tdsplyintl2", "+rv", NULL };
Screen *screen;
Colormap colormap;
pid_t pid2;
Pixel res;
Boolean status;
pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtDisplayInitialize-12.(A)");
	report_assertion("A successful call to void XtDisplayInitialize(app_context,");
	report_assertion("display, application_name, application_class, options,");
	report_assertion("num_options, argc, argv) when the reverseVideo resource is");
	report_assertion("define as True on the command line shall use the value of");
	report_assertion("XtDefaultForeground instead of XtDefaultBackground and vice");
	report_assertion("versa in the resource database created for the display.");
	FORK(pid);
	initconfig();

        FORK(pid2);
	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("PREP: Open a display connection");
	sleep(config.reset_delay);
	display = XOpenDisplay(config.display);
	if (display == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Initializae display connection with +rv in args");
	XtDisplayInitialize(app_ctext, display, "tdsplyintl1",
	    "Tdsplyintl1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argc,
	    &argv[0] );
	tet_infoline("PREP: Set up required conversion args");
        screen = DefaultScreenOfDisplay(display);
        args[0].addr = (XtPointer )&screen;
        args[0].size = sizeof(Screen*);
        colormap = DefaultColormapOfScreen(screen);
        args[1].addr = (XtPointer) &colormap;
        args[1].size = sizeof(Colormap);
        num_args = 2;
        tet_infoline("TEST: Convert XtDefaultForeground");
        fromVal.addr = XtDefaultForeground;
        fromVal.size = strlen(XtDefaultForeground)+1;
        toVal.addr = (XtPointer) &res;
        toVal.size = sizeof(Pixel);
        status = XtCvtStringToPixel(display,
                        &args[0],
                        &num_args,
                        &fromVal,
                        &toVal,
                        &closure_ret);
        check_dec(True, status, "XtCvtStringToPixel return value");
        tet_infoline("TEST: Conversion result");
        check_dec(XBlackPixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
        tet_infoline("TEST: Convert XtDefaultBackground");
        fromVal.addr = XtDefaultBackground;
        fromVal.size = strlen(XtDefaultBackground)+1;
        toVal.addr = (XtPointer) &res;
        toVal.size = sizeof(Pixel);
        status = XtCvtStringToPixel(display,
                        &args[0],
                        &num_args,
                        &fromVal,
                        &toVal,
                        &closure_ret);
        check_dec(True, status, "XtCvtStringToPixel return value");
        tet_infoline("TEST: Conversion result");
        check_dec(XWhitePixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.10927 */
/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtDisplayInitialize-13.(B)");
	report_assertion("A successful call to void XtDisplayInitialize(app_context,");
	report_assertion("display, application_name, application_class, options,");
	report_assertion("num_options, argc, argv) when the application context");
	report_assertion("app_context has more than one display and the");
	report_assertion("selectionTimeout resource is specified on the command line");
	report_assertion("shall set this value in the selectionTimeout resource in the");
	report_assertion("resource databases of all the displays in the application");
	report_assertion("context.");
	report_assertion("Reason for omission: Testing the assertion would require an unreasonable amount of time or resources on most systems");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t014(){

pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtDisplayInitialize-14.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("void XtDisplayInitialize(app_context, display,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable XENVIRONMENT");
	report_assertion("exists shall use the value of this variable as the name of");
	report_assertion("the user environment resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t015(){

pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtDisplayInitialize-15.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("void XtDisplayInitialize(app_context, display,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable XENVIRONMENT does");
	report_assertion("not exist shall use the file.Xdefaults-host, where host is");
	report_assertion("the name of the system running the application, in the");
	report_assertion("user's home directory as the user environment resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t016(){

pid_t	pid;

 	report_purpose(16);

	report_assertion("Assertion XtDisplayInitialize-16.(B)");
	report_assertion("A successful call to void XtDisplayInitialize(app_context,");
	report_assertion("display, application_name, application_class, options,");
	report_assertion("num_options, argc, argv) shall set the values from the");
	report_assertion("higher precedence sources of the resource database being");
	report_assertion("created for the display as the current resource database");
	report_assertion("before determining the file name for the");
	report_assertion("application-specific user resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t017(){

pid_t	pid;

 	report_purpose(17);

	report_assertion("Assertion XtDisplayInitialize-17.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("void XtDisplayInitialize(app_context, display,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable");
	report_assertion("XUSERFILESEARCHPATH is defined shall use the result of");
	report_assertion("calling XtResolvePathname(display, path, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) with the value of this variable as path as");
	report_assertion("the name of the application-specific user resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t018(){

pid_t	pid;

 	report_purpose(18);

	report_assertion("Assertion XtDisplayInitialize-18.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("void XtDisplayInitialize(app_context, display,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable");
	report_assertion("XUSERFILESEARCHPATH is not defined and the environment");
	report_assertion("variable XAPPLRESDIR is not defined shall use the result of");
	report_assertion("calling XtResolvePathname(display, path, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) as the name of the application-specific user");
	report_assertion("resource file where path contains at least entries");
	report_assertion("containing $HOME as the directory prefix plus the following");
	report_assertion("substitutions, in the order specified: - %C, %N, %L or %C,");
	report_assertion("%N, %l, %t, %c - %C, %N, %l - %C, %N - %N, %L or %N, %l, %t,");
	report_assertion("%c - %N, %l - %N");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t019(){

pid_t	pid;

 	report_purpose(19);

	report_assertion("Assertion XtDisplayInitialize-19.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("void XtDisplayInitialize(app_context, display,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable");
	report_assertion("XUSERFILESEARCHPATH is not defined and the environment");
	report_assertion("variable XAPPLRESDIR is defined shall use the result of");
	report_assertion("calling XtResolvePathname(display, path, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) as the name of the application-specific user");
	report_assertion("resource file where path contains at least entries");
	report_assertion("containing the following directory prefixes and");
	report_assertion("substitutions, in the order specified: - $XPPLRESDIR with");
	report_assertion("%C, %N, %L or %C, %N, %l, %t, %c - $XPPLRESDIR with %C, %N,");
	report_assertion("%l - $XPPLRESDIR with %C, %N - $XPPLRESDIR with %N, %L or");
	report_assertion("%N, %l, %t, %c - $XPPLRESDIR with %N, %l - $XPPLRESDIR with");
	report_assertion("%N - $HOME with %N");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* Including from file Mdefcode.tmc.10927 */
static void t020(){

pid_t	pid;

 	report_purpose(20);

	report_assertion("Assertion XtDisplayInitialize-20.(B)");
	report_assertion("A successful call to void XtDisplayInitialize(app_context,");
	report_assertion("display, application_name, application_class, options,");
	report_assertion("num_options, argc, argv) shall use the result of calling");
	report_assertion("XtResolvePathname(display, app-defaults, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) as the name of the application-specific class");
	report_assertion("resource file, with the values from the higher precedence");
	report_assertion("sources of the resource database being created for the");
	report_assertion("display set as the current resource database before the call");
	report_assertion("is made.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.10927 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
